/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.config.HDIVValidations;
import org.hdiv.config.StartPage;
import org.hdiv.config.Strategy;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.regex.PatternMatcherFactory;
import org.hdiv.util.HDIVUtil;
import org.hdiv.validator.IValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDIVConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Strategy DEFAULT_STRATEGY = Strategy.MEMORY;
    private static final String DEFAULT_STATE_PARAMETER_NAME = "_HDIV_STATE_";
    private static final String DEFAULT_MODIFY_STATE_PARAMETER_NAME = "_MODIFY_HDIV_STATE_";
    protected transient PatternMatcherFactory patternMatcherFactory;
    protected List<StartPage> startPages = new ArrayList<StartPage>();
    protected List<PatternMatcher> startParameters = new ArrayList<PatternMatcher>();
    protected String errorPage;
    protected String sessionExpiredLoginPage;
    protected String sessionExpiredHomePage;
    protected boolean confidentiality = true;
    protected transient Map<PatternMatcher, List<PatternMatcher>> paramsWithoutValidation;
    protected HDIVValidations validations;
    protected boolean avoidCookiesIntegrity = false;
    protected boolean avoidCookiesConfidentiality = false;
    protected boolean avoidValidationInUrlsWithoutParams = false;
    protected List<PatternMatcher> protectedURLPatterns;
    protected List<String> excludedURLExtensions;
    protected boolean randomName = false;
    protected String stateParameterName = "_HDIV_STATE_";
    protected String modifyStateParameterName = "_MODIFY_HDIV_STATE_";
    protected Strategy strategy = DEFAULT_STRATEGY;
    protected boolean debugMode = false;
    protected boolean showErrorPageOnEditableValidation = false;
    protected boolean reuseExistingPageInAjaxRequest = false;
    protected Map<PatternMatcher, String> longLivingPages = new HashMap<PatternMatcher, String>();

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public boolean isStartParameter(String parameter) {
        for (PatternMatcher matcher : this.startParameters) {
            if (!matcher.matches(parameter)) continue;
            return true;
        }
        return false;
    }

    public boolean isStartPage(String target, String method) {
        if (method != null) {
            method = method.toUpperCase();
        }
        for (StartPage startPage : this.startPages) {
            PatternMatcher m = startPage.getCompiledPattern();
            if (!m.matches(target)) continue;
            if (startPage.isAnyMethod()) {
                return true;
            }
            if (!startPage.getMethod().equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExtensionToExclude(String path) {
        if (this.excludedURLExtensions == null) {
            return false;
        }
        if (path.indexOf("?") > 0) {
            path = path.substring(0, path.indexOf("?"));
        }
        if (path.equals("")) {
            return false;
        }
        if (path.equals("/") || path.charAt(path.length() - 1) == '/') {
            return false;
        }
        int pound = path.indexOf("#");
        if (pound >= 0) {
            path = path.substring(0, pound);
        }
        for (String extension : this.excludedURLExtensions) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterWithoutConfidentiality(String paramName) {
        String modifyHdivStateParameterName;
        return HDIVUtil.getHttpSession() != null && (modifyHdivStateParameterName = (String)HDIVUtil.getHttpSession().getAttribute("modifyHDIVStateParameter")) != null && modifyHdivStateParameterName.equals(paramName);
    }

    public boolean isParameterWithoutValidation(String action, String parameter) {
        if (action == null) {
            return false;
        }
        if (this.paramsWithoutValidation == null) {
            return false;
        }
        for (PatternMatcher matcher : this.paramsWithoutValidation.keySet()) {
            if (!matcher.matches(action)) continue;
            for (PatternMatcher paramMatcher : this.paramsWithoutValidation.get(matcher)) {
                if (!paramMatcher.matches(parameter)) continue;
                return true;
            }
        }
        return false;
    }

    public String isLongLivingPages(String url) {
        for (Map.Entry<PatternMatcher, String> page : this.longLivingPages.entrySet()) {
            PatternMatcher m = page.getKey();
            if (!m.matches(url)) continue;
            return page.getValue();
        }
        return null;
    }

    public boolean needValidation(String parameter, String hdivParameter) {
        return !this.isStartParameter(parameter) && !parameter.equals(hdivParameter);
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String errorPage) {
        if (errorPage != null && !errorPage.startsWith("/")) {
            errorPage = "/" + errorPage;
        }
        this.errorPage = errorPage;
        if (errorPage != null) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(errorPage);
            this.startPages.add(new StartPage(null, matcher));
        }
    }

    public String getSessionExpiredLoginPage() {
        return this.sessionExpiredLoginPage;
    }

    public void setSessionExpiredLoginPage(String sessionExpiredLoginPage) {
        if (sessionExpiredLoginPage != null && !sessionExpiredLoginPage.startsWith("/")) {
            sessionExpiredLoginPage = "/" + sessionExpiredLoginPage;
        }
        this.sessionExpiredLoginPage = sessionExpiredLoginPage;
        if (sessionExpiredLoginPage != null) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(sessionExpiredLoginPage);
            this.startPages.add(new StartPage(null, matcher));
        }
    }

    public String getSessionExpiredHomePage() {
        return this.sessionExpiredHomePage;
    }

    public void setSessionExpiredHomePage(String sessionExpiredHomePage) {
        if (sessionExpiredHomePage != null && !sessionExpiredHomePage.startsWith("/")) {
            sessionExpiredHomePage = "/" + sessionExpiredHomePage;
        }
        this.sessionExpiredHomePage = sessionExpiredHomePage;
        if (sessionExpiredHomePage != null) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(sessionExpiredHomePage);
            this.startPages.add(new StartPage(null, matcher));
        }
    }

    public boolean getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(boolean confidentiality) {
        this.confidentiality = confidentiality;
    }

    public void setParamsWithoutValidation(Map<String, List<String>> paramsWithoutValidation) {
        this.paramsWithoutValidation = new HashMap<PatternMatcher, List<PatternMatcher>>();
        for (String url : paramsWithoutValidation.keySet()) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(url);
            ArrayList<PatternMatcher> paramMatchers = new ArrayList<PatternMatcher>();
            for (String param : paramsWithoutValidation.get(url)) {
                PatternMatcher paramMatcher = this.patternMatcherFactory.getPatternMatcher(param);
                paramMatchers.add(paramMatcher);
            }
            this.paramsWithoutValidation.put(matcher, paramMatchers);
        }
    }

    public void setUserStartPages(List<StartPage> userStartPages) {
        for (StartPage startPage : userStartPages) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(startPage.getPattern());
            startPage.setCompiledPattern(matcher);
            this.startPages.add(startPage);
        }
    }

    public void setUserStartParameters(List<String> userStartParameters) {
        for (String useStartParameter : userStartParameters) {
            this.startParameters.add(this.patternMatcherFactory.getPatternMatcher(useStartParameter));
        }
    }

    public void setValidations(HDIVValidations validations) {
        this.validations = validations;
    }

    public boolean existValidations() {
        return this.validations != null && this.validations.getUrls() != null && this.validations.getUrls().size() > 0;
    }

    public boolean areEditableParameterValuesValid(String url, String parameter, String[] values, String dataType) {
        Map<PatternMatcher, List<IValidation>> urls = this.validations.getUrls();
        for (PatternMatcher matcher : urls.keySet()) {
            if (!matcher.matches(url)) continue;
            List<IValidation> userDefinedValidations = urls.get(matcher);
            for (int i = 0; i < userDefinedValidations.size(); ++i) {
                IValidation currentValidation = userDefinedValidations.get(i);
                if (currentValidation.validate(parameter, values, dataType)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isCookiesConfidentialityActivated() {
        return !this.avoidCookiesConfidentiality;
    }

    public void setAvoidCookiesConfidentiality(boolean avoidCookiesConfidentiality) {
        this.avoidCookiesConfidentiality = avoidCookiesConfidentiality;
    }

    public boolean isCookiesIntegrityActivated() {
        return !this.avoidCookiesIntegrity;
    }

    public void setAvoidCookiesIntegrity(boolean avoidCookiesIntegrity) {
        this.avoidCookiesIntegrity = avoidCookiesIntegrity;
    }

    public boolean isValidationInUrlsWithoutParamsActivated() {
        return !this.avoidValidationInUrlsWithoutParams;
    }

    public void setAvoidValidationInUrlsWithoutParams(Boolean avoidValidationInUrlsWithoutParams) {
        this.avoidValidationInUrlsWithoutParams = avoidValidationInUrlsWithoutParams;
    }

    public void setProtectedExtensions(List<String> protectedExtensions) {
        this.protectedURLPatterns = new ArrayList<PatternMatcher>();
        for (String protectedExtension : protectedExtensions) {
            this.protectedURLPatterns.add(this.patternMatcherFactory.getPatternMatcher(protectedExtension));
        }
    }

    public void setExcludedExtensions(List<String> excludedExtensions) {
        if (this.excludedURLExtensions == null) {
            this.excludedURLExtensions = new ArrayList<String>();
        }
        this.excludedURLExtensions.addAll(excludedExtensions);
    }

    public List<PatternMatcher> getProtectedURLPatterns() {
        return this.protectedURLPatterns;
    }

    public List<String> getExcludedURLExtensions() {
        return this.excludedURLExtensions;
    }

    public boolean isRandomName() {
        return this.randomName;
    }

    public void setRandomName(boolean randomName) {
        this.randomName = randomName;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isShowErrorPageOnEditableValidation() {
        return this.showErrorPageOnEditableValidation;
    }

    public void setShowErrorPageOnEditableValidation(boolean showErrorPageOnEditableValidation) {
        this.showErrorPageOnEditableValidation = showErrorPageOnEditableValidation;
    }

    public boolean isReuseExistingPageInAjaxRequest() {
        return this.reuseExistingPageInAjaxRequest;
    }

    public void setReuseExistingPageInAjaxRequest(boolean reuseExistingPageInAjaxRequest) {
        this.reuseExistingPageInAjaxRequest = reuseExistingPageInAjaxRequest;
    }

    public void setPatternMatcherFactory(PatternMatcherFactory patternMatcherFactory) {
        this.patternMatcherFactory = patternMatcherFactory;
    }

    public String getStateParameterName() {
        return this.stateParameterName;
    }

    public void setStateParameterName(String stateParameterName) {
        this.stateParameterName = stateParameterName;
    }

    public String getModifyStateParameterName() {
        return this.modifyStateParameterName;
    }

    public void setModifyStateParameterName(String modifyStateParameterName) {
        this.modifyStateParameterName = modifyStateParameterName;
    }

    public void setLongLivingPages(Map<String, String> longLivingPages) {
        for (Map.Entry<String, String> page : longLivingPages.entrySet()) {
            PatternMatcher pattern = this.patternMatcherFactory.getPatternMatcher(page.getKey());
            String scope = page.getValue();
            this.longLivingPages.put(pattern, scope);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer().append("");
        result = result.append(" Confidentiality=").append(this.getConfidentiality());
        result.append(" avoidCookiesIntegrity=").append(this.avoidCookiesIntegrity);
        result.append(" avoidCookiesConfidentiality=").append(this.avoidCookiesConfidentiality);
        result.append(" avoidValidationInUrlsWithoutParams=").append(this.avoidValidationInUrlsWithoutParams);
        result.append(" strategy=").append((Object)this.getStrategy());
        result.append(" randomName=").append(this.isRandomName());
        result.append(" errorPage=").append(this.getErrorPage());
        result.append(" sessionExpiredLoginPage=").append(this.sessionExpiredLoginPage);
        result.append(" sessionExpiredHomePage=").append(this.sessionExpiredHomePage);
        result.append(" excludedExtensions=").append(this.excludedURLExtensions);
        result.append(" protectedExtensions=").append(this.getProtectedURLPatterns());
        result.append(" startPages=").append(this.startPages);
        result.append(" startParameters=").append(this.startParameters);
        result.append(" paramsWithoutValidation=").append(this.paramsWithoutValidation);
        result.append(" longLivingPages=").append(this.longLivingPages);
        result.append(" debugMode=").append(this.debugMode);
        result.append(" showErrorPageOnEditableValidation=").append(this.showErrorPageOnEditableValidation);
        return result.toString();
    }
}

