/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.cipher;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.cipher.ICipherHTTP;
import org.hdiv.cipher.Key;
import org.hdiv.exception.HDIVException;
import org.hdiv.util.HDIVUtil;

public class CipherHTTP
implements ICipherHTTP {
    private static final long serialVersionUID = -1731737465730669951L;
    private Log log = LogFactory.getLog(CipherHTTP.class);
    private static final String DEFAULT_ALGORITHM = "AES/CBC/PKCS5Padding";
    private String transformation = "AES/CBC/PKCS5Padding";
    private String provider;
    private Cipher cipher;
    private IvParameterSpec ivSpec;
    private boolean encryptMode;

    public void init() {
        try {
            this.cipher = this.provider == null ? Cipher.getInstance(this.transformation) : Cipher.getInstance(this.transformation, this.provider);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("New CipherHTTP instance [cipher = " + this.cipher + "]"));
            }
        }
        catch (NoSuchProviderException e) {
            throw new HDIVException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HDIVException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new HDIVException(e.getMessage(), e);
        }
    }

    public void initEncryptMode(Key key) {
        try {
            this.ivSpec = new IvParameterSpec(key.getInitVector());
            this.cipher.init(1, (java.security.Key)key.getKey(), this.ivSpec);
            this.encryptMode = true;
        }
        catch (InvalidKeyException e) {
            String errorMessage = HDIVUtil.getMessage("cipher.init.encrypt", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            String errorMessage = HDIVUtil.getMessage("cipher.init.encrypt", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    public void initDecryptMode(Key key) {
        try {
            this.ivSpec = new IvParameterSpec(key.getInitVector());
            this.cipher.init(2, (java.security.Key)key.getKey(), this.ivSpec);
            this.encryptMode = false;
        }
        catch (InvalidKeyException e) {
            String errorMessage = HDIVUtil.getMessage("cipher.init.decrypt", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            String errorMessage = HDIVUtil.getMessage("cipher.init.decrypt", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    public byte[] encrypt(byte[] data) {
        try {
            return this.cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            String errorMessage = HDIVUtil.getMessage("cipher.encrypt", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
        catch (BadPaddingException e) {
            String errorMessage = HDIVUtil.getMessage("cipher.encrypt", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    public byte[] decrypt(byte[] data) {
        try {
            return this.cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            String errorMessage = HDIVUtil.getMessage("cipher.decrypt", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
        catch (BadPaddingException e) {
            String errorMessage = HDIVUtil.getMessage("cipher.decrypt", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    public void setTransformation(String transformation) {
        this.transformation = transformation;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public boolean isEncryptMode() {
        return this.encryptMode;
    }

    public void setEncryptMode(boolean encryptMode) {
        this.encryptMode = encryptMode;
    }
}

