/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.config.HDIVValidations;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.regex.PatternMatcherFactory;
import org.hdiv.validator.IValidation;
import org.springframework.beans.factory.config.AbstractFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationsFactoryBean
extends AbstractFactoryBean<HDIVValidations> {
    private transient PatternMatcherFactory patternMatcherFactory;
    protected Map<String, List<String>> validationsData;

    public Class<?> getObjectType() {
        return HDIVValidations.class;
    }

    protected HDIVValidations createInstance() throws Exception {
        HDIVValidations validations = new HDIVValidations();
        HashMap<PatternMatcher, List<IValidation>> urls = new HashMap<PatternMatcher, List<IValidation>>();
        for (String url : this.validationsData.keySet()) {
            List<String> ids = this.validationsData.get(url);
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(url);
            urls.put(matcher, this.createValidationList(ids));
        }
        validations.setUrls(urls);
        return validations;
    }

    private List<IValidation> createValidationList(List<String> ids) {
        ArrayList<IValidation> newList = new ArrayList<IValidation>();
        for (String id : ids) {
            Object bean = this.getBeanFactory().getBean(id);
            if (bean instanceof IValidation) {
                IValidation validation = (IValidation)bean;
                newList.add(validation);
                continue;
            }
            if (!(bean instanceof List)) continue;
            List validations = (List)bean;
            newList.addAll(validations);
        }
        return newList;
    }

    public void setPatternMatcherFactory(PatternMatcherFactory patternMatcherFactory) {
        this.patternMatcherFactory = patternMatcherFactory;
    }

    public void setValidationsData(Map<String, List<String>> validationsData) {
        this.validationsData = validationsData;
    }
}

