/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation.thymeleaf;

import org.hdiv.config.annotation.condition.ConditionalOnFramework;
import org.hdiv.config.annotation.condition.SupportedFramework;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.web.servlet.support.ThymeleafHdivRequestDataValueProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

@Configuration
@ConditionalOnFramework(value=SupportedFramework.THYMELEAF)
public class ThymeleafConfigurationSupport {
    protected static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor", (ClassLoader)ThymeleafConfigurationSupport.class.getClassLoader());
    @Autowired
    protected FormUrlProcessor formUrlProcessor;
    @Autowired
    protected LinkUrlProcessor linkUrlProcessor;

    @Bean(name={"requestDataValueProcessor"})
    public RequestDataValueProcessor requestDataValueProcessor() {
        ThymeleafHdivRequestDataValueProcessor dataValueProcessor = new ThymeleafHdivRequestDataValueProcessor();
        dataValueProcessor.setFormUrlProcessor(this.formUrlProcessor);
        dataValueProcessor.setLinkUrlProcessor(this.linkUrlProcessor);
        if (springSecurityPresent) {
            dataValueProcessor.setInnerRequestDataValueProcessor((RequestDataValueProcessor)new CsrfRequestDataValueProcessor());
        }
        return dataValueProcessor;
    }
}

