/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation.jsf;

import org.hdiv.config.HDIVConfig;
import org.hdiv.config.annotation.condition.ConditionalOnFramework;
import org.hdiv.config.annotation.condition.SupportedFramework;
import org.hdiv.config.multipart.JsfMultipartConfig;
import org.hdiv.context.RedirectHelper;
import org.hdiv.dataComposer.DataComposerFactory;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.events.HDIVFacesEventListener;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.JsfValidatorHelper;
import org.hdiv.logs.Logger;
import org.hdiv.session.ISession;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.urlProcessor.BasicUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.validators.ComponentValidator;
import org.hdiv.validators.EditableValidator;
import org.hdiv.validators.HtmlInputHiddenValidator;
import org.hdiv.validators.RequestParameterValidator;
import org.hdiv.validators.UICommandValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnFramework(value=SupportedFramework.JSF)
public class JsfConfigurationSupport {
    @Autowired
    private Logger logger;
    @Autowired
    private StateUtil stateUtil;
    @Autowired
    private HDIVConfig config;
    @Autowired
    private ISession session;
    @Autowired
    private IDataValidator dataValidator;
    @Autowired
    private BasicUrlProcessor basicUrlProcessor;
    @Autowired
    private DataComposerFactory dataComposerFactory;
    @Autowired
    private LinkUrlProcessor linkUrlProcessor;
    @Autowired
    private StateScopeManager stateScopeManager;

    @Bean
    @Primary
    public IValidationHelper jsfValidatorHelper() {
        JsfValidatorHelper validatorHelperRequest = new JsfValidatorHelper();
        validatorHelperRequest.setLogger(this.logger);
        validatorHelperRequest.setStateUtil(this.stateUtil);
        validatorHelperRequest.setHdivConfig(this.config);
        validatorHelperRequest.setSession(this.session);
        validatorHelperRequest.setDataValidator(this.dataValidator);
        validatorHelperRequest.setUrlProcessor(this.basicUrlProcessor);
        validatorHelperRequest.setDataComposerFactory(this.dataComposerFactory);
        validatorHelperRequest.setStateScopeManager(this.stateScopeManager);
        validatorHelperRequest.init();
        return validatorHelperRequest;
    }

    @Bean
    public RedirectHelper redirectHelper() {
        RedirectHelper redirectHelper = new RedirectHelper();
        redirectHelper.setLinkUrlProcessor(this.linkUrlProcessor);
        return redirectHelper;
    }

    @Bean
    public JsfMultipartConfig jsfMultipartConfig() {
        JsfMultipartConfig multipartConfig = new JsfMultipartConfig();
        return multipartConfig;
    }

    @Bean
    public HDIVFacesEventListener hdivFacesEventListener() {
        RequestParameterValidator requestParameterValidator = new RequestParameterValidator();
        requestParameterValidator.setHdivConfig(this.config);
        UICommandValidator uiCommandValidator = new UICommandValidator();
        HtmlInputHiddenValidator htmlInputHiddenValidator = new HtmlInputHiddenValidator();
        EditableValidator editableValidator = new EditableValidator();
        editableValidator.setHdivConfig(this.config);
        HDIVFacesEventListener listener = new HDIVFacesEventListener();
        listener.setConfig(this.config);
        listener.setLogger(this.logger);
        listener.setHtmlInputHiddenValidator((ComponentValidator)htmlInputHiddenValidator);
        listener.setRequestParamValidator((ComponentValidator)requestParameterValidator);
        listener.setUiCommandValidator((ComponentValidator)uiCommandValidator);
        listener.setEditableValidator(editableValidator);
        return listener;
    }
}

