/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation.builders;

import org.hdiv.config.HDIVConfig;
import org.hdiv.config.Strategy;
import org.hdiv.regex.PatternMatcherFactory;

public class SecurityConfigBuilder {
    private HDIVConfig config;
    private int maxPagesPerSession;
    private SessionExpiredConfigure sessionExpiredConfigure = new SessionExpiredConfigure();
    private CipherConfigure cipherConfigure = new CipherConfigure();

    public SecurityConfigBuilder(PatternMatcherFactory patternMatcherFactory) {
        this.config = new HDIVConfig();
        this.config.setPatternMatcherFactory(patternMatcherFactory);
    }

    public SecurityConfigBuilder cookiesConfidentiality(boolean cookiesConfidentiality) {
        this.config.setAvoidCookiesConfidentiality(!cookiesConfidentiality);
        return this;
    }

    public SecurityConfigBuilder cookiesIntegrity(boolean cookiesIntegrity) {
        this.config.setAvoidCookiesIntegrity(!cookiesIntegrity);
        return this;
    }

    public SecurityConfigBuilder reuseExistingPageInAjaxRequest(boolean reuseExistingPageInAjaxRequest) {
        this.config.setReuseExistingPageInAjaxRequest(reuseExistingPageInAjaxRequest);
        return this;
    }

    public SecurityConfigBuilder validateUrlsWithoutParams(boolean validateUrlsWithoutParams) {
        this.config.setAvoidValidationInUrlsWithoutParams(Boolean.valueOf(!validateUrlsWithoutParams));
        return this;
    }

    public SecurityConfigBuilder confidentiality(boolean confidentiality) {
        this.config.setConfidentiality(confidentiality);
        return this;
    }

    public SecurityConfigBuilder debugMode(boolean debugMode) {
        this.config.setDebugMode(debugMode);
        return this;
    }

    public SecurityConfigBuilder errorPage(String errorPage) {
        this.config.setErrorPage(errorPage);
        return this;
    }

    public SecurityConfigBuilder randomName(boolean randomName) {
        this.config.setRandomName(randomName);
        return this;
    }

    public SecurityConfigBuilder showErrorPageOnEditableValidation(boolean showErrorPageOnEditableValidation) {
        this.config.setShowErrorPageOnEditableValidation(showErrorPageOnEditableValidation);
        return this;
    }

    public SecurityConfigBuilder strategy(Strategy strategy) {
        this.config.setStrategy(strategy);
        return this;
    }

    public SecurityConfigBuilder stateParameterName(String stateParameterName) {
        this.config.setStateParameterName(stateParameterName);
        return this;
    }

    public SecurityConfigBuilder modifyStateParameterName(String modifyStateParameterName) {
        this.config.setModifyStateParameterName(modifyStateParameterName);
        return this;
    }

    public SecurityConfigBuilder maxPagesPerSession(int maxPagesPerSession) {
        this.maxPagesPerSession = maxPagesPerSession;
        return this;
    }

    public SessionExpiredConfigure sessionExpired() {
        return this.sessionExpiredConfigure;
    }

    public CipherConfigure cipher() {
        return this.cipherConfigure;
    }

    public CipherConfigure getCipherConfigure() {
        return this.cipherConfigure;
    }

    public HDIVConfig build() {
        return this.config;
    }

    public int getMaxPagesPerSession() {
        return this.maxPagesPerSession;
    }

    public class CipherConfigure {
        private String provider;
        private String algorithm;
        private String prngAlgorithm;
        private String transformation;
        private int keySize;

        public String getProvider() {
            return this.provider;
        }

        public CipherConfigure provider(String provider) {
            this.provider = provider;
            return this;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public CipherConfigure algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public String getPrngAlgorithm() {
            return this.prngAlgorithm;
        }

        public CipherConfigure prngAlgorithm(String prngAlgorithm) {
            this.prngAlgorithm = prngAlgorithm;
            return this;
        }

        public String getTransformation() {
            return this.transformation;
        }

        public CipherConfigure transformation(String transformation) {
            this.transformation = transformation;
            return this;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public CipherConfigure keySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public SecurityConfigBuilder and() {
            return SecurityConfigBuilder.this;
        }
    }

    public class SessionExpiredConfigure {
        public SessionExpiredConfigure homePage(String sessionExpiredHomePage) {
            SecurityConfigBuilder.this.config.setSessionExpiredHomePage(sessionExpiredHomePage);
            return this;
        }

        public SessionExpiredConfigure loginPage(String sessionExpiredLoginPage) {
            SecurityConfigBuilder.this.config.setSessionExpiredLoginPage(sessionExpiredLoginPage);
            return this;
        }

        public SecurityConfigBuilder and() {
            return SecurityConfigBuilder.this;
        }
    }
}

