/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.config.annotation.RuleRegistration;
import org.hdiv.validator.IValidation;
import org.hdiv.validator.Validation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleRegistry {
    private final List<RuleRegistration> registrations = new ArrayList<RuleRegistration>();

    public RuleRegistration addRule(String name) {
        Assert.notNull((Object)name, (String)"Rule name is required");
        RuleRegistration registration = new RuleRegistration(name);
        this.registrations.add(registration);
        return registration;
    }

    protected Map<String, IValidation> getRules() {
        HashMap<String, IValidation> rules = new HashMap<String, IValidation>();
        for (RuleRegistration regitration : this.registrations) {
            Validation rule = regitration.getRule();
            rules.put(rule.getName(), (IValidation)rule);
        }
        return rules;
    }
}

