/*
 * Decompiled with CFR 0.152.
 */
package org.happypeng.sumatora.android.superrubyspan.tools;

import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.RelativeSizeSpan;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.happypeng.sumatora.android.superrubyspan.SuperReplacementSpan;
import org.happypeng.sumatora.android.superrubyspan.SuperRubySpan;

public abstract class JapaneseText {
    private static final Pattern m_examplePattern = Pattern.compile("\\{([^\\};]+);([^\\};]+)\\}");

    public static void spannify(SpannableStringBuilder aSpannableStringBuilder, String aString) {
        int offset = 0;
        int insertPos = aSpannableStringBuilder.length();
        while (offset < aString.length()) {
            int nextOffset = aString.offsetByCodePoints(offset, 1);
            String substring = aString.substring(offset, nextOffset);
            int substringLength = substring.length();
            aSpannableStringBuilder.append((CharSequence)substring);
            aSpannableStringBuilder.setSpan((Object)new SuperReplacementSpan(), insertPos, insertPos + substringLength, 33);
            insertPos += substringLength;
            offset = nextOffset;
        }
    }

    public static void spannifyWithFurigana(SpannableStringBuilder aSpannableStringBuilder, String aString, float aRelativeSize) {
        Matcher matcher = m_examplePattern.matcher(aString);
        int previousMatchEnd = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            if (matchStart > previousMatchEnd) {
                JapaneseText.spannify(aSpannableStringBuilder, aString.substring(previousMatchEnd, matchStart));
            }
            String text = matcher.group(1);
            String furigana = matcher.group(2);
            int spanStart = aSpannableStringBuilder.length();
            if (text != null) {
                aSpannableStringBuilder.append((CharSequence)text);
                if (furigana != null) {
                    SpannableString furiganaSpannable = new SpannableString((CharSequence)furigana);
                    furiganaSpannable.setSpan((Object)new RelativeSizeSpan(aRelativeSize), 0, furiganaSpannable.length(), 33);
                    aSpannableStringBuilder.setSpan((Object)new SuperRubySpan((CharSequence)furiganaSpannable, 4, 4), spanStart, spanStart + text.length(), 33);
                }
            }
            previousMatchEnd = matcher.end();
        }
        if (previousMatchEnd < aString.length() - 1) {
            JapaneseText.spannify(aSpannableStringBuilder, aString.substring(previousMatchEnd, aString.length() - 1));
        }
    }
}

