/*
 * Decompiled with CFR 0.152.
 */
package org.happypeng.sumatora.android.superrubyspan;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SuperReplacementSpan
extends ReplacementSpan {
    final int mAlignment;

    private List<CharSequenceElement> getCharSequenceElements(@NonNull CharSequence text, int start, int end) {
        Spanned textSpanned = text instanceof Spanned ? (Spanned)text : null;
        List<ReplacementSpan> replacementSpans = textSpanned != null ? this.getSpans(textSpanned, start, end, ReplacementSpan.class) : null;
        List<MetricAffectingSpan> metricAffectingSpans = textSpanned != null ? this.getSpans(textSpanned, start, end, MetricAffectingSpan.class) : null;
        List<CharacterStyle> characterStyles = textSpanned != null ? this.getSpans(textSpanned, start, end, CharacterStyle.class) : null;
        String textString = text.toString();
        LinkedList<CharSequenceElement> charSequenceElements = new LinkedList<CharSequenceElement>();
        int cursor = start;
        while (cursor < end) {
            int nextCursor = textString.offsetByCodePoints(cursor, 1);
            LinkedList<MetricAffectingSpan> metricAffectingSpansSub = null;
            LinkedList<CharacterStyle> characterStylesSub = null;
            if (textSpanned != null) {
                int spanEnd;
                int spanStart;
                LinkedList<ReplacementSpan> replacementSpansSub = null;
                for (ReplacementSpan replacementSpan : replacementSpans) {
                    spanStart = textSpanned.getSpanStart((Object)replacementSpan);
                    spanEnd = textSpanned.getSpanEnd((Object)replacementSpan);
                    if (spanStart < cursor) continue;
                    if (replacementSpansSub == null) {
                        replacementSpansSub = new LinkedList<ReplacementSpan>();
                    }
                    replacementSpansSub.add(replacementSpan);
                    if (spanEnd <= nextCursor) continue;
                    nextCursor = spanEnd;
                }
                if (replacementSpansSub != null) {
                    charSequenceElements.add(new CharSequenceElement(cursor, nextCursor, replacementSpansSub, null, null));
                    cursor = nextCursor;
                    continue;
                }
                for (MetricAffectingSpan metricAffectingSpan : metricAffectingSpans) {
                    spanStart = textSpanned.getSpanStart((Object)metricAffectingSpan);
                    spanEnd = textSpanned.getSpanEnd((Object)metricAffectingSpan);
                    if (spanStart > cursor || spanEnd < nextCursor) continue;
                    if (metricAffectingSpansSub == null) {
                        metricAffectingSpansSub = new LinkedList<MetricAffectingSpan>();
                    }
                    metricAffectingSpansSub.add(metricAffectingSpan);
                }
                for (CharacterStyle characterStyle : characterStyles) {
                    spanStart = textSpanned.getSpanStart((Object)characterStyle);
                    spanEnd = textSpanned.getSpanEnd((Object)characterStyle);
                    if (spanStart > cursor || spanEnd < nextCursor) continue;
                    if (characterStylesSub == null) {
                        characterStylesSub = new LinkedList<CharacterStyle>();
                    }
                    characterStylesSub.add(characterStyle);
                }
            }
            charSequenceElements.add(new CharSequenceElement(cursor, nextCursor, null, metricAffectingSpansSub, characterStylesSub));
            cursor = nextCursor;
        }
        return charSequenceElements;
    }

    private static void mergeFontMetricsInt(@NonNull Paint.FontMetricsInt baseFontMetricsInt, @NonNull Paint.FontMetricsInt newFontMetricsInt) {
        baseFontMetricsInt.leading = Math.max(baseFontMetricsInt.leading, newFontMetricsInt.leading);
        baseFontMetricsInt.descent = Math.max(baseFontMetricsInt.descent, newFontMetricsInt.descent);
        baseFontMetricsInt.bottom = Math.max(baseFontMetricsInt.bottom, newFontMetricsInt.bottom);
        baseFontMetricsInt.ascent = Math.min(baseFontMetricsInt.ascent, newFontMetricsInt.ascent);
        baseFontMetricsInt.top = Math.min(baseFontMetricsInt.top, newFontMetricsInt.top);
    }

    private static void centerText(@NonNull TextSizeInformation textSizeInformation, float size) {
        Iterator<CharSequenceSizedElement> charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        int count = 0;
        float extraSpace = size - textSizeInformation.size;
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (count == 0) {
                charSequenceSizedElement.spaceBefore = extraSpace / 2.0f;
            }
            if (!charSequenceElementIterator.hasNext()) {
                charSequenceSizedElement.spaceAfter = extraSpace / 2.0f;
            }
            ++count;
        }
    }

    private static void alignTextLeft(@NonNull TextSizeInformation textSizeInformation, float size) {
        Iterator<CharSequenceSizedElement> charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        int count = 0;
        float extraSpace = size - textSizeInformation.size;
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (!charSequenceElementIterator.hasNext()) {
                charSequenceSizedElement.spaceAfter = extraSpace;
            }
            ++count;
        }
    }

    private static void alignTextRight(@NonNull TextSizeInformation textSizeInformation, float size) {
        Iterator<CharSequenceSizedElement> charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        int count = 0;
        float extraSpace = size - textSizeInformation.size;
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (count == 0) {
                charSequenceSizedElement.spaceBefore = extraSpace;
            }
            ++count;
        }
    }

    private static void justifyText(@NonNull TextSizeInformation textSizeInformation, float size, boolean jis) {
        float divider = 0.0f;
        int count = 0;
        if (textSizeInformation.charSequenceSizedElements.size() == 1) {
            SuperReplacementSpan.centerText(textSizeInformation, size);
            return;
        }
        Iterator<CharSequenceSizedElement> charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (charSequenceElementIterator.hasNext()) {
                divider += charSequenceSizedElement.size / 2.0f;
            }
            if (count != 0) {
                divider += charSequenceSizedElement.size / 2.0f;
            }
            if (jis) {
                if (!charSequenceElementIterator.hasNext()) {
                    divider += charSequenceSizedElement.size / 2.0f;
                }
                if (count == 0) {
                    divider += charSequenceSizedElement.size / 2.0f;
                }
            }
            ++count;
        }
        float extraSpaceUnit = (size - textSizeInformation.size) / divider;
        count = 0;
        charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (charSequenceElementIterator.hasNext()) {
                charSequenceSizedElement.spaceAfter = charSequenceSizedElement.size * extraSpaceUnit / 2.0f;
            }
            if (count != 0) {
                charSequenceSizedElement.spaceBefore = charSequenceSizedElement.size * extraSpaceUnit / 2.0f;
            }
            if (jis) {
                if (!charSequenceElementIterator.hasNext()) {
                    charSequenceSizedElement.spaceAfter += charSequenceSizedElement.size * extraSpaceUnit / 2.0f;
                }
                if (count == 0) {
                    charSequenceSizedElement.spaceBefore += charSequenceSizedElement.size * extraSpaceUnit / 2.0f;
                }
            }
            ++count;
        }
    }

    TextSizeInformation getTextSize(@NonNull Paint paint, @NonNull CharSequence text, int start, int end) {
        List<CharSequenceElement> charSequenceElements = this.getCharSequenceElements(text, start, end);
        Paint.FontMetricsInt fm = new Paint.FontMetricsInt();
        LinkedList<CharSequenceSizedElement> charSequenceSizedElements = new LinkedList<CharSequenceSizedElement>();
        int size = 0;
        for (CharSequenceElement charSequenceElement : charSequenceElements) {
            float elementSize;
            Object fontMetricsInt;
            if (charSequenceElement.replacementSpans != null) {
                ReplacementSpan replacementSpan = charSequenceElement.replacementSpans.get(charSequenceElement.replacementSpans.size() - 1);
                fontMetricsInt = new Paint.FontMetricsInt();
                elementSize = replacementSpan.getSize(paint, text, charSequenceElement.start, charSequenceElement.end, (Paint.FontMetricsInt)fontMetricsInt);
                charSequenceSizedElements.add(new CharSequenceSizedElement(charSequenceElement, elementSize, new TextPaint(paint), (Paint.FontMetricsInt)fontMetricsInt));
                size = (int)((float)size + elementSize);
                SuperReplacementSpan.mergeFontMetricsInt(fm, (Paint.FontMetricsInt)fontMetricsInt);
                continue;
            }
            TextPaint textPaint = new TextPaint(paint);
            if (charSequenceElement.metricAffectingSpans != null) {
                for (MetricAffectingSpan metricAffectingSpan : charSequenceElement.metricAffectingSpans) {
                    metricAffectingSpan.updateMeasureState(textPaint);
                }
            }
            if (charSequenceElement.characterStyles != null) {
                for (CharacterStyle characterStyle : charSequenceElement.characterStyles) {
                    characterStyle.updateDrawState(textPaint);
                }
            }
            fontMetricsInt = textPaint.getFontMetricsInt();
            elementSize = textPaint.measureText(text, charSequenceElement.start, charSequenceElement.end);
            charSequenceSizedElements.add(new CharSequenceSizedElement(charSequenceElement, elementSize, textPaint, (Paint.FontMetricsInt)fontMetricsInt));
            size = (int)((float)size + elementSize);
            SuperReplacementSpan.mergeFontMetricsInt(fm, (Paint.FontMetricsInt)fontMetricsInt);
        }
        return new TextSizeInformation(fm, size, charSequenceSizedElements);
    }

    private static void drawBackground(@NonNull CharSequenceSizedElement aCharSequenceSizedElement, @NonNull Canvas aCanvas, float aX, int aY, boolean aFirstChar, boolean aLastChar) {
        if (aCharSequenceSizedElement.textPaint.bgColor != 0) {
            float left = aFirstChar ? aX + aCharSequenceSizedElement.spaceBefore : aX;
            float right = aLastChar ? aX + aCharSequenceSizedElement.spaceBefore + aCharSequenceSizedElement.size : aX + aCharSequenceSizedElement.spaceBefore + aCharSequenceSizedElement.size + aCharSequenceSizedElement.spaceAfter;
            int previousColor = aCharSequenceSizedElement.textPaint.getColor();
            Paint.Style previousStyle = aCharSequenceSizedElement.textPaint.getStyle();
            aCharSequenceSizedElement.textPaint.setColor(aCharSequenceSizedElement.textPaint.bgColor);
            aCharSequenceSizedElement.textPaint.setStyle(Paint.Style.FILL);
            aCanvas.drawRect(left, (float)(aY + aCharSequenceSizedElement.fontMetricsInt.top), right, (float)(aY + aCharSequenceSizedElement.fontMetricsInt.bottom), (Paint)aCharSequenceSizedElement.textPaint);
            aCharSequenceSizedElement.textPaint.setStyle(previousStyle);
            aCharSequenceSizedElement.textPaint.setColor(previousColor);
        }
    }

    static void drawText(@NonNull CharSequence aText, @NonNull TextSizeInformation aTextSizeInformation, int aAlignment, @NonNull Canvas aCanvas, float aSpanSize, float aStartX, int aY, int aTop, int aBottom) {
        switch (aAlignment) {
            case 0: {
                SuperReplacementSpan.alignTextLeft(aTextSizeInformation, aSpanSize);
                break;
            }
            case 2: {
                SuperReplacementSpan.centerText(aTextSizeInformation, aSpanSize);
                break;
            }
            case 1: {
                SuperReplacementSpan.alignTextRight(aTextSizeInformation, aSpanSize);
                break;
            }
            case 3: {
                SuperReplacementSpan.justifyText(aTextSizeInformation, aSpanSize, false);
                break;
            }
            case 4: {
                SuperReplacementSpan.justifyText(aTextSizeInformation, aSpanSize, true);
            }
        }
        float cursor = aStartX;
        int count = 0;
        for (CharSequenceSizedElement charSequenceSizedElement : aTextSizeInformation.charSequenceSizedElements) {
            SuperReplacementSpan.drawBackground(charSequenceSizedElement, aCanvas, cursor, aY, cursor == 0.0f, count == aTextSizeInformation.charSequenceSizedElements.size() - 1);
            if (charSequenceSizedElement.charSequenceElement.replacementSpans != null && charSequenceSizedElement.charSequenceElement.replacementSpans.size() > 0) {
                ReplacementSpan replacementSpan = charSequenceSizedElement.charSequenceElement.replacementSpans.get(charSequenceSizedElement.charSequenceElement.replacementSpans.size() - 1);
                if (replacementSpan instanceof SuperReplacementSpan) {
                    ((SuperReplacementSpan)replacementSpan).drawExpanded(aCanvas, aText, charSequenceSizedElement.charSequenceElement.start, charSequenceSizedElement.charSequenceElement.end, cursor, aTop, aY, aBottom, (Paint)charSequenceSizedElement.textPaint, charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size + charSequenceSizedElement.spaceAfter);
                } else {
                    replacementSpan.draw(aCanvas, aText, charSequenceSizedElement.charSequenceElement.start, charSequenceSizedElement.charSequenceElement.end, cursor + charSequenceSizedElement.spaceBefore, aTop, aY, aBottom, (Paint)charSequenceSizedElement.textPaint);
                }
            } else {
                float scaleX;
                if (charSequenceSizedElement.spaceBefore != 0.0f && count != 0) {
                    float spaceSize = charSequenceSizedElement.textPaint.measureText(" ");
                    scaleX = charSequenceSizedElement.textPaint.getTextScaleX();
                    charSequenceSizedElement.textPaint.setTextScaleX(charSequenceSizedElement.spaceBefore / spaceSize);
                    aCanvas.drawText(" ", 0, 1, cursor, (float)aY, (Paint)charSequenceSizedElement.textPaint);
                    charSequenceSizedElement.textPaint.setTextScaleX(scaleX);
                }
                aCanvas.drawText(aText, charSequenceSizedElement.charSequenceElement.start, charSequenceSizedElement.charSequenceElement.end, cursor + charSequenceSizedElement.spaceBefore, (float)aY, (Paint)charSequenceSizedElement.textPaint);
                if (charSequenceSizedElement.spaceAfter != 0.0f && count != aTextSizeInformation.charSequenceSizedElements.size() - 1) {
                    float spaceSize = charSequenceSizedElement.textPaint.measureText(" ");
                    scaleX = charSequenceSizedElement.textPaint.getTextScaleX();
                    charSequenceSizedElement.textPaint.setTextScaleX(charSequenceSizedElement.spaceAfter / spaceSize);
                    aCanvas.drawText(" ", 0, 1, cursor + charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size, (float)aY, (Paint)charSequenceSizedElement.textPaint);
                    charSequenceSizedElement.textPaint.setTextScaleX(scaleX);
                }
            }
            cursor += charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size + charSequenceSizedElement.spaceAfter;
            ++count;
        }
    }

    private <T> List<T> getSpans(@NonNull Spanned text, int start, int end, Class<T> type) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Object span : text.getSpans(start, end, type)) {
            if (span != this) {
                list.add(span);
                continue;
            }
            if (type == SuperReplacementSpan.class) break;
        }
        return list;
    }

    public SuperReplacementSpan(int aAlignment) {
        this.mAlignment = aAlignment;
    }

    public SuperReplacementSpan() {
        this(2);
    }

    void drawExpanded(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint, float expandedSpanSize) {
        TextSizeInformation textSizeInformation = this.getTextSize(paint, text, start, end);
        SuperReplacementSpan.drawText(text, textSizeInformation, this.mAlignment, canvas, textSizeInformation.size, x, y, top, bottom);
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        TextSizeInformation textSizeInformation = this.getTextSize(paint, text, start, end);
        if (fm != null) {
            fm.bottom = textSizeInformation.fontMetricsInt.bottom;
            fm.ascent = textSizeInformation.fontMetricsInt.ascent;
            fm.top = textSizeInformation.fontMetricsInt.ascent;
            fm.descent = textSizeInformation.fontMetricsInt.descent;
            fm.leading = textSizeInformation.fontMetricsInt.leading;
        }
        return Math.round(textSizeInformation.size);
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        this.drawExpanded(canvas, text, start, end, x, top, y, bottom, paint, 0.0f);
    }

    static class CharSequenceSizedElement {
        final CharSequenceElement charSequenceElement;
        final float size;
        final TextPaint textPaint;
        final Paint.FontMetricsInt fontMetricsInt;
        float spaceBefore;
        float spaceAfter;

        CharSequenceSizedElement(CharSequenceElement aCharSequenceElement, float aSize, TextPaint aTextPaint, Paint.FontMetricsInt aFontMetricsInt) {
            this.charSequenceElement = aCharSequenceElement;
            this.size = aSize;
            this.textPaint = aTextPaint;
            this.fontMetricsInt = aFontMetricsInt;
            this.spaceBefore = 0.0f;
            this.spaceAfter = 0.0f;
        }
    }

    static class CharSequenceElement {
        final int start;
        final int end;
        final List<ReplacementSpan> replacementSpans;
        final List<MetricAffectingSpan> metricAffectingSpans;
        final List<CharacterStyle> characterStyles;

        CharSequenceElement(int aStart, int aEnd, List<ReplacementSpan> aReplacementSpans, List<MetricAffectingSpan> aMetricAffectingSpans, List<CharacterStyle> aCharacterStyles) {
            this.start = aStart;
            this.end = aEnd;
            this.replacementSpans = aReplacementSpans;
            this.metricAffectingSpans = aMetricAffectingSpans;
            this.characterStyles = aCharacterStyles;
        }
    }

    static class TextSizeInformation {
        final Paint.FontMetricsInt fontMetricsInt;
        final float size;
        final List<CharSequenceSizedElement> charSequenceSizedElements;

        TextSizeInformation(Paint.FontMetricsInt aFontMetricsInt, float aSize, List<CharSequenceSizedElement> aCharSequenceSizedElements) {
            this.fontMetricsInt = aFontMetricsInt;
            this.size = aSize;
            this.charSequenceSizedElements = aCharSequenceSizedElements;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Alignment {
        public static final int BEGIN = 0;
        public static final int END = 1;
        public static final int CENTER = 2;
        public static final int JUSTIFIED = 3;
        public static final int JIS = 4;
    }
}

