/*
 * Decompiled with CFR 0.152.
 */
package org.happypeng.sumatora.android.superrubyspan;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SuperRubySpan
extends ReplacementSpan {
    @NonNull
    private final CharSequence mFurigana;
    private final int mTextAlignment;
    private final int mFuriganaAlignment;

    public SuperRubySpan(@NonNull CharSequence aFurigana) {
        this(aFurigana, 2, 2);
    }

    public SuperRubySpan(@NonNull CharSequence aFurigana, int aTextAlignment, int aFuriganaAlignment) {
        this.mFurigana = aFurigana;
        this.mTextAlignment = aTextAlignment;
        this.mFuriganaAlignment = aFuriganaAlignment;
    }

    private <T> List<T> getSpans(@NonNull Spanned text, int start, int end, Class<T> type) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Object span : text.getSpans(start, end, type)) {
            if (span == this) continue;
            list.add(span);
        }
        return list;
    }

    private List<CharSequenceElement> getCharSequenceElements(@NonNull CharSequence text, int start, int end) {
        Spanned textSpanned = text instanceof Spanned ? (Spanned)text : null;
        List<ReplacementSpan> replacementSpans = textSpanned != null ? this.getSpans(textSpanned, start, end, ReplacementSpan.class) : null;
        List<MetricAffectingSpan> metricAffectingSpans = textSpanned != null ? this.getSpans(textSpanned, start, end, MetricAffectingSpan.class) : null;
        List<CharacterStyle> characterStyles = textSpanned != null ? this.getSpans(textSpanned, start, end, CharacterStyle.class) : null;
        String textString = text.toString();
        LinkedList<CharSequenceElement> charSequenceElements = new LinkedList<CharSequenceElement>();
        int cursor = start;
        while (cursor < end) {
            int nextCursor = textString.offsetByCodePoints(cursor, 1);
            LinkedList<MetricAffectingSpan> metricAffectingSpansSub = null;
            LinkedList<CharacterStyle> characterStylesSub = null;
            if (textSpanned != null) {
                int spanEnd;
                int spanStart;
                LinkedList<ReplacementSpan> replacementSpansSub = null;
                for (ReplacementSpan replacementSpan : replacementSpans) {
                    spanStart = textSpanned.getSpanStart((Object)replacementSpan);
                    spanEnd = textSpanned.getSpanEnd((Object)replacementSpan);
                    if (spanStart < cursor) continue;
                    if (replacementSpansSub == null) {
                        replacementSpansSub = new LinkedList<ReplacementSpan>();
                    }
                    replacementSpansSub.add(replacementSpan);
                    if (spanEnd <= nextCursor) continue;
                    nextCursor = spanEnd;
                }
                if (replacementSpansSub != null) {
                    charSequenceElements.add(new CharSequenceElement(cursor, nextCursor, replacementSpansSub, null, null));
                    cursor = nextCursor;
                    continue;
                }
                for (MetricAffectingSpan metricAffectingSpan : metricAffectingSpans) {
                    spanStart = textSpanned.getSpanStart((Object)metricAffectingSpan);
                    spanEnd = textSpanned.getSpanEnd((Object)metricAffectingSpan);
                    if (spanStart > cursor || spanEnd < nextCursor) continue;
                    if (metricAffectingSpansSub == null) {
                        metricAffectingSpansSub = new LinkedList<MetricAffectingSpan>();
                    }
                    metricAffectingSpansSub.add(metricAffectingSpan);
                }
                for (CharacterStyle characterStyle : characterStyles) {
                    spanStart = textSpanned.getSpanStart((Object)characterStyle);
                    spanEnd = textSpanned.getSpanEnd((Object)characterStyle);
                    if (spanStart > cursor || spanEnd < nextCursor) continue;
                    if (characterStylesSub == null) {
                        characterStylesSub = new LinkedList<CharacterStyle>();
                    }
                    characterStylesSub.add(characterStyle);
                }
            }
            charSequenceElements.add(new CharSequenceElement(cursor, nextCursor, null, metricAffectingSpansSub, characterStylesSub));
            cursor = nextCursor;
        }
        return charSequenceElements;
    }

    private static void mergeFontMetricsInt(@NonNull Paint.FontMetricsInt baseFontMetricsInt, @NonNull Paint.FontMetricsInt newFontMetricsInt) {
        baseFontMetricsInt.leading = Math.max(baseFontMetricsInt.leading, newFontMetricsInt.leading);
        baseFontMetricsInt.descent = Math.max(baseFontMetricsInt.descent, newFontMetricsInt.descent);
        baseFontMetricsInt.bottom = Math.max(baseFontMetricsInt.bottom, newFontMetricsInt.bottom);
        baseFontMetricsInt.ascent = Math.min(baseFontMetricsInt.ascent, newFontMetricsInt.ascent);
        baseFontMetricsInt.top = Math.min(baseFontMetricsInt.top, newFontMetricsInt.top);
    }

    private static void centerText(@NonNull TextSizeInformation textSizeInformation, float size) {
        Iterator<CharSequenceSizedElement> charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        int count = 0;
        float extraSpace = size - textSizeInformation.size;
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (count == 0) {
                charSequenceSizedElement.spaceBefore = extraSpace / 2.0f;
            }
            if (!charSequenceElementIterator.hasNext()) {
                charSequenceSizedElement.spaceAfter = extraSpace / 2.0f;
            }
            ++count;
        }
    }

    private static void alignTextLeft(@NonNull TextSizeInformation textSizeInformation, float size) {
        Iterator<CharSequenceSizedElement> charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        int count = 0;
        float extraSpace = size - textSizeInformation.size;
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (!charSequenceElementIterator.hasNext()) {
                charSequenceSizedElement.spaceAfter = extraSpace;
            }
            ++count;
        }
    }

    private static void alignTextRight(@NonNull TextSizeInformation textSizeInformation, float size) {
        Iterator<CharSequenceSizedElement> charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        int count = 0;
        float extraSpace = size - textSizeInformation.size;
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (count == 0) {
                charSequenceSizedElement.spaceBefore = extraSpace;
            }
            ++count;
        }
    }

    private static void justifyText(@NonNull TextSizeInformation textSizeInformation, float size, boolean jis) {
        float divider = 0.0f;
        int count = 0;
        if (textSizeInformation.charSequenceSizedElements.size() == 1) {
            SuperRubySpan.centerText(textSizeInformation, size);
            return;
        }
        Iterator<CharSequenceSizedElement> charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (charSequenceElementIterator.hasNext()) {
                divider += charSequenceSizedElement.size / 2.0f;
            }
            if (count != 0) {
                divider += charSequenceSizedElement.size / 2.0f;
            }
            if (jis) {
                if (!charSequenceElementIterator.hasNext()) {
                    divider += charSequenceSizedElement.size / 2.0f;
                }
                if (count == 0) {
                    divider += charSequenceSizedElement.size / 2.0f;
                }
            }
            ++count;
        }
        float extraSpaceUnit = (size - textSizeInformation.size) / divider;
        count = 0;
        charSequenceElementIterator = textSizeInformation.charSequenceSizedElements.iterator();
        while (charSequenceElementIterator.hasNext()) {
            CharSequenceSizedElement charSequenceSizedElement = charSequenceElementIterator.next();
            if (charSequenceElementIterator.hasNext()) {
                charSequenceSizedElement.spaceAfter = charSequenceSizedElement.size * extraSpaceUnit / 2.0f;
            }
            if (count != 0) {
                charSequenceSizedElement.spaceBefore = charSequenceSizedElement.size * extraSpaceUnit / 2.0f;
            }
            if (jis) {
                if (!charSequenceElementIterator.hasNext()) {
                    charSequenceSizedElement.spaceAfter += charSequenceSizedElement.size * extraSpaceUnit / 2.0f;
                }
                if (count == 0) {
                    charSequenceSizedElement.spaceBefore += charSequenceSizedElement.size * extraSpaceUnit / 2.0f;
                }
            }
            ++count;
        }
    }

    private TextSizeInformation getTextSize(@NonNull Paint paint, @NonNull CharSequence text, int start, int end) {
        List<CharSequenceElement> charSequenceElements = this.getCharSequenceElements(text, start, end);
        Paint.FontMetricsInt fm = new Paint.FontMetricsInt();
        LinkedList<CharSequenceSizedElement> charSequenceSizedElements = new LinkedList<CharSequenceSizedElement>();
        int size = 0;
        for (CharSequenceElement charSequenceElement : charSequenceElements) {
            float elementSize;
            Object fontMetricsInt;
            if (charSequenceElement.replacementSpans != null) {
                ReplacementSpan replacementSpan = charSequenceElement.replacementSpans.get(charSequenceElement.replacementSpans.size() - 1);
                fontMetricsInt = new Paint.FontMetricsInt();
                elementSize = replacementSpan.getSize(paint, text, charSequenceElement.start, charSequenceElement.end, (Paint.FontMetricsInt)fontMetricsInt);
                charSequenceSizedElements.add(new CharSequenceSizedElement(charSequenceElement, elementSize, new TextPaint(paint), (Paint.FontMetricsInt)fontMetricsInt));
                size = (int)((float)size + elementSize);
                SuperRubySpan.mergeFontMetricsInt(fm, (Paint.FontMetricsInt)fontMetricsInt);
                continue;
            }
            TextPaint textPaint = new TextPaint(paint);
            if (charSequenceElement.metricAffectingSpans != null) {
                for (MetricAffectingSpan metricAffectingSpan : charSequenceElement.metricAffectingSpans) {
                    metricAffectingSpan.updateMeasureState(textPaint);
                }
            }
            if (charSequenceElement.characterStyles != null) {
                for (CharacterStyle characterStyle : charSequenceElement.characterStyles) {
                    characterStyle.updateDrawState(textPaint);
                }
            }
            fontMetricsInt = textPaint.getFontMetricsInt();
            elementSize = textPaint.measureText(text, charSequenceElement.start, charSequenceElement.end);
            charSequenceSizedElements.add(new CharSequenceSizedElement(charSequenceElement, elementSize, textPaint, (Paint.FontMetricsInt)fontMetricsInt));
            size = (int)((float)size + elementSize);
            SuperRubySpan.mergeFontMetricsInt(fm, (Paint.FontMetricsInt)fontMetricsInt);
        }
        return new TextSizeInformation(fm, size, charSequenceSizedElements);
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        TextSizeInformation textSizeInformation = this.getTextSize(paint, text, start, end);
        TextPaint inheritPaint = new TextPaint(paint);
        if (textSizeInformation.charSequenceSizedElements.size() > 0) {
            inheritPaint.setTextSize(textSizeInformation.charSequenceSizedElements.get((int)0).textPaint.getTextSize());
        }
        TextSizeInformation furiganaSizeInformation = this.getTextSize((Paint)inheritPaint, this.mFurigana, 0, this.mFurigana.length());
        if (fm != null) {
            fm.bottom = textSizeInformation.fontMetricsInt.bottom;
            fm.ascent = textSizeInformation.fontMetricsInt.ascent + (furiganaSizeInformation.fontMetricsInt.ascent - furiganaSizeInformation.fontMetricsInt.descent);
            fm.top = textSizeInformation.fontMetricsInt.ascent + (furiganaSizeInformation.fontMetricsInt.top - furiganaSizeInformation.fontMetricsInt.descent);
            fm.descent = textSizeInformation.fontMetricsInt.descent;
            fm.leading = textSizeInformation.fontMetricsInt.leading;
        }
        return Math.round(Math.max(textSizeInformation.size, furiganaSizeInformation.size));
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        this.drawExpanded(canvas, text, start, end, x, top, y, bottom, paint, 0.0f);
    }

    private void drawExpanded(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint, float expandedSpanSize) {
        TextPaint inheritPaint = new TextPaint(paint);
        TextSizeInformation textSizeInformation = this.getTextSize(paint, text, start, end);
        if (textSizeInformation.charSequenceSizedElements.size() > 0) {
            inheritPaint.setTextSize(textSizeInformation.charSequenceSizedElements.get((int)0).textPaint.getTextSize());
        }
        TextSizeInformation furiganaSizeInformation = this.getTextSize((Paint)inheritPaint, this.mFurigana, 0, this.mFurigana.length());
        float spanSize = Math.round(Math.max(Math.max(textSizeInformation.size, furiganaSizeInformation.size), expandedSpanSize));
        float cursor = x;
        int count = 0;
        switch (this.mTextAlignment) {
            case 0: {
                SuperRubySpan.alignTextLeft(textSizeInformation, spanSize);
                break;
            }
            case 2: {
                SuperRubySpan.centerText(textSizeInformation, spanSize);
                break;
            }
            case 1: {
                SuperRubySpan.alignTextRight(textSizeInformation, spanSize);
                break;
            }
            case 3: {
                SuperRubySpan.justifyText(textSizeInformation, spanSize, false);
                break;
            }
            case 4: {
                SuperRubySpan.justifyText(textSizeInformation, spanSize, true);
            }
        }
        for (CharSequenceSizedElement charSequenceSizedElement : textSizeInformation.charSequenceSizedElements) {
            if (charSequenceSizedElement.textPaint.bgColor != 0) {
                float left = count == 0 ? cursor + charSequenceSizedElement.spaceBefore : cursor;
                float right = count == textSizeInformation.charSequenceSizedElements.size() - 1 ? cursor + charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size : cursor + charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size + charSequenceSizedElement.spaceAfter;
                int previousColor = charSequenceSizedElement.textPaint.getColor();
                Paint.Style previousStyle = charSequenceSizedElement.textPaint.getStyle();
                charSequenceSizedElement.textPaint.setColor(charSequenceSizedElement.textPaint.bgColor);
                charSequenceSizedElement.textPaint.setStyle(Paint.Style.FILL);
                canvas.drawRect(left, (float)(y + charSequenceSizedElement.fontMetricsInt.top), right, (float)(y + charSequenceSizedElement.fontMetricsInt.bottom), (Paint)charSequenceSizedElement.textPaint);
                charSequenceSizedElement.textPaint.setStyle(previousStyle);
                charSequenceSizedElement.textPaint.setColor(previousColor);
            }
            if (charSequenceSizedElement.charSequenceElement.replacementSpans != null && charSequenceSizedElement.charSequenceElement.replacementSpans.size() > 0) {
                ReplacementSpan replacementSpan = charSequenceSizedElement.charSequenceElement.replacementSpans.get(charSequenceSizedElement.charSequenceElement.replacementSpans.size() - 1);
                if (replacementSpan instanceof SuperRubySpan) {
                    ((SuperRubySpan)replacementSpan).drawExpanded(canvas, text, start, end, cursor, top - textSizeInformation.fontMetricsInt.ascent + furiganaSizeInformation.fontMetricsInt.descent, y, bottom, (Paint)charSequenceSizedElement.textPaint, charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size + charSequenceSizedElement.spaceAfter);
                } else {
                    replacementSpan.draw(canvas, text, start, end, cursor + charSequenceSizedElement.spaceBefore, top - textSizeInformation.fontMetricsInt.ascent + furiganaSizeInformation.fontMetricsInt.descent, y, bottom, (Paint)charSequenceSizedElement.textPaint);
                }
            } else {
                float scaleX;
                float spaceSize;
                if (charSequenceSizedElement.spaceBefore != 0.0f && count != 0) {
                    spaceSize = charSequenceSizedElement.textPaint.measureText(" ");
                    scaleX = charSequenceSizedElement.textPaint.getTextScaleX();
                    charSequenceSizedElement.textPaint.setTextScaleX(charSequenceSizedElement.spaceBefore / spaceSize);
                    canvas.drawText(" ", 0, 1, cursor, (float)y, (Paint)charSequenceSizedElement.textPaint);
                    charSequenceSizedElement.textPaint.setTextScaleX(scaleX);
                }
                canvas.drawText(text, charSequenceSizedElement.charSequenceElement.start, charSequenceSizedElement.charSequenceElement.end, cursor + charSequenceSizedElement.spaceBefore, (float)y, (Paint)charSequenceSizedElement.textPaint);
                if (charSequenceSizedElement.spaceAfter != 0.0f && count != textSizeInformation.charSequenceSizedElements.size() - 1) {
                    spaceSize = charSequenceSizedElement.textPaint.measureText(" ");
                    scaleX = charSequenceSizedElement.textPaint.getTextScaleX();
                    charSequenceSizedElement.textPaint.setTextScaleX(charSequenceSizedElement.spaceAfter / spaceSize);
                    canvas.drawText(" ", 0, 1, cursor + charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size, (float)y, (Paint)charSequenceSizedElement.textPaint);
                    charSequenceSizedElement.textPaint.setTextScaleX(scaleX);
                }
            }
            cursor += charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size + charSequenceSizedElement.spaceAfter;
            ++count;
        }
        float furiganaCursor = x;
        count = 0;
        switch (this.mFuriganaAlignment) {
            case 0: {
                SuperRubySpan.alignTextLeft(furiganaSizeInformation, spanSize);
                break;
            }
            case 2: {
                SuperRubySpan.centerText(furiganaSizeInformation, spanSize);
                break;
            }
            case 1: {
                SuperRubySpan.alignTextRight(furiganaSizeInformation, spanSize);
                break;
            }
            case 3: {
                SuperRubySpan.justifyText(furiganaSizeInformation, spanSize, false);
                break;
            }
            case 4: {
                SuperRubySpan.justifyText(furiganaSizeInformation, spanSize, true);
            }
        }
        for (CharSequenceSizedElement charSequenceSizedElement : furiganaSizeInformation.charSequenceSizedElements) {
            if (charSequenceSizedElement.textPaint.bgColor != 0) {
                float left = count == 0 ? furiganaCursor + charSequenceSizedElement.spaceBefore : furiganaCursor;
                float right = count == furiganaSizeInformation.charSequenceSizedElements.size() - 1 ? furiganaCursor + charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size : furiganaCursor + charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size + charSequenceSizedElement.spaceAfter;
                int previousColor = charSequenceSizedElement.textPaint.getColor();
                Paint.Style previousStyle = charSequenceSizedElement.textPaint.getStyle();
                charSequenceSizedElement.textPaint.setColor(charSequenceSizedElement.textPaint.bgColor);
                charSequenceSizedElement.textPaint.setStyle(Paint.Style.FILL);
                canvas.drawRect(left, (float)(y + textSizeInformation.fontMetricsInt.ascent - charSequenceSizedElement.fontMetricsInt.descent + charSequenceSizedElement.fontMetricsInt.top), right, (float)(y + textSizeInformation.fontMetricsInt.ascent - charSequenceSizedElement.fontMetricsInt.descent + charSequenceSizedElement.fontMetricsInt.bottom), (Paint)charSequenceSizedElement.textPaint);
                charSequenceSizedElement.textPaint.setStyle(previousStyle);
                charSequenceSizedElement.textPaint.setColor(previousColor);
            }
            if (charSequenceSizedElement.charSequenceElement.replacementSpans != null && charSequenceSizedElement.charSequenceElement.replacementSpans.size() > 0) {
                ReplacementSpan replacementSpan = charSequenceSizedElement.charSequenceElement.replacementSpans.get(charSequenceSizedElement.charSequenceElement.replacementSpans.size() - 1);
                if (replacementSpan instanceof SuperRubySpan) {
                    ((SuperRubySpan)replacementSpan).drawExpanded(canvas, this.mFurigana, charSequenceSizedElement.charSequenceElement.start, charSequenceSizedElement.charSequenceElement.end, furiganaCursor, top, y + textSizeInformation.fontMetricsInt.ascent - furiganaSizeInformation.fontMetricsInt.descent, bottom + textSizeInformation.fontMetricsInt.ascent - furiganaSizeInformation.fontMetricsInt.descent - furiganaSizeInformation.fontMetricsInt.bottom, (Paint)charSequenceSizedElement.textPaint, charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size + charSequenceSizedElement.spaceAfter);
                } else {
                    replacementSpan.draw(canvas, this.mFurigana, charSequenceSizedElement.charSequenceElement.start, charSequenceSizedElement.charSequenceElement.end, furiganaCursor + charSequenceSizedElement.spaceBefore, top, y + textSizeInformation.fontMetricsInt.ascent - furiganaSizeInformation.fontMetricsInt.descent, bottom + textSizeInformation.fontMetricsInt.ascent - furiganaSizeInformation.fontMetricsInt.descent - furiganaSizeInformation.fontMetricsInt.bottom, (Paint)charSequenceSizedElement.textPaint);
                }
            } else {
                float scaleX;
                if (charSequenceSizedElement.spaceBefore != 0.0f && count != 0) {
                    float spaceSize = charSequenceSizedElement.textPaint.measureText(" ");
                    scaleX = charSequenceSizedElement.textPaint.getTextScaleX();
                    charSequenceSizedElement.textPaint.setTextScaleX(charSequenceSizedElement.spaceBefore / spaceSize);
                    canvas.drawText(" ", 0, 1, furiganaCursor, (float)(y + textSizeInformation.fontMetricsInt.ascent - furiganaSizeInformation.fontMetricsInt.descent), (Paint)charSequenceSizedElement.textPaint);
                    charSequenceSizedElement.textPaint.setTextScaleX(scaleX);
                }
                canvas.drawText(this.mFurigana, charSequenceSizedElement.charSequenceElement.start, charSequenceSizedElement.charSequenceElement.end, furiganaCursor + charSequenceSizedElement.spaceBefore, (float)(y + textSizeInformation.fontMetricsInt.ascent - furiganaSizeInformation.fontMetricsInt.descent), (Paint)charSequenceSizedElement.textPaint);
                if (charSequenceSizedElement.spaceAfter != 0.0f && count != furiganaSizeInformation.charSequenceSizedElements.size() - 1) {
                    float spaceSize = charSequenceSizedElement.textPaint.measureText(" ");
                    scaleX = charSequenceSizedElement.textPaint.getTextScaleX();
                    charSequenceSizedElement.textPaint.setTextScaleX(charSequenceSizedElement.spaceAfter / spaceSize);
                    canvas.drawText(" ", 0, 1, furiganaCursor + charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size, (float)(y + textSizeInformation.fontMetricsInt.ascent - furiganaSizeInformation.fontMetricsInt.descent), (Paint)charSequenceSizedElement.textPaint);
                    charSequenceSizedElement.textPaint.setTextScaleX(scaleX);
                }
            }
            furiganaCursor += charSequenceSizedElement.spaceBefore + charSequenceSizedElement.size + charSequenceSizedElement.spaceAfter;
            ++count;
        }
    }

    private static class CharSequenceSizedElement {
        final CharSequenceElement charSequenceElement;
        final float size;
        final TextPaint textPaint;
        final Paint.FontMetricsInt fontMetricsInt;
        float spaceBefore;
        float spaceAfter;

        private CharSequenceSizedElement(CharSequenceElement aCharSequenceElement, float aSize, TextPaint aTextPaint, Paint.FontMetricsInt aFontMetricsInt) {
            this.charSequenceElement = aCharSequenceElement;
            this.size = aSize;
            this.textPaint = aTextPaint;
            this.fontMetricsInt = aFontMetricsInt;
            this.spaceBefore = 0.0f;
            this.spaceAfter = 0.0f;
        }
    }

    private static class CharSequenceElement {
        final int start;
        final int end;
        final List<ReplacementSpan> replacementSpans;
        final List<MetricAffectingSpan> metricAffectingSpans;
        final List<CharacterStyle> characterStyles;

        private CharSequenceElement(int aStart, int aEnd, List<ReplacementSpan> aReplacementSpans, List<MetricAffectingSpan> aMetricAffectingSpans, List<CharacterStyle> aCharacterStyles) {
            this.start = aStart;
            this.end = aEnd;
            this.replacementSpans = aReplacementSpans;
            this.metricAffectingSpans = aMetricAffectingSpans;
            this.characterStyles = aCharacterStyles;
        }
    }

    private static class TextSizeInformation {
        final Paint.FontMetricsInt fontMetricsInt;
        final float size;
        final List<CharSequenceSizedElement> charSequenceSizedElements;

        TextSizeInformation(Paint.FontMetricsInt aFontMetricsInt, float aSize, List<CharSequenceSizedElement> aCharSequenceSizedElements) {
            this.fontMetricsInt = aFontMetricsInt;
            this.size = aSize;
            this.charSequenceSizedElements = aCharSequenceSizedElements;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Alignment {
        public static final int BEGIN = 0;
        public static final int END = 1;
        public static final int CENTER = 2;
        public static final int JUSTIFIED = 3;
        public static final int JIS = 4;
    }
}

