/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text;

import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.IsNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IsBlankString
extends TypeSafeMatcher<String> {
    private static final IsBlankString BLANK_INSTANCE = new IsBlankString();
    private static final Matcher<String> NULL_OR_BLANK_INSTANCE = AnyOf.anyOf((Matcher[])new Matcher[]{IsNull.nullValue(), BLANK_INSTANCE});
    private static final Pattern REGEX_WHITESPACE = Pattern.compile("\\s*");

    private IsBlankString() {
    }

    public boolean matchesSafely(String item) {
        return REGEX_WHITESPACE.matcher(item).matches();
    }

    public void describeTo(Description description) {
        description.appendText("a blank string");
    }

    @Factory
    public static Matcher<String> blankString() {
        return BLANK_INSTANCE;
    }

    @Factory
    public static Matcher<String> blankOrNullString() {
        return NULL_OR_BLANK_INSTANCE;
    }
}

