/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsArrayContainingInOrder<E>
extends TypeSafeMatcher<E[]> {
    private final Collection<Matcher<? super E>> matchers;
    private final IsIterableContainingInOrder<E> iterableMatcher;

    public IsArrayContainingInOrder(List<Matcher<? super E>> matchers) {
        this.iterableMatcher = new IsIterableContainingInOrder<E>(matchers);
        this.matchers = matchers;
    }

    public boolean matchesSafely(E[] item) {
        return this.iterableMatcher.matches(Arrays.asList(item));
    }

    public void describeMismatchSafely(E[] item, Description mismatchDescription) {
        this.iterableMatcher.describeMismatch(Arrays.asList(item), mismatchDescription);
    }

    public void describeTo(Description description) {
        description.appendList("[", ", ", "]", this.matchers);
    }

    @Factory
    public static <E> Matcher<E[]> arrayContaining(E ... items) {
        ArrayList<Matcher<Matcher>> matchers = new ArrayList<Matcher<Matcher>>();
        for (E item : items) {
            matchers.add(IsEqual.equalTo(item));
        }
        return IsArrayContainingInOrder.arrayContaining(matchers);
    }

    @Factory
    public static <E> Matcher<E[]> arrayContaining(Matcher<? super E> ... itemMatchers) {
        List<Matcher<? super E>> nullSafeWithExplicitTypeMatchers = IsArrayContainingInOrder.nullSafe(itemMatchers);
        return IsArrayContainingInOrder.arrayContaining(nullSafeWithExplicitTypeMatchers);
    }

    @Factory
    public static <E> Matcher<E[]> arrayContaining(List<Matcher<? super E>> itemMatchers) {
        return new IsArrayContainingInOrder<E>(itemMatchers);
    }

    private static <E> List<Matcher<? super E>> nullSafe(Matcher<? super E>[] itemMatchers) {
        ArrayList<Matcher<Matcher<? super E>>> matchers = new ArrayList<Matcher<Matcher<? super E>>>(itemMatchers.length);
        for (Matcher<? super E> itemMatcher : itemMatchers) {
            matchers.add(itemMatcher == null ? IsNull.nullValue() : itemMatcher);
        }
        return matchers;
    }
}

