/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.jakarta;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

class SerializationPolicyClient {
    private final int connectTimeout;
    private final int readTimeout;

    SerializationPolicyClient(int connectTimeoutMs, int readTimeoutMs) {
        this.connectTimeout = connectTimeoutMs;
        this.readTimeout = readTimeoutMs;
    }

    SerializationPolicy loadPolicy(String url, Logger logger) {
        InputStream in;
        URL urlObj;
        try {
            urlObj = new URL(url);
        }
        catch (MalformedURLException e) {
            logger.logError("Can't parse serialization policy URL: " + url, e);
            return null;
        }
        try {
            URLConnection conn = urlObj.openConnection();
            conn.setConnectTimeout(this.connectTimeout);
            conn.setReadTimeout(this.readTimeout);
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
            }
            conn.connect();
            in = conn.getInputStream();
        }
        catch (IOException e) {
            logger.logError("Can't open serialization policy URL: " + url, e);
            return null;
        }
        return SerializationPolicyClient.readPolicy(in, url, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SerializationPolicy readPolicy(InputStream in, String sourceName, Logger logger) {
        try {
            ArrayList<ClassNotFoundException> errs = new ArrayList<ClassNotFoundException>();
            SerializationPolicy policy = SerializationPolicyLoader.loadFromStream(in, errs);
            logger.logInfo("Downloaded serialization policy from " + sourceName);
            if (!errs.isEmpty()) {
                SerializationPolicyClient.logMissingClasses(logger, errs);
            }
            SerializationPolicy serializationPolicy = policy;
            return serializationPolicy;
        }
        catch (ParseException e) {
            logger.logError("Can't parse serialization policy from " + sourceName, e);
            SerializationPolicy serializationPolicy = null;
            return serializationPolicy;
        }
        catch (IOException e) {
            logger.logError("Can't read serialization policy from " + sourceName, e);
            SerializationPolicy serializationPolicy = null;
            return serializationPolicy;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.logError("Can't close serialization policy url: " + sourceName, e);
            }
        }
    }

    private static void logMissingClasses(Logger logger, List<ClassNotFoundException> errs) {
        StringBuilder message = new StringBuilder();
        message.append("Unable to load server-side classes used by policy:\n");
        int limit = Math.min(10, errs.size());
        for (int i = 0; i < limit; ++i) {
            message.append("  " + errs.get(i).getMessage() + "\n");
        }
        int omitted = errs.size() - limit;
        if (omitted > 0) {
            message.append("  (omitted " + omitted + " more classes)\n");
        }
        logger.logInfo(message.toString());
    }

    static interface Logger {
        public void logInfo(String var1);

        public void logError(String var1, Throwable var2);
    }
}

