/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log.adapters.commons;

import org.apache.commons.logging.Log;
import org.grlea.log.DebugLevel;
import org.grlea.log.SimpleLog;
import org.grlea.log.SimpleLogger;

public class CommonsLoggingAdapter
implements Log {
    private static final String SUPRESS_WARNINGS_PROPERTY = "org.grlea.log.adapters.commons.supressWarnings";
    private static SimpleLog log = null;
    private final SimpleLogger logger;
    static /* synthetic */ Class class$org$apache$commons$logging$Log;

    public CommonsLoggingAdapter(String string) {
        SimpleLogger simpleLogger;
        CommonsLoggingAdapter.initLog();
        try {
            Class<?> clazz = Class.forName(string);
            simpleLogger = new SimpleLogger(clazz);
        }
        catch (Exception exception) {
            boolean bl = false;
            try {
                String string2 = System.getProperty(SUPRESS_WARNINGS_PROPERTY);
                bl = string2 != null && string2.toLowerCase().equals("true");
            }
            catch (Exception exception2) {
                System.err.println("WARNING: Simple Log (CommonsLoggingAdapter): Failed to read system property 'org.grlea.log.adapters.commons.supressWarnings'");
            }
            if (!bl) {
                System.err.println("WARNING: Simple Log (CommonsLoggingAdapter): Failed to find class for logger name '" + string + "'. " + "Using class '" + (class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = CommonsLoggingAdapter.class$("org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log).getName() + "' and instanceId '" + string + "'.");
            }
            simpleLogger = new SimpleLogger(class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = CommonsLoggingAdapter.class$("org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log, (Object)string);
        }
        this.logger = simpleLogger;
    }

    private static void initLog() {
        if (log == null) {
            CommonsLoggingAdapter.setLog(SimpleLog.defaultInstance());
        }
    }

    public static void setLog(SimpleLog simpleLog) {
        log = simpleLog;
    }

    public boolean isFatalEnabled() {
        return this.logger.wouldLog(DebugLevel.L1_FATAL);
    }

    public boolean isErrorEnabled() {
        return this.logger.wouldLog(DebugLevel.L2_ERROR);
    }

    public boolean isWarnEnabled() {
        return this.logger.wouldLog(DebugLevel.L3_WARN);
    }

    public boolean isInfoEnabled() {
        return this.logger.wouldLog(DebugLevel.L4_INFO);
    }

    public boolean isDebugEnabled() {
        return this.logger.wouldLog(DebugLevel.L5_DEBUG);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTracing();
    }

    public void fatal(Object object) {
        if (this.logger.wouldLog(DebugLevel.L1_FATAL)) {
            this.log(DebugLevel.L1_FATAL, object);
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (this.logger.wouldLog(DebugLevel.L1_FATAL)) {
            this.log(DebugLevel.L1_FATAL, object);
            this.logger.dbe(DebugLevel.L1_FATAL, throwable);
        }
    }

    public void error(Object object) {
        if (this.logger.wouldLog(DebugLevel.L2_ERROR)) {
            this.log(DebugLevel.L2_ERROR, object);
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.logger.wouldLog(DebugLevel.L2_ERROR)) {
            this.log(DebugLevel.L2_ERROR, object);
            this.logger.dbe(DebugLevel.L2_ERROR, throwable);
        }
    }

    public void warn(Object object) {
        if (this.logger.wouldLog(DebugLevel.L3_WARN)) {
            this.log(DebugLevel.L3_WARN, object);
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.logger.wouldLog(DebugLevel.L3_WARN)) {
            this.log(DebugLevel.L3_WARN, object);
            this.logger.dbe(DebugLevel.L3_WARN, throwable);
        }
    }

    public void info(Object object) {
        if (this.logger.wouldLog(DebugLevel.L4_INFO)) {
            this.log(DebugLevel.L4_INFO, object);
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.logger.wouldLog(DebugLevel.L4_INFO)) {
            this.log(DebugLevel.L4_INFO, object);
            this.logger.dbe(DebugLevel.L4_INFO, throwable);
        }
    }

    public void debug(Object object) {
        if (this.logger.wouldLog(DebugLevel.L5_DEBUG)) {
            this.log(DebugLevel.L5_DEBUG, object);
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.logger.wouldLog(DebugLevel.L5_DEBUG)) {
            this.log(DebugLevel.L5_DEBUG, object);
            this.logger.dbe(DebugLevel.L5_DEBUG, throwable);
        }
    }

    public void trace(Object object) {
        if (this.logger.wouldLog(DebugLevel.L6_VERBOSE)) {
            this.log(DebugLevel.L6_VERBOSE, object);
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.logger.wouldLog(DebugLevel.L6_VERBOSE)) {
            this.log(DebugLevel.L6_VERBOSE, object);
            this.logger.dbe(DebugLevel.L6_VERBOSE, throwable);
        }
    }

    private void log(DebugLevel debugLevel, Object object) {
        if (object instanceof String) {
            this.logger.db(debugLevel, (String)object);
        } else {
            this.logger.dbo(debugLevel, "", object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

