/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotExpander;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.UniversalEventWriter;
import org.gridkit.jvmtool.stacktrace.LegacyThreadEventReader;
import org.gridkit.jvmtool.stacktrace.MagicReader;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;
import org.gridkit.jvmtool.stacktrace.StackTraceEventReaderV4;
import org.gridkit.jvmtool.stacktrace.StackTraceEventWriterV4;
import org.gridkit.jvmtool.stacktrace.StackTraceReaderV1;
import org.gridkit.jvmtool.stacktrace.StackTraceReaderV2;

public class ThreadEventCodec {
    public static UniversalEventWriter createEventWriter(OutputStream os) throws IOException {
        os.write(StackTraceCodec.MAGIC4);
        StackTraceEventWriterV4 writer = new StackTraceEventWriterV4(os);
        return writer;
    }

    public static EventReader<Event> createEventReader(InputStream is) throws IOException {
        byte[] magic = MagicReader.readMagic(is);
        return ThreadEventCodec.createEventReader(magic, is);
    }

    public static EventReader<Event> createEventReader(byte[] magic, InputStream is) throws IOException {
        if (Arrays.equals(magic, StackTraceCodec.MAGIC)) {
            StackTraceReaderV1 lreader = new StackTraceReaderV1(is);
            LegacyThreadEventReader reader = new LegacyThreadEventReader(lreader);
            return reader;
        }
        if (Arrays.equals(magic, StackTraceCodec.MAGIC2)) {
            StackTraceReaderV2 lreader = new StackTraceReaderV2(is);
            LegacyThreadEventReader reader = new LegacyThreadEventReader(lreader);
            return reader;
        }
        if (Arrays.equals(magic, StackTraceCodec.MAGIC4)) {
            EventReader<Event> reader = new StackTraceEventReaderV4(is).morph(new ThreadSnapshotExpander());
            return reader;
        }
        throw new IOException("Unknown magic '" + new String(magic) + "'");
    }
}

