/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ClassificatorAST;
import org.gridkit.jvmtool.stacktrace.analytics.PositionalStackMatcher;
import org.gridkit.jvmtool.stacktrace.analytics.StackFrameMatcher;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;

public class BasicFilterFactory {
    public ThreadSnapshotFilter build(ClassificatorAST.Filter filter) {
        if (filter instanceof ClassificatorAST.AndCombinatorFilter) {
            ArrayList<ThreadSnapshotFilter> list = new ArrayList<ThreadSnapshotFilter>();
            for (ClassificatorAST.Filter f : ((ClassificatorAST.AndCombinatorFilter)filter).subfilters) {
                if (f instanceof ClassificatorAST.TrueFilter) continue;
                if (f instanceof ClassificatorAST.FalseFilter) {
                    return this.falseFilter();
                }
                list.add(this.build(f));
            }
            if (list.isEmpty()) {
                return this.trueFilter();
            }
            return this.disjunction(list);
        }
        if (filter instanceof ClassificatorAST.OrCombinatorFilter) {
            ArrayList<ThreadSnapshotFilter> list = new ArrayList<ThreadSnapshotFilter>();
            for (ClassificatorAST.Filter f : ((ClassificatorAST.OrCombinatorFilter)filter).subfilters) {
                if (f instanceof ClassificatorAST.FalseFilter) continue;
                if (f instanceof ClassificatorAST.TrueFilter) {
                    return this.trueFilter();
                }
                list.add(this.build(f));
            }
            if (list.isEmpty()) {
                return this.falseFilter();
            }
            return this.conjunction(list);
        }
        if (filter instanceof ClassificatorAST.TrueFilter) {
            return this.trueFilter();
        }
        if (filter instanceof ClassificatorAST.FalseFilter) {
            return this.falseFilter();
        }
        if (filter instanceof ClassificatorAST.LastFollowedFilter) {
            ClassificatorAST.LastFollowedFilter lff = (ClassificatorAST.LastFollowedFilter)filter;
            return this.followed(this.lastFrame(this.build(lff.snippet)), this.build(lff.followFilter));
        }
        if (filter instanceof ClassificatorAST.LastNotFollowedFilter) {
            ClassificatorAST.LastNotFollowedFilter lff = (ClassificatorAST.LastNotFollowedFilter)filter;
            return this.followed(this.lastFrame(this.build(lff.snippet)), this.not(this.build(lff.followFilter)));
        }
        if (filter instanceof ClassificatorAST.PatternFilter) {
            ClassificatorAST.PatternFilter pf = (ClassificatorAST.PatternFilter)filter;
            return this.frameFilter(this.patternFrameMatcher(pf.patterns));
        }
        throw new IllegalArgumentException("Unknow AST node: " + filter);
    }

    public StackFrameMatcher build(ClassificatorAST.FrameMatcher matcher) {
        if (matcher instanceof ClassificatorAST.PatternFilter) {
            ClassificatorAST.PatternFilter pf = (ClassificatorAST.PatternFilter)matcher;
            return this.patternFrameMatcher(pf.patterns);
        }
        if (matcher instanceof ClassificatorAST.FalseFilter) {
            return this.falseFrameMatcher();
        }
        if (matcher instanceof ClassificatorAST.AnyOfFrameMatcher) {
            ClassificatorAST.AnyOfFrameMatcher any = (ClassificatorAST.AnyOfFrameMatcher)matcher;
            ArrayList<String> patterns = new ArrayList<String>();
            ArrayList<StackFrameMatcher> list = new ArrayList<StackFrameMatcher>();
            for (ClassificatorAST.FrameMatcher m : any.submatchers) {
                if (m instanceof ClassificatorAST.FalseFilter) continue;
                if (m instanceof ClassificatorAST.PatternFilter) {
                    patterns.addAll(((ClassificatorAST.PatternFilter)m).patterns);
                    continue;
                }
                list.add(this.build(m));
            }
            if (!patterns.isEmpty()) {
                list.add(this.patternFrameMatcher(patterns));
            }
            if (list.isEmpty()) {
                return this.falseFrameMatcher();
            }
            if (list.size() == 1) {
                return (StackFrameMatcher)list.get(0);
            }
            return this.matcherConjunction(list);
        }
        throw new IllegalArgumentException("Unknown ASt node: " + matcher);
    }

    public ThreadSnapshotFilter disjunction(ThreadSnapshotFilter ... subfilters) {
        return this.disjunction(Arrays.asList(subfilters));
    }

    public ThreadSnapshotFilter disjunction(Collection<ThreadSnapshotFilter> subfilters) {
        if (subfilters.isEmpty()) {
            return this.trueFilter();
        }
        return new DisjunctionFilter(subfilters.toArray(new ThreadSnapshotFilter[0]));
    }

    public ThreadSnapshotFilter conjunction(ThreadSnapshotFilter ... subfilters) {
        return this.conjunction(Arrays.asList(subfilters));
    }

    public ThreadSnapshotFilter conjunction(Collection<ThreadSnapshotFilter> subfilters) {
        if (subfilters.isEmpty()) {
            return this.falseFilter();
        }
        return new ConjunctionFilter(subfilters.toArray(new ThreadSnapshotFilter[0]));
    }

    public StackFrameMatcher matcherConjunction(StackFrameMatcher ... subfilters) {
        return this.matcherConjunction(Arrays.asList(subfilters));
    }

    public StackFrameMatcher matcherConjunction(Collection<StackFrameMatcher> subfilters) {
        if (subfilters.isEmpty()) {
            return this.falseFrameMatcher();
        }
        return new ConjunctionMatcher(subfilters.toArray(new StackFrameMatcher[0]));
    }

    public ThreadSnapshotFilter not(final ThreadSnapshotFilter filter) {
        return new ThreadSnapshotFilter(){

            @Override
            public boolean evaluate(ThreadSnapshot snapshot) {
                return !filter.evaluate(snapshot);
            }
        };
    }

    public ThreadSnapshotFilter followed(PositionalStackMatcher matcher, ThreadSnapshotFilter filter) {
        return new FollowedPredicate(matcher, filter);
    }

    public ThreadSnapshotFilter frameFilter(final StackFrameMatcher matcher) {
        return new ThreadSnapshotFilter(){

            @Override
            public boolean evaluate(ThreadSnapshot snapshot) {
                for (StackFrame frame : snapshot.stackTrace()) {
                    if (!matcher.evaluate(frame)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public ThreadSnapshotFilter falseFilter() {
        return new FalseFilter();
    }

    public StackFrameMatcher falseFrameMatcher() {
        return new FalseMatcher();
    }

    public ThreadSnapshotFilter trueFilter() {
        return new TrueFilter();
    }

    public StackFrameMatcher patternFrameMatcher(String ... patterns) {
        return this.patternFrameMatcher(Arrays.asList(patterns));
    }

    public StackFrameMatcher patternFrameMatcher(Collection<String> patterns) {
        if (patterns.isEmpty()) {
            throw new IllegalArgumentException("Pattern list is empty");
        }
        return new PatternFrameMatcher(patterns);
    }

    public PositionalStackMatcher lastFrame(StackFrameMatcher matcher) {
        return new LastFrameMatcher(matcher);
    }

    protected static String wildCardTranslate(String pattern) {
        String separator = ".";
        StringBuffer sb = new StringBuffer();
        String es = BasicFilterFactory.escape(separator);
        Matcher ss = Pattern.compile("^([*][*][" + es + "]).*").matcher(pattern);
        if (ss.matches()) {
            pattern = pattern.substring(ss.group(1).length());
            sb.append("(.*[" + es + "])?");
        }
        Matcher st = Pattern.compile(".*([" + es + "][*][*])$").matcher(pattern);
        boolean useSt = false;
        if (st.matches()) {
            pattern = pattern.substring(0, st.start(1));
            useSt = true;
        }
        for (int i = 0; i != pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '?') {
                sb.append("[^" + es + "]");
                continue;
            }
            if (c == '*') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '*') {
                    ++i;
                    sb.append(".*");
                    continue;
                }
                sb.append("[^" + es + "]*");
                continue;
            }
            if (c == '$') {
                sb.append("\\$");
                continue;
            }
            if (Character.isJavaIdentifierPart(c) || Character.isWhitespace(c)) {
                sb.append(c);
                continue;
            }
            sb.append('\\').append(c);
        }
        if (useSt) {
            sb.append("([" + es + "].*)?");
        }
        return sb.toString();
    }

    private static String escape(String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i != separator.length(); ++i) {
            char c = separator.charAt(i);
            if ("\\[]&-".indexOf(c) >= 0) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected static class ThreadSnapProxy
    implements ThreadSnapshot {
        ThreadSnapshot snap;
        StackFrameList stack;

        public ThreadSnapProxy(ThreadSnapshot snap, StackFrameList stack) {
            this.snap = snap;
            this.stack = stack;
        }

        @Override
        public long threadId() {
            return this.snap.threadId();
        }

        @Override
        public String threadName() {
            return this.snap.threadName();
        }

        @Override
        public long timestamp() {
            return this.snap.timestamp();
        }

        @Override
        public StackFrameList stackTrace() {
            return this.stack != null ? this.stack : this.snap.stackTrace();
        }

        @Override
        public Thread.State threadState() {
            return this.snap.threadState();
        }

        @Override
        public CounterCollection counters() {
            return this.snap.counters();
        }
    }

    protected static class PatternFrameMatcher
    implements StackFrameMatcher {
        private final Pattern regEx;

        PatternFrameMatcher(Collection<String> patterns) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (String pattern : patterns) {
                sb.append(BasicFilterFactory.wildCardTranslate(pattern));
                sb.append('|');
            }
            sb.setCharAt(sb.length() - 1, ')');
            this.regEx = Pattern.compile(sb.toString());
        }

        @Override
        public boolean evaluate(StackFrame frame) {
            return this.regEx.matcher(frame).lookingAt();
        }
    }

    protected static class ConjunctionMatcher
    implements StackFrameMatcher {
        private final StackFrameMatcher[] matchers;

        public ConjunctionMatcher(StackFrameMatcher[] matcher) {
            this.matchers = matcher;
        }

        @Override
        public boolean evaluate(StackFrame frame) {
            for (StackFrameMatcher f : this.matchers) {
                if (f.evaluate(frame)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class ConjunctionFilter
    implements ThreadSnapshotFilter {
        private final ThreadSnapshotFilter[] filters;

        public ConjunctionFilter(ThreadSnapshotFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            for (ThreadSnapshotFilter f : this.filters) {
                if (f.evaluate(snapshot)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class DisjunctionFilter
    implements ThreadSnapshotFilter {
        private final ThreadSnapshotFilter[] filters;

        public DisjunctionFilter(ThreadSnapshotFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            for (ThreadSnapshotFilter f : this.filters) {
                if (f.evaluate(snapshot)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class FollowedPredicate
    implements ThreadSnapshotFilter {
        private final PositionalStackMatcher matcher;
        private final ThreadSnapshotFilter tailFilter;

        public FollowedPredicate(PositionalStackMatcher matcher, ThreadSnapshotFilter tailFilter) {
            this.matcher = matcher;
            this.tailFilter = tailFilter;
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            int m;
            int n = -1;
            while ((m = this.matcher.matchNext(snapshot.stackTrace(), n + 1)) >= 0) {
            }
            if (n >= 0) {
                StackFrameList remained = snapshot.stackTrace();
                remained = remained.fragment(n, remained.depth());
                return this.tailFilter.evaluate(new ThreadSnapProxy(snapshot, remained));
            }
            return false;
        }
    }

    protected class LastFrameMatcher
    implements PositionalStackMatcher {
        private final StackFrameMatcher matcher;

        public LastFrameMatcher(StackFrameMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public int matchNext(StackFrameList trace, int matchFrom) {
            for (int i = trace.depth() - 1; i >= matchFrom; --i) {
                if (!this.matcher.evaluate(trace.frameAt(i))) continue;
                return i;
            }
            return -1;
        }
    }

    protected final class FalseFilter
    implements ThreadSnapshotFilter {
        protected FalseFilter() {
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            return false;
        }
    }

    protected final class FalseMatcher
    implements StackFrameMatcher {
        protected FalseMatcher() {
        }

        @Override
        public boolean evaluate(StackFrame frame) {
            return false;
        }
    }

    protected final class TrueFilter
    implements ThreadSnapshotFilter {
        protected TrueFilter() {
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            return true;
        }
    }
}

