/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;

public abstract class AbstractStackFrameArray
implements StackFrameList {
    protected abstract StackFrame[] array();

    protected abstract int from();

    protected abstract int to();

    @Override
    public Iterator<StackFrame> iterator() {
        return new Iterator<StackFrame>(){
            int n;
            {
                this.n = AbstractStackFrameArray.this.from();
            }

            @Override
            public boolean hasNext() {
                return this.n < AbstractStackFrameArray.this.to();
            }

            @Override
            public StackFrame next() {
                if (this.n >= AbstractStackFrameArray.this.to()) {
                    throw new NoSuchElementException();
                }
                return AbstractStackFrameArray.this.array()[this.n++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public StackFrame frameAt(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(n + " < 0");
        }
        int nn = this.from() + n;
        if (nn >= this.to()) {
            throw new IndexOutOfBoundsException(nn + " > [" + this.from() + "," + this.to() + ")");
        }
        return this.array()[nn];
    }

    @Override
    public int depth() {
        return this.to() - this.from();
    }

    @Override
    public StackFrameList fragment(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException();
        }
        int nfrom = this.from() + from;
        int nto = this.from() + to;
        if (nfrom >= this.to() || nfrom < this.from()) {
            throw new IndexOutOfBoundsException(nfrom + " > [" + this.from() + "," + this.to() + ")");
        }
        if (nto > this.to() || nto < this.from()) {
            throw new IndexOutOfBoundsException(nto + " > [" + this.from() + "," + this.to() + "]");
        }
        return new StackFrameArray(this.array(), nfrom, nto);
    }

    @Override
    public StackFrame[] toArray() {
        return Arrays.copyOfRange(this.array(), this.from(), this.to());
    }

    public String toString() {
        return Arrays.asList(this.array()).subList(this.from(), this.to()).toString();
    }
}

