/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.lang.management.ThreadInfo;
import java.util.Arrays;
import org.gridkit.jvmtool.stacktrace.ThreadCounter;

public class ThreadSnapshot {
    public long threadId;
    public String threadName;
    public long timestamp;
    public StackTraceElement[] elements;
    public long[] counters = new long[32];
    public Thread.State state;

    public void copyFrom(ThreadInfo info) {
        this.threadId = info.getThreadId();
        this.threadName = info.getThreadName();
        this.elements = info.getStackTrace();
        this.state = info.getThreadState();
        if (info.getBlockedCount() > 0L) {
            this.setCounter(ThreadCounter.BLOCKED_COUNTER, info.getBlockedCount());
        }
        if (info.getBlockedTime() > 0L) {
            this.setCounter(ThreadCounter.BLOCKED_TIME, info.getBlockedTime());
        }
        if (info.getWaitedCount() > 0L) {
            this.setCounter(ThreadCounter.WAIT_COUNTER, info.getWaitedCount());
        }
        if (info.getWaitedTime() > 0L) {
            this.setCounter(ThreadCounter.WAIT_TIME, info.getWaitedTime());
        }
    }

    public void setCounter(ThreadCounter c, long value) {
        this.counters[c.ordinal()] = value;
    }

    public void setCounter(int counterId, long value) {
        this.counters[counterId] = value;
    }

    public void reset() {
        this.threadId = -1L;
        this.threadName = null;
        this.timestamp = -1L;
        this.elements = null;
        Arrays.fill(this.counters, -1L);
        this.state = null;
    }
}

