/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.stacktrace.StackTraceWriter;
import org.gridkit.jvmtool.stacktrace.ThreadCounter;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

public class ThreadDumpSampler {
    boolean collectCpu = true;
    boolean collectUserCpu = true;
    boolean collectAllocation = true;
    private ThreadMXBean threading;
    private Pattern threadFilter;
    private long[] threadSet;
    private List<CounterCollector> collectors = new ArrayList<CounterCollector>();

    public void setThreadFilter(String pattern) {
        this.threadFilter = Pattern.compile(pattern);
    }

    public void enableThreadCpu(boolean enable) {
        this.collectCpu = true;
    }

    public void enableThreadUserCpu(boolean enable) {
        this.collectUserCpu = true;
    }

    public void enableThreadAllocation(boolean enable) {
        this.collectAllocation = true;
    }

    public void connect(ThreadMXBean threadingMBean) {
        this.threading = threadingMBean;
        this.collectors.clear();
        if (this.collectCpu) {
            this.collectors.add(new GenericMBeanThreadCounter(threadingMBean, CounterType.CPU_TIME));
        }
        if (this.collectUserCpu) {
            this.collectors.add(new GenericMBeanThreadCounter(threadingMBean, CounterType.USER_TIME));
        }
        if (this.collectAllocation) {
            this.collectors.add(new GenericMBeanThreadCounter(threadingMBean, CounterType.ALLOCATED_BYTES));
        }
    }

    public void prime() {
        ThreadInfo[] ti = this.threading.dumpAllThreads(false, false);
        long[] tids = new long[ti.length];
        int n = 0;
        for (ThreadInfo t : ti) {
            long tid = t.getThreadId();
            String name = t.getThreadName();
            if (this.threadFilter != null && !this.threadFilter.matcher(name).matches()) continue;
            tids[n++] = tid;
        }
        tids = Arrays.copyOf(tids, n);
        this.threadSet = tids;
    }

    public void collect(StackTraceWriter writer) throws IOException {
        long timestamp = System.currentTimeMillis();
        ThreadInfo[] dump = this.threadSet != null ? this.compactThreads(this.threading.getThreadInfo(this.threadSet, Integer.MAX_VALUE)) : this.filterThreads(this.threading.dumpAllThreads(false, false));
        long[] ids = new long[dump.length];
        for (int i = 0; i != dump.length; ++i) {
            ids[i] = dump[i].getThreadId();
        }
        for (CounterCollector cc : this.collectors) {
            try {
                cc.collect(ids);
            }
            catch (Exception e) {}
        }
        ThreadSnapshot ts = new ThreadSnapshot();
        for (ThreadInfo ti : dump) {
            ts.reset();
            ts.timestamp = timestamp;
            ts.copyFrom(ti);
            for (CounterCollector cc : this.collectors) {
                try {
                    cc.fillIntoSnapshot(ts);
                }
                catch (Exception e) {}
            }
            writer.write(ts);
        }
    }

    private ThreadInfo[] compactThreads(ThreadInfo[] dumpAllThreads) {
        int n = 0;
        for (int i = 0; i != dumpAllThreads.length; ++i) {
            if (dumpAllThreads[i] == null) continue;
            ++n;
        }
        if (n == dumpAllThreads.length) {
            return dumpAllThreads;
        }
        ThreadInfo[] result = new ThreadInfo[n];
        n = 0;
        for (ThreadInfo ti : dumpAllThreads) {
            if (ti == null) continue;
            result[n++] = ti;
        }
        return result;
    }

    private ThreadInfo[] filterThreads(ThreadInfo[] dumpAllThreads) {
        if (this.threadFilter == null) {
            return this.compactThreads(dumpAllThreads);
        }
        Matcher m = this.threadFilter.matcher("");
        int n = 0;
        for (int i = 0; i != dumpAllThreads.length; ++i) {
            if (dumpAllThreads[i] == null) continue;
            m.reset(dumpAllThreads[i].getThreadName());
            if (m.matches()) {
                ++n;
                continue;
            }
            dumpAllThreads[i] = null;
        }
        if (n == dumpAllThreads.length) {
            return dumpAllThreads;
        }
        ThreadInfo[] result = new ThreadInfo[n];
        n = 0;
        for (ThreadInfo ti : dumpAllThreads) {
            if (ti == null) continue;
            result[n++] = ti;
        }
        return result;
    }

    private static class GenericMBeanThreadCounter
    implements CounterCollector {
        private ThreadMXBean slowBean;
        private com.sun.management.ThreadMXBean fastBean;
        private CounterType counter;
        private long[] threads;
        private long[] counters;
        private int n = 0;

        public GenericMBeanThreadCounter(ThreadMXBean bean, CounterType counter) {
            this.slowBean = bean;
            try {
                if (bean instanceof com.sun.management.ThreadMXBean) {
                    this.fastBean = (com.sun.management.ThreadMXBean)bean;
                }
            }
            catch (NoClassDefFoundError e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.counter = counter;
        }

        @Override
        public void collect(long[] threadID) {
            this.n = 0;
            this.threads = threadID;
            if (this.fastBean != null) {
                this.counters = this.callFast(this.threads);
            } else {
                for (int i = 0; i != this.threads.length; ++i) {
                    this.counters[i] = this.callSlow(this.threads[i]);
                }
            }
        }

        private long[] callFast(long[] threads) {
            switch (this.counter) {
                case CPU_TIME: {
                    return this.fastBean.getThreadCpuTime(threads);
                }
                case USER_TIME: {
                    return this.fastBean.getThreadUserTime(threads);
                }
                case ALLOCATED_BYTES: {
                    return this.fastBean.getThreadAllocatedBytes(threads);
                }
            }
            throw new RuntimeException("Unknown counter: " + (Object)((Object)this.counter));
        }

        private long callSlow(long threadId) {
            switch (this.counter) {
                case CPU_TIME: {
                    return this.slowBean.getThreadCpuTime(threadId);
                }
                case USER_TIME: {
                    return this.slowBean.getThreadUserTime(threadId);
                }
                case ALLOCATED_BYTES: {
                    return -1L;
                }
            }
            throw new RuntimeException("Unknown counter: " + (Object)((Object)this.counter));
        }

        @Override
        public void fillIntoSnapshot(ThreadSnapshot snap) {
            ThreadCounter counterKey;
            int n = this.indexOf(snap.threadId);
            switch (this.counter) {
                case CPU_TIME: {
                    counterKey = ThreadCounter.CPU_TIME;
                    break;
                }
                case USER_TIME: {
                    counterKey = ThreadCounter.USER_TIME;
                    break;
                }
                case ALLOCATED_BYTES: {
                    counterKey = ThreadCounter.ALLOCATED_BYTES;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown counter: " + (Object)((Object)this.counter));
                }
            }
            snap.setCounter(counterKey, this.counters[n]);
        }

        private int indexOf(long threadId) {
            if (this.threads[this.n] == threadId) {
                return this.n;
            }
            ++this.n;
            if (this.threads[this.n] == threadId) {
                return this.n;
            }
            for (int i = 0; i != this.threads.length; ++i) {
                if (this.threads[i] != threadId) continue;
                this.n = i;
                return this.n;
            }
            return -1;
        }
    }

    private static enum CounterType {
        CPU_TIME,
        USER_TIME,
        ALLOCATED_BYTES;

    }

    static interface CounterCollector {
        public void collect(long[] var1);

        public void fillIntoSnapshot(ThreadSnapshot var1);
    }

    public static class Trace
    implements Serializable {
        private long threadId;
        private long timestamp;
        private int[] trace;
        private StackTraceElement[] traceDictionary;

        public Trace(long threadId, long timestamp, int[] trace) {
            this.threadId = threadId;
            this.timestamp = timestamp;
            this.trace = trace;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public StackTraceElement[] getTrace() {
            StackTraceElement[] strace = new StackTraceElement[this.trace.length];
            for (int i = 0; i != strace.length; ++i) {
                strace[i] = this.traceDictionary[this.trace[i]];
            }
            return strace;
        }

        public void copyToSnapshot(ThreadSnapshot snap) {
            snap.reset();
            snap.threadId = this.threadId;
            snap.timestamp = this.timestamp;
            snap.elements = this.getTrace();
        }
    }
}

