/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.codec.json;

import java.util.ArrayList;
import java.util.List;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.codec.json.JsonStreamHandler;

abstract class StackTraceHandler
implements JsonStreamHandler.JsonObjectHandler {
    protected boolean truncated = false;
    protected List<StackFrame> frames = new ArrayList<StackFrame>();
    protected JsonStreamHandler.JsonListHandler frameListHandler = new JsonStreamHandler.JsonListHandler(){

        @Override
        public void onNextValue(Object val) {
            throw new IllegalStateException("Frame object is expected");
        }

        @Override
        public JsonStreamHandler.JsonEntityHandler onNextEntity() {
            return StackTraceHandler.this.frameHandler;
        }

        @Override
        public void onListComplete() {
        }
    };
    protected JsonStreamHandler.JsonObjectHandler frameHandler = new JsonStreamHandler.JsonObjectHandler(){
        private JsonStreamHandler.JsonObjectHandler methodHandler = new JsonStreamHandler.JsonObjectHandler(){

            @Override
            public void onScalarFieldValue(String fieldName, Object val) {
                if (val != null) {
                    if ("class".equals(fieldName)) {
                        className = StackTraceHandler.asString(val);
                    } else if ("method".equals(fieldName)) {
                        methodName = StackTraceHandler.asString(val);
                    }
                }
            }

            @Override
            public void onObjectComplete() {
            }

            @Override
            public JsonStreamHandler.JsonEntityHandler onEntityField(String fieldName) {
                return JsonStreamHandler.NULL_HANDLER;
            }
        };
        private String className;
        private String methodName;
        private int line = -1;

        @Override
        public void onScalarFieldValue(String fieldName, Object val) {
            if (val != null) {
                if ("lineNumber".equals(fieldName)) {
                    this.line = StackTraceHandler.asInt(val);
                    this.line = this.line == 0 ? -1 : this.line;
                } else if ("type".equals(fieldName) && "Native".equals(val)) {
                    this.line = -2;
                }
            }
        }

        @Override
        public void onObjectComplete() {
            StackFrame frame = new StackFrame("", String.valueOf(this.className), String.valueOf(this.methodName), this.line >= 0 ? "java" : null, this.line);
            StackTraceHandler.this.frames.add(frame);
            this.className = null;
            this.methodName = null;
        }

        @Override
        public JsonStreamHandler.JsonEntityHandler onEntityField(String fieldName) {
            if ("method".equals(fieldName)) {
                return this.methodHandler;
            }
            return JsonStreamHandler.NULL_HANDLER;
        }
    };

    StackTraceHandler() {
    }

    @Override
    public void onScalarFieldValue(String fieldName, Object val) {
        if (val != null && "truncated".equals(fieldName)) {
            this.truncated = StackTraceHandler.asBoolean(val);
        }
    }

    @Override
    public JsonStreamHandler.JsonEntityHandler onEntityField(String fieldName) {
        if ("frames".equals(fieldName)) {
            return this.frameListHandler;
        }
        return JsonStreamHandler.NULL_HANDLER;
    }

    @Override
    public void onObjectComplete() {
        this.onComplete();
        this.truncated = false;
        this.frames.clear();
    }

    protected abstract void onComplete();

    private static String asString(Object val) {
        return String.valueOf(val);
    }

    private static int asInt(Object val) {
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            try {
                return Integer.parseInt((String)val);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number expected: " + val);
            }
        }
        throw new IllegalArgumentException("Number expected: " + val);
    }

    private static boolean asBoolean(Object val) {
        if (val instanceof Boolean) {
            return Boolean.TRUE.equals(val);
        }
        throw new IllegalArgumentException("Boolean expected: " + val);
    }
}

