/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.RotatingStringDictionary;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;
import org.gridkit.jvmtool.stacktrace.StackTraceWriter;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

class StackTraceWriterV2
implements StackTraceWriter {
    private DataOutputStream dos;
    private Map<String, Integer> stringDic = new HashMap<String, Integer>();
    private Map<StackTraceElement, Integer> frameDic = new HashMap<StackTraceElement, Integer>();
    private RotatingStringDictionary dynDic = new RotatingStringDictionary(512);
    private List<String> counterKeys = new ArrayList<String>();

    public StackTraceWriterV2(OutputStream os) throws IOException {
        os.write(StackTraceCodec.MAGIC2);
        DeflaterOutputStream def = new DeflaterOutputStream(os);
        this.dos = new DataOutputStream(def);
    }

    @Override
    public void write(ThreadSnapshot snap) throws IOException {
        for (StackFrame ste : snap.stackTrace()) {
            this.intern(ste.toStackTraceElement());
        }
        for (String ckey : snap.counters()) {
            this.ensureCounter(ckey);
        }
        int threadNameRef = 0;
        if (snap.threadName() != null) {
            threadNameRef = this.internDyn(snap.threadName());
        }
        this.dos.writeByte(3);
        StackTraceCodec.writeVarLong(this.dos, snap.threadId());
        StackTraceCodec.writeVarInt(this.dos, threadNameRef);
        StackTraceCodec.writeTimestamp(this.dos, snap.timestamp());
        this.writeState(snap.threadState());
        this.writeCounters(snap.counters());
        this.writeTrace(snap.stackTrace());
    }

    private void writeCounters(CounterCollection counters) throws IOException {
        long val;
        for (int n = 0; n < this.counterKeys.size(); n += 8) {
            int mask = 0;
            for (int i = 0; i < 8 && n + i < this.counterKeys.size(); ++i) {
                val = counters.getValue(this.counterKeys.get(i));
                if (val < 0L) continue;
                mask = (byte)(mask | 1 << i);
            }
            this.dos.writeByte(mask);
        }
        for (String key : this.counterKeys) {
            val = counters.getValue(key);
            if (val < 0L) continue;
            StackTraceCodec.writeVarLong(this.dos, val);
        }
    }

    private void writeState(Thread.State state) throws IOException {
        StackTraceCodec.writeVarInt(this.dos, state == null ? 0 : state.ordinal() + 1);
    }

    private void writeTrace(StackFrameList trace) throws IOException {
        int n = 0;
        for (StackFrame sf : trace) {
            ++n;
        }
        StackTraceCodec.writeVarInt(this.dos, n);
        for (StackFrame ste : trace) {
            StackTraceCodec.writeVarInt(this.dos, this.intern(ste.toStackTraceElement()));
        }
    }

    private int intern(StackTraceElement ste) throws IOException {
        if (!this.frameDic.containsKey(ste)) {
            String pkg = ste.getClassName();
            int c = pkg.lastIndexOf(46);
            String cn = c < 0 ? pkg : pkg.substring(c + 1);
            pkg = c < 0 ? null : pkg.substring(0, c);
            String mtd = ste.getMethodName();
            String file = ste.getFileName();
            int line = ste.getLineNumber() + 2;
            if (line < 0) {
                line = 0;
            }
            int npkg = this.intern(pkg);
            int ncn = this.intern(cn);
            int nmtd = this.intern(mtd);
            int nfile = this.intern(file);
            this.dos.writeByte(2);
            StackTraceCodec.writeVarInt(this.dos, npkg);
            StackTraceCodec.writeVarInt(this.dos, ncn);
            StackTraceCodec.writeVarInt(this.dos, nmtd);
            StackTraceCodec.writeVarInt(this.dos, nfile);
            StackTraceCodec.writeVarInt(this.dos, line);
            int n = this.frameDic.size() + 1;
            this.frameDic.put(ste, n);
        }
        return this.frameDic.get(ste);
    }

    private int intern(String str) throws IOException {
        if (str == null) {
            return 0;
        }
        if (!this.stringDic.containsKey(str)) {
            this.dos.write(1);
            this.dos.writeUTF(str);
            int n = this.stringDic.size() + 1;
            this.stringDic.put(str, n);
        }
        return this.stringDic.get(str);
    }

    private int internDyn(String str) throws IOException {
        if (str == null) {
            return 0;
        }
        int n = this.dynDic.intern(str);
        if (n < 0) {
            this.dos.write(4);
            StackTraceCodec.writeVarInt(this.dos, (n ^= 0xFFFFFFFF) + 1);
            this.dos.writeUTF(str);
        }
        return ++n;
    }

    private void ensureCounter(String key) throws IOException {
        int n = this.counterKeys.indexOf(key);
        if (n < 0) {
            n = this.counterKeys.size();
            this.counterKeys.add(key);
            this.dos.write(5);
            this.dos.writeUTF(key);
        }
    }

    @Override
    public void close() {
        try {
            this.dos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stringDic.clear();
        this.frameDic.clear();
    }
}

