/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;
import org.gridkit.jvmtool.stacktrace.StackTraceWriter;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.util.LinuxPerfImporter;

public class PerfImportCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "prfi";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new PrfI(host);
    }

    @Parameters(commandDescription="Pref import")
    public static class PrfI
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @Parameter(names={"-i", "--input"}, required=true, description="Name of file to read perf data, use '-' for stdin")
        private String inputFile;
        @Parameter(names={"-f", "--filter"}, required=false, description="Event type filter, default - first event type read")
        private String filter = null;
        @Parameter(names={"-o", "--output"}, required=true, description="Name of file to write thread dump")
        private String outputFile;
        @Parameter(names={"-u", "--upscale"}, required=false, description="Upscale factor, default 3")
        private double upscale = 3.0;
        private int traceCounter;
        private StackTraceWriter writer;

        public PrfI(CommandLauncher host) {
            this.host = host;
        }

        @Override
        public void run() {
            try {
                this.openWriter();
                InputStreamReader reader = "-".equals(this.inputFile) ? new InputStreamReader(System.in) : new FileReader(this.inputFile);
                Iterator<ThreadSnapshot> it = LinuxPerfImporter.parseAndConvert(reader, this.filter, this.upscale, 0L);
                while (it.hasNext()) {
                    ThreadSnapshot event = it.next();
                    this.writer.write(event);
                    ++this.traceCounter;
                }
                System.out.println("Produced " + this.traceCounter + " resampled traces");
                this.writer.close();
            }
            catch (Exception e) {
                this.host.fail("Unexpected error: " + e.toString(), e);
            }
        }

        private void openWriter() throws FileNotFoundException, IOException {
            File file = new File(this.outputFile);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            this.writer = StackTraceCodec.newWriter(new FileOutputStream(file));
            System.out.println("Writing to " + file.getAbsolutePath());
        }
    }
}

