/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.hflame;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gridkit.jvmtool.hflame.JsonFlameDataSet;
import org.gridkit.jvmtool.hflame.XmlUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class FlameTemplateProcessor {
    private final Document template;
    private final Map<String, String> imports = new HashMap<String, String>();
    private final Map<String, JsonFlameDataSet> datasets = new HashMap<String, JsonFlameDataSet>();
    private boolean retainDebug = false;

    public FlameTemplateProcessor(Document template) {
        this.template = template;
        this.initDefaultScripts();
    }

    private void initDefaultScripts() {
    }

    public void retainDebug(boolean retain) {
        this.retainDebug = retain;
    }

    public void setDataSet(String name, JsonFlameDataSet dataSet) {
        this.datasets.put(name, dataSet);
    }

    public void generate(Writer output) throws IOException {
        Document doc = (Document)this.template.cloneNode(true);
        this.transformHead((Element)doc.getDocumentElement().getElementsByTagName("head").item(0));
        this.transformBody((Element)doc.getDocumentElement().getElementsByTagName("body").item(0));
        this.encodeDocument(doc, output);
    }

    private void encodeDocument(Document doc, Writer output) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "utf8");
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(doc.getDocumentElement());
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void transformHead(Element head) throws IOException {
        for (Element e : XmlUtil.elementsOf(head)) {
            String id = XmlUtil.id(e);
            String href = XmlUtil.href(e);
            if ((XmlUtil.isStyleSheet(e) || XmlUtil.isScript(e)) && id == null) {
                if (href != null && !href.startsWith("..")) {
                    if (XmlUtil.isStyleSheet(e)) {
                        Element re = head.getOwnerDocument().createElement("style");
                        head.replaceChild(re, e);
                        this.importCss(href, re);
                    } else {
                        e.removeAttribute("src");
                        this.importJs(href, e);
                    }
                } else {
                    head.removeChild(e);
                }
            }
            if (id != null && id.startsWith("debug_")) {
                if (this.retainDebug) continue;
                head.removeChild(e);
                continue;
            }
            if (id == null || !id.startsWith("importflame_")) continue;
            String flameName = id.substring("importflame_".length());
            e.removeAttribute("id");
            e.removeAttribute("src");
            this.importDataSet(flameName, e);
        }
    }

    private void transformBody(Element node) throws IOException {
        for (Element e : XmlUtil.elementsOf(node)) {
            String id = XmlUtil.id(e);
            if (id != null && id.startsWith("debug_")) {
                if (this.retainDebug) continue;
                node.removeChild(e);
                continue;
            }
            if (id != null && id.startsWith("importflame_")) {
                String flameName = id.substring("importflame_".length());
                e.removeAttribute("id");
                e.removeAttribute("src");
                this.importDataSet(flameName, e);
                continue;
            }
            this.transformBody(e);
        }
    }

    private InputStream openResource(String res) throws IOException {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(res);
    }

    private void importCss(String cssName, Element e) throws IOException {
        String res;
        InputStream is = this.openResource(cssName);
        if (is == null && (res = this.imports.get("css:" + cssName)) != null) {
            is = this.openResource(res);
        }
        if (is == null) {
            throw new IllegalArgumentException("Unknown CSS resource: " + cssName);
        }
        this.loadContent(e, is);
    }

    private void importJs(String jsName, Element e) throws IOException {
        String res;
        InputStream is = this.openResource(jsName);
        if (is == null && (res = this.imports.get("js:" + jsName)) != null) {
            is = this.openResource(res);
        }
        if (is == null) {
            throw new IllegalArgumentException("Unknown script name: " + jsName);
        }
        this.loadContent(e, is);
    }

    private void importDataSet(String flameName, Element e) {
        JsonFlameDataSet dataSet = this.datasets.get(flameName);
        if (dataSet == null) {
            throw new IllegalArgumentException("Unknown data set name: " + flameName);
        }
        for (Text t : XmlUtil.textOf(e)) {
            e.removeChild(t);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("$(document).ready(function() {createFlameChart(\"" + flameName + "\", ");
        dataSet.exportJson(sb);
        sb.append(").initFlameChart()});\n");
        CDATASection text = e.getOwnerDocument().createCDATASection(sb.toString());
        e.appendChild(text);
    }

    private void loadContent(Element e, InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF8")));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null && !line.contains("!!THROW AWAY BELOW!!")) {
            if (!this.retainDebug && line.contains("debug(") && line.contains(");")) continue;
            for (int i = 0; i != line.length(); ++i) {
                char ch = line.charAt(i);
                if (ch == '\r') continue;
                sb.append(ch);
            }
            sb.append('\n');
        }
        reader.close();
        for (Text t : XmlUtil.textOf(e)) {
            e.removeChild(t);
        }
        CDATASection text = e.getOwnerDocument().createCDATASection(sb.toString());
        e.appendChild(text);
    }
}

