/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.lab.jvm.attach.AttachManager;

public class JmxConnectionInfo {
    private CommandLauncher commandHost;
    @Parameter(names={"-p", "--pid"}, description="JVM process PID")
    private Long pid;
    @Parameter(names={"-s", "--socket"}, description="Socket address for JMX port (host:port)")
    private String sockAddr;
    @Parameter(names={"--user"}, description="User for JMX authentication (only for socket connection)")
    private String user = null;
    @Parameter(names={"--password"}, description="Password for JMX authentication (only for socket connection)")
    private String password = null;

    public JmxConnectionInfo(CommandLauncher host) {
        this.commandHost = host;
    }

    public Long getPID() {
        return this.pid;
    }

    public MBeanServerConnection getMServer() {
        if (this.pid == null && this.sockAddr == null) {
            this.commandHost.failAndPrintUsage("JVM process is not specified");
        }
        if (this.pid != null && this.sockAddr != null) {
            this.commandHost.failAndPrintUsage("You can specify eigther PID or JMX socket connection");
        }
        if (this.pid != null) {
            MBeanServerConnection mserver = AttachManager.getDetails(this.pid).getMBeans();
            if (mserver == null) {
                this.commandHost.fail("Failed to access MBean server: " + this.pid);
            }
            return mserver;
        }
        if (this.sockAddr != null) {
            MBeanServerConnection mserver;
            String host = this.host(this.sockAddr);
            int port = this.port(this.sockAddr);
            Map<String, String[]> env = null;
            if (this.user != null || this.password != null) {
                if (this.user == null || this.password == null) {
                    this.commandHost.failAndPrintUsage("Both user and password required for authentication");
                }
                env = Collections.singletonMap("jmx.remote.credentials", new String[]{this.user, this.password});
            }
            if ((mserver = this.connectJmx(host, port, env)) == null) {
                this.commandHost.fail("Failed to access MBean server: " + host + ":" + port);
            }
            return mserver;
        }
        throw new UnsupportedOperationException();
    }

    private MBeanServerConnection connectJmx(String host, int port, Map<String, Object> props) {
        try {
            String proto = System.getProperty("jmx.service.protocol", "rmi");
            String uri = "rmi".equals(proto) ? "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jmxrmi" : "service:jmx:" + proto + "://" + host + ":" + port;
            JMXServiceURL jmxurl = new JMXServiceURL(uri);
            JMXConnector conn = props == null ? JMXConnectorFactory.connect(jmxurl) : JMXConnectorFactory.connect(jmxurl, props);
            MBeanServerConnection mserver = conn.getMBeanServerConnection();
            return mserver;
        }
        catch (MalformedURLException e) {
            this.commandHost.fail("JMX Connection failed: " + e.toString(), e);
        }
        catch (IOException e) {
            this.commandHost.fail("JMX Connection failed: " + e.toString(), e);
        }
        return null;
    }

    private String host(String sockAddr) {
        int c = sockAddr.indexOf(58);
        if (c <= 0) {
            this.commandHost.fail("Invalid socket address: " + sockAddr);
        }
        return sockAddr.substring(0, c);
    }

    private int port(String sockAddr) {
        int c = sockAddr.indexOf(58);
        if (c <= 0) {
            this.commandHost.fail("Invalid socket address: " + sockAddr);
        }
        try {
            return Integer.valueOf(sockAddr.substring(c + 1));
        }
        catch (NumberFormatException e) {
            this.commandHost.fail("Invalid socket address: " + sockAddr);
            return 0;
        }
    }
}

