/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.query;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.query.WhereCollector;
import org.greenrobot.greendao.query.WhereCondition;

public class Join<SRC, DST> {
    final String sourceTablePrefix;
    final AbstractDao<DST, ?> daoDestination;
    final Property joinPropertySource;
    final Property joinPropertyDestination;
    final String tablePrefix;
    final WhereCollector<DST> whereCollector;

    public Join(String sourceTablePrefix, Property sourceJoinProperty, AbstractDao<DST, ?> daoDestination, Property destinationJoinProperty, String joinTablePrefix) {
        this.sourceTablePrefix = sourceTablePrefix;
        this.joinPropertySource = sourceJoinProperty;
        this.daoDestination = daoDestination;
        this.joinPropertyDestination = destinationJoinProperty;
        this.tablePrefix = joinTablePrefix;
        this.whereCollector = new WhereCollector<DST>(daoDestination, joinTablePrefix);
    }

    public Join<SRC, DST> where(WhereCondition cond, WhereCondition ... condMore) {
        this.whereCollector.add(cond, condMore);
        return this;
    }

    public Join<SRC, DST> whereOr(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        this.whereCollector.add(this.or(cond1, cond2, condMore), new WhereCondition[0]);
        return this;
    }

    public WhereCondition or(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        return this.whereCollector.combineWhereConditions(" OR ", cond1, cond2, condMore);
    }

    public WhereCondition and(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        return this.whereCollector.combineWhereConditions(" AND ", cond1, cond2, condMore);
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }
}

