package org.greenrobot.greendao.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks that a field, constructor or method was generated by greenDAO
 * All the code elements that are marked with this annotation can be changed/removed during next run of generation in
 * respect of model changes.
 *
 * @see Keep
 */
@Retention(RetentionPolicy.SOURCE)
@Target({ElementType.FIELD, ElementType.CONSTRUCTOR, ElementType.METHOD})
public @interface Generated {
    int hash() default -1;
}
