/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Checksum;
import org.greenrobot.essentials.StringUtils;

public class IoUtils {
    private static final int BUFFER_SIZE = 8192;

    public static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtils.copyAllBytes(in, out);
        return out.toByteArray();
    }

    public static byte[] readAllBytesAndClose(InputStream in) throws IOException {
        try {
            byte[] byArray = IoUtils.readAllBytes(in);
            return byArray;
        }
        finally {
            IoUtils.safeClose(in);
        }
    }

    public static String readAllChars(Reader reader) throws IOException {
        int read;
        char[] buffer = new char[4096];
        StringBuilder builder = new StringBuilder();
        while ((read = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, read);
        }
        return builder.toString();
    }

    public static String readAllCharsAndClose(Reader reader) throws IOException {
        try {
            String string = IoUtils.readAllChars(reader);
            return string;
        }
        finally {
            IoUtils.safeClose(reader);
        }
    }

    public static void writeAllCharsAndClose(Writer writer, CharSequence text) throws IOException {
        try {
            writer.append(text);
        }
        finally {
            IoUtils.safeClose(writer);
        }
    }

    public static void updateChecksum(InputStream in, Checksum checksum) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            checksum.update(buffer, 0, read);
        }
    }

    public static String getMd5(InputStream in) throws IOException {
        byte[] digest = IoUtils.getDigest(in, "MD5");
        return StringUtils.hex(digest);
    }

    public static String getSha1(InputStream in) throws IOException {
        byte[] digest = IoUtils.getDigest(in, "SHA-1");
        return StringUtils.hex(digest);
    }

    public static String getSha256(InputStream in) throws IOException {
        byte[] digest = IoUtils.getDigest(in, "SHA-256");
        return StringUtils.hex(digest);
    }

    public static byte[] getDigest(InputStream in, String digestAlgo) throws IOException {
        int read;
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance(digestAlgo);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            digester.update(buffer, 0, read);
        }
        return digester.digest();
    }

    public static int copyAllBytes(InputStream in, OutputStream out) throws IOException {
        int read;
        int byteCount = 0;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            byteCount += read;
        }
        return byteCount;
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

