/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.collections;

import java.util.Arrays;

public class LongHashSet {
    protected static final int DEFAULT_CAPACITY = 16;
    private Entry[] table;
    private int capacity;
    private int threshold;
    private volatile int size;
    private volatile float loadFactor = 1.3f;

    public static LongHashSet createSynchronized() {
        return new Synchronized(16);
    }

    public static LongHashSet createSynchronized(int capacity) {
        return new Synchronized(capacity);
    }

    public LongHashSet() {
        this(16);
    }

    public LongHashSet(int capacity) {
        this.capacity = capacity;
        this.threshold = (int)((float)capacity * this.loadFactor + 0.5f);
        this.table = new Entry[capacity];
    }

    public boolean contains(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry entry = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean add(long key) {
        Entry entryOriginal;
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry entry = entryOriginal = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return false;
            }
            entry = entry.next;
        }
        this.table[index] = new Entry(key, entryOriginal);
        ++this.size;
        if (this.size > this.threshold) {
            this.setCapacity(2 * this.capacity);
        }
        return true;
    }

    public boolean remove(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry previous = null;
        Entry entry = this.table[index];
        while (entry != null) {
            Entry next = entry.next;
            if (entry.key == key) {
                if (previous == null) {
                    this.table[index] = next;
                } else {
                    previous.next = next;
                }
                --this.size;
                return true;
            }
            previous = entry;
            entry = next;
        }
        return false;
    }

    public long[] keys() {
        long[] values = new long[this.size];
        int idx = 0;
        for (Entry entry : this.table) {
            while (entry != null) {
                values[idx++] = entry.key;
                entry = entry.next;
            }
        }
        return values;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.table, null);
    }

    public int size() {
        return this.size;
    }

    public void setCapacity(int newCapacity) {
        Entry[] newTable = new Entry[newCapacity];
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry value;
            Entry entry = value = entryArray[i];
            while (entry != null) {
                long key = entry.key;
                int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % newCapacity;
                Entry originalNext = entry.next;
                entry.next = newTable[index];
                newTable[index] = entry;
                entry = originalNext;
            }
        }
        this.table = newTable;
        this.capacity = newCapacity;
        this.threshold = (int)((float)newCapacity * this.loadFactor + 0.5f);
    }

    public void setLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
    }

    public void reserveRoom(int entryCount) {
        this.setCapacity((int)((float)entryCount * this.loadFactor * 1.3f + 0.5f));
    }

    protected static class Synchronized
    extends LongHashSet {
        public Synchronized(int capacity) {
            super(capacity);
        }

        @Override
        public synchronized boolean contains(long key) {
            return super.contains(key);
        }

        @Override
        public synchronized boolean add(long key) {
            return super.add(key);
        }

        @Override
        public synchronized boolean remove(long key) {
            return super.remove(key);
        }

        @Override
        public synchronized long[] keys() {
            return super.keys();
        }

        @Override
        public synchronized void clear() {
            super.clear();
        }

        @Override
        public synchronized void setCapacity(int newCapacity) {
            super.setCapacity(newCapacity);
        }

        @Override
        public synchronized void reserveRoom(int entryCount) {
            super.reserveRoom(entryCount);
        }
    }

    static final class Entry {
        final long key;
        Entry next;

        Entry(long key, Entry next) {
            this.key = key;
            this.next = next;
        }
    }
}

