/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials;

import java.util.Calendar;

public class DateUtils {
    private static ThreadLocal<Calendar> calendarThreadLocal = new DefaultCalendarThreadLocal();

    public static long getTimeForDay(int year, int month, int day) {
        return DateUtils.getTimeForDay(calendarThreadLocal.get(), year, month, day);
    }

    public static long getTimeForDay(Calendar calendar, int year, int month, int day) {
        calendar.clear();
        calendar.set(year, month - 1, day);
        return calendar.getTimeInMillis();
    }

    public static void setTime(Calendar calendar, int hourOfDay, int minute, int second, int millisecond) {
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
    }

    public static int getDayAsReadableInt(long time) {
        Calendar cal = calendarThreadLocal.get();
        cal.setTimeInMillis(time);
        return DateUtils.getDayAsReadableInt(cal);
    }

    public static int getDayAsReadableInt(Calendar calendar) {
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        return year * 10000 + month * 100 + day;
    }

    public static long getTimeFromDayReadableInt(int day) {
        return DateUtils.getTimeFromDayReadableInt(calendarThreadLocal.get(), day, 0);
    }

    public static long getTimeFromDayReadableInt(Calendar calendar, int readableDay, int hour) {
        int day = readableDay % 100;
        int month = readableDay / 100 % 100;
        int year = readableDay / 10000;
        calendar.clear();
        calendar.set(11, hour);
        calendar.set(5, day);
        calendar.set(2, month - 1);
        calendar.set(1, year);
        return calendar.getTimeInMillis();
    }

    public static int getDayDifferenceOfReadableInts(int dayOfBroadcast1, int dayOfBroadcast2) {
        long time1 = DateUtils.getTimeFromDayReadableInt(dayOfBroadcast1);
        long time2 = DateUtils.getTimeFromDayReadableInt(dayOfBroadcast2);
        float daysFloat = (float)((time2 - time1) / 1000L / 60L / 60L) / 24.0f;
        return Math.round(daysFloat);
    }

    public static int getDayDifference(long time1, long time2) {
        return (int)((time2 - time1) / 1000L / 60L / 60L / 24L);
    }

    public static long addDays(long time, int days) {
        Calendar calendar = calendarThreadLocal.get();
        calendar.setTimeInMillis(time);
        calendar.add(6, days);
        return calendar.getTimeInMillis();
    }

    public static void addDays(Calendar calendar, int days) {
        calendar.add(6, days);
    }

    public static final class DefaultCalendarThreadLocal
    extends ThreadLocal<Calendar> {
        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    }
}

