/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.basicRenderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.swingViewer.basicRenderer.ElementRenderer;
import org.graphstream.ui.swingViewer.util.GraphMetrics;
import org.graphstream.ui.view.Camera;

public class NodeRenderer
extends ElementRenderer {
    protected GraphMetrics metrics;
    protected Values size;
    protected Ellipse2D shape;
    protected double width;
    protected double height;
    protected double w2;
    protected double h2;

    @Override
    protected void setupRenderingPass(StyleGroup group, Graphics2D g, Camera camera) {
        this.metrics = camera.getMetrics();
        this.configureText(group, camera);
    }

    @Override
    protected void pushDynStyle(StyleGroup group, Graphics2D g, Camera camera, GraphicElement element) {
        Color color = group.getFillColor(0);
        if (element != null && group.getFillMode() == StyleConstants.FillMode.DYN_PLAIN) {
            color = this.interpolateColor(group, element);
        }
        g.setColor(color);
        if (group.getSizeMode() == StyleConstants.SizeMode.DYN_SIZE) {
            Object s = element.getAttribute("ui.size");
            if (s != null) {
                this.height = this.width = this.metrics.lengthToGu(StyleConstants.convertValue(s));
                this.w2 = this.width / 2.0;
                this.h2 = this.height / 2.0;
            } else {
                this.size = group.getSize();
                this.width = this.metrics.lengthToGu(this.size, 0);
                this.height = this.size.size() > 1 ? this.metrics.lengthToGu(this.size, 1) : this.width;
                this.w2 = this.width / 2.0;
                this.h2 = this.height / 2.0;
            }
        }
    }

    @Override
    protected void pushStyle(StyleGroup group, Graphics2D g, Camera camera) {
        this.size = group.getSize();
        this.shape = new Ellipse2D.Double();
        this.width = this.metrics.lengthToGu(this.size, 0);
        this.height = this.size.size() > 1 ? this.metrics.lengthToGu(this.size, 1) : this.width;
        this.w2 = this.width / 2.0;
        this.h2 = this.height / 2.0;
        Color color = group.getFillColor(0);
        g.setColor(color);
    }

    @Override
    protected void elementInvisible(StyleGroup group, Graphics2D g, Camera camera, GraphicElement element) {
    }

    @Override
    protected void renderElement(StyleGroup group, Graphics2D g, Camera camera, GraphicElement element) {
        GraphicNode node = (GraphicNode)element;
        this.shape.setFrame(node.x - this.w2, node.y - this.h2, this.width, this.height);
        g.fill(this.shape);
        this.renderText(group, g, camera, element);
    }
}

