/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSource;
import org.graphstream.ui.geom.Point3;

public abstract class FileSourceBase
extends SourceBase
implements FileSource {
    protected int QUOTE_CHAR = 34;
    protected int COMMENT_CHAR = 35;
    protected boolean eol_is_significant = false;
    protected ArrayList<CurrentFile> tok_stack = new ArrayList();
    protected StreamTokenizer st;
    protected String filename;
    protected HashMap<String, String> attribute_classes = new HashMap();

    protected FileSourceBase() {
    }

    protected FileSourceBase(boolean eol_is_significant) {
        this.eol_is_significant = eol_is_significant;
    }

    protected FileSourceBase(boolean eol_is_significant, int commentChar, int quoteChar) {
        this.eol_is_significant = eol_is_significant;
        this.COMMENT_CHAR = commentChar;
        this.QUOTE_CHAR = quoteChar;
    }

    @Override
    public void readAll(String filename) throws IOException {
        this.begin(filename);
        while (this.nextEvents()) {
        }
        this.end();
    }

    @Override
    public void readAll(URL url) throws IOException {
        this.begin(url);
        while (this.nextEvents()) {
        }
        this.end();
    }

    @Override
    public void readAll(InputStream stream) throws IOException {
        this.begin(stream);
        while (this.nextEvents()) {
        }
        this.end();
    }

    @Override
    public void readAll(Reader reader) throws IOException {
        this.begin(reader);
        while (this.nextEvents()) {
        }
        this.end();
    }

    @Override
    public void begin(String filename) throws IOException {
        this.pushTokenizer(filename);
    }

    @Override
    public void begin(InputStream stream) throws IOException {
        this.pushTokenizer(stream);
    }

    @Override
    public void begin(URL url) throws IOException {
        this.pushTokenizer(url);
    }

    @Override
    public void begin(Reader reader) throws IOException {
        this.pushTokenizer(reader);
    }

    @Override
    public abstract boolean nextEvents() throws IOException;

    @Override
    public void end() throws IOException {
        this.popTokenizer();
    }

    public void addAttributeClass(String attribute, String attribute_class) {
        this.attribute_classes.put(attribute, attribute_class);
    }

    protected void include(String file) throws IOException {
        this.pushTokenizer(file);
        this.continueParsingInInclude();
        this.popTokenizer();
    }

    protected abstract void continueParsingInInclude() throws IOException;

    protected void pushTokenizer(String file) throws IOException {
        CurrentFile cur;
        StreamTokenizer tok;
        try {
            Reader reader = this.createReaderFrom(file);
            tok = this.createTokenizer(reader);
            cur = new CurrentFile(file, tok, reader);
        }
        catch (FileNotFoundException e) {
            throw new IOException("cannot read file '" + file + "', not found: " + e.getMessage());
        }
        this.configureTokenizer(tok);
        this.tok_stack.add(cur);
        this.st = tok;
        this.filename = file;
    }

    protected Reader createReaderFrom(String file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    protected Reader createReaderFrom(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    protected void pushTokenizer(URL url) throws IOException {
        this.pushTokenizer(url.openStream(), url.toString());
    }

    protected void pushTokenizer(InputStream stream) throws IOException {
        this.pushTokenizer(stream, "<?input-stream?>");
    }

    protected void pushTokenizer(InputStream stream, String name) throws IOException {
        Reader reader = this.createReaderFrom(stream);
        StreamTokenizer tok = this.createTokenizer(reader);
        CurrentFile cur = new CurrentFile(name, tok, reader);
        this.configureTokenizer(tok);
        this.tok_stack.add(cur);
        this.st = tok;
        this.filename = name;
    }

    protected void pushTokenizer(Reader reader) throws IOException {
        StreamTokenizer tok = this.createTokenizer(reader);
        CurrentFile cur = new CurrentFile("<?reader?>", tok, reader);
        this.configureTokenizer(tok);
        this.tok_stack.add(cur);
        this.st = tok;
        this.filename = "<?reader?>";
    }

    private StreamTokenizer createTokenizer(Reader reader) throws IOException {
        return new StreamTokenizer(new BufferedReader(reader));
    }

    protected void configureTokenizer(StreamTokenizer tok) throws IOException {
        if (this.COMMENT_CHAR > 0) {
            tok.commentChar(this.COMMENT_CHAR);
        }
        tok.quoteChar(this.QUOTE_CHAR);
        tok.eolIsSignificant(this.eol_is_significant);
        tok.wordChars(95, 95);
        tok.parseNumbers();
    }

    protected void popTokenizer() throws IOException {
        int n = this.tok_stack.size();
        if (n <= 0) {
            throw new RuntimeException("poped one too many tokenizer");
        }
        CurrentFile cur = this.tok_stack.remove(--n);
        cur.reader.close();
        if (n > 0) {
            cur = this.tok_stack.get(--n);
            this.st = cur.tok;
            this.filename = cur.file;
        }
    }

    protected void pushBack() {
        this.st.pushBack();
    }

    protected void eatEof() throws IOException {
        int tok = this.st.nextToken();
        if (tok != -1) {
            this.parseError("garbage at end of file, expecting EOF, " + this.gotWhat(tok));
        }
    }

    protected void eatEol() throws IOException {
        int tok = this.st.nextToken();
        if (tok != 10) {
            this.parseError("expecting EOL, " + this.gotWhat(tok));
        }
    }

    protected int eatEolOrEof() throws IOException {
        int tok = this.st.nextToken();
        if (tok != 10 && tok != -1) {
            this.parseError("expecting EOL or EOF, " + this.gotWhat(tok));
        }
        return tok;
    }

    protected void eatWord(String word) throws IOException {
        int tok = this.st.nextToken();
        if (tok != -3) {
            this.parseError("expecting `" + word + "', " + this.gotWhat(tok));
        }
        if (!this.st.sval.equals(word)) {
            this.parseError("expecting `" + word + "' got `" + this.st.sval + "'");
        }
    }

    protected void eatWords(String ... words) throws IOException {
        int tok = this.st.nextToken();
        if (tok != -3) {
            this.parseError("expecting one of `[" + Arrays.toString(words) + "]', " + this.gotWhat(tok));
        }
        boolean found = false;
        for (String word : words) {
            if (!this.st.sval.equals(word)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.parseError("expecting one of `[" + Arrays.toString(words) + "]', got `" + this.st.sval + "'");
        }
    }

    protected String eatOneOfTwoWords(String word1, String word2) throws IOException {
        int tok = this.st.nextToken();
        if (tok != -3) {
            this.parseError("expecting `" + word1 + "' or  `" + word2 + "', " + this.gotWhat(tok));
        }
        if (this.st.sval.equals(word1)) {
            return word1;
        }
        if (this.st.sval.equals(word2)) {
            return word2;
        }
        this.parseError("expecting `" + word1 + "' or `" + word2 + "' got `" + this.st.sval + "'");
        return null;
    }

    protected void eatSymbol(char symbol) throws IOException {
        int tok = this.st.nextToken();
        if (tok != symbol) {
            this.parseError("expecting symbol `" + symbol + "', " + this.gotWhat(tok));
        }
    }

    protected int eatSymbols(String symbols) throws IOException {
        int tok = this.st.nextToken();
        int n = symbols.length();
        boolean f = false;
        for (int i = 0; i < n; ++i) {
            if (tok != symbols.charAt(i)) continue;
            f = true;
            i = n;
        }
        if (!f) {
            this.parseError("expecting one of symbols `" + symbols + "', " + this.gotWhat(tok));
        }
        return tok;
    }

    protected void eatWordOrPushbak(String word) throws IOException {
        int tok = this.st.nextToken();
        if (tok != -3) {
            this.pushBack();
        }
        if (!this.st.sval.equals(word)) {
            this.pushBack();
        }
    }

    protected void eatSymbolOrPushback(char symbol) throws IOException {
        int tok = this.st.nextToken();
        if (tok != symbol) {
            this.pushBack();
        }
    }

    protected void eatAllUntilEol() throws IOException {
        if (!this.eol_is_significant) {
            return;
        }
        int tok = this.st.nextToken();
        if (tok == -1) {
            return;
        }
        while (tok != 10 && tok != -1) {
            tok = this.st.nextToken();
        }
    }

    protected void eatAllEols() throws IOException {
        if (!this.eol_is_significant) {
            return;
        }
        int tok = this.st.nextToken();
        while (tok == 10) {
            tok = this.st.nextToken();
        }
        this.pushBack();
    }

    protected String getWord() throws IOException {
        int tok = this.st.nextToken();
        if (tok != -3) {
            this.parseError("expecting a word, " + this.gotWhat(tok));
        }
        return this.st.sval;
    }

    protected char getSymbol() throws IOException {
        int tok = this.st.nextToken();
        if (tok > 0 && tok != -3 && tok != -2 && tok != 10 && tok != -1 && tok != this.QUOTE_CHAR && tok != this.COMMENT_CHAR) {
            return (char)tok;
        }
        this.parseError("expecting a symbol, " + this.gotWhat(tok));
        return '\u0000';
    }

    protected char getSymbolOrPushback() throws IOException {
        int tok = this.st.nextToken();
        if (tok > 0 && tok != -3 && tok != -2 && tok != 10 && tok != -1 && tok != this.QUOTE_CHAR && tok != this.COMMENT_CHAR) {
            return (char)tok;
        }
        this.pushBack();
        return '\u0000';
    }

    protected String getString() throws IOException {
        int tok = this.st.nextToken();
        if (tok != this.QUOTE_CHAR) {
            this.parseError("expecting a string constant, " + this.gotWhat(tok));
        }
        return this.st.sval;
    }

    protected String getWordOrNumber() throws IOException {
        int tok = this.st.nextToken();
        if (tok != -3 && tok != -2) {
            this.parseError("expecting a word or number, " + this.gotWhat(tok));
        }
        if (tok == -2) {
            if (this.st.nval - (double)((int)this.st.nval) == 0.0) {
                return Integer.toString((int)this.st.nval);
            }
            return Double.toString(this.st.nval);
        }
        return this.st.sval;
    }

    protected String getStringOrNumber() throws IOException {
        int tok = this.st.nextToken();
        if (tok != this.QUOTE_CHAR && tok != -2) {
            this.parseError("expecting a string constant or a number, " + this.gotWhat(tok));
        }
        if (tok == -2) {
            if (this.st.nval - (double)((int)this.st.nval) == 0.0) {
                return Integer.toString((int)this.st.nval);
            }
            return Double.toString(this.st.nval);
        }
        return this.st.sval;
    }

    protected String getStringOrWordOrNumberOrPushback() throws IOException {
        int tok = this.st.nextToken();
        if (tok == 10 || tok == -1) {
            this.pushBack();
            return null;
        }
        if (tok == -2) {
            if (this.st.nval - (double)((int)this.st.nval) == 0.0) {
                return Integer.toString((int)this.st.nval);
            }
            return Double.toString(this.st.nval);
        }
        if (tok == -3 || tok == this.QUOTE_CHAR) {
            return this.st.sval;
        }
        this.pushBack();
        return null;
    }

    protected String getStringOrWordOrNumber() throws IOException {
        int tok = this.st.nextToken();
        if (tok == 10 || tok == -1) {
            this.parseError("expecting word, string or number, " + this.gotWhat(tok));
        }
        if (tok == -2) {
            if (this.st.nval - (double)((int)this.st.nval) == 0.0) {
                return Integer.toString((int)this.st.nval);
            }
            return Double.toString(this.st.nval);
        }
        return this.st.sval;
    }

    protected Object getStringOrWordOrNumberO() throws IOException {
        int tok = this.st.nextToken();
        if (tok == 10 || tok == -1) {
            this.parseError("expecting word, string or number, " + this.gotWhat(tok));
        }
        if (tok == -2) {
            return this.st.nval;
        }
        return this.st.sval;
    }

    protected Object getStringOrWordOrSymbolOrNumberO() throws IOException {
        int tok = this.st.nextToken();
        if (tok == 10 || tok == -1) {
            this.parseError("expecting word, string or number, " + this.gotWhat(tok));
        }
        if (tok == -2) {
            return this.st.nval;
        }
        if (tok == -3) {
            return this.st.sval;
        }
        return Character.toString((char)tok);
    }

    protected String getWordOrString() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -3 || tok == this.QUOTE_CHAR) {
            return this.st.sval;
        }
        this.parseError("expecting a word or string, " + this.gotWhat(tok));
        return null;
    }

    protected String getWordOrSymbol() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -2 || tok == this.QUOTE_CHAR || tok == -1) {
            this.parseError("expecting a word or symbol, " + this.gotWhat(tok));
        }
        if (tok == -3) {
            return this.st.sval;
        }
        return Character.toString((char)tok);
    }

    protected String getWordOrSymbolOrPushback() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -2 || tok == this.QUOTE_CHAR || tok == -1) {
            this.pushBack();
            return null;
        }
        if (tok == -3) {
            return this.st.sval;
        }
        return Character.toString((char)tok);
    }

    protected String getWordOrSymbolOrString() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -2 || tok == -1) {
            this.parseError("expecting a word, symbol or string, " + this.gotWhat(tok));
        }
        if (tok == this.QUOTE_CHAR) {
            return this.st.sval;
        }
        if (tok == -3) {
            return this.st.sval;
        }
        return Character.toString((char)tok);
    }

    protected String getAllExceptedEof() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -1) {
            this.parseError("expecting all excepted EOF, " + this.gotWhat(tok));
        }
        if (tok == -2 || tok == -1) {
            if (this.st.nval - (double)((int)this.st.nval) == 0.0) {
                return Integer.toString((int)this.st.nval);
            }
            return Double.toString(this.st.nval);
        }
        if (tok == this.QUOTE_CHAR) {
            return this.st.sval;
        }
        if (tok == -3) {
            return this.st.sval;
        }
        return Character.toString((char)tok);
    }

    protected String getWordOrSymbolOrEof() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -2 || tok == this.QUOTE_CHAR) {
            this.parseError("expecting a word or symbol, " + this.gotWhat(tok));
        }
        if (tok == -3) {
            return this.st.sval;
        }
        if (tok == -1) {
            return "EOF";
        }
        return Character.toString((char)tok);
    }

    protected String getWordOrSymbolOrStringOrEolOrEof() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -2) {
            this.parseError("expecting a word, symbol or string, " + this.gotWhat(tok));
        }
        if (tok == this.QUOTE_CHAR) {
            return this.st.sval;
        }
        if (tok == -3) {
            return this.st.sval;
        }
        if (tok == -1) {
            return "EOF";
        }
        if (tok == 10) {
            return "EOL";
        }
        return Character.toString((char)tok);
    }

    protected String getWordOrNumberOrStringOrEolOrEof() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -2) {
            if (this.st.nval - (double)((int)this.st.nval) != 0.0) {
                return Double.toString(this.st.nval);
            }
            return Integer.toString((int)this.st.nval);
        }
        if (tok == this.QUOTE_CHAR) {
            return this.st.sval;
        }
        if (tok == -3) {
            return this.st.sval;
        }
        if (tok == -1) {
            return "EOF";
        }
        if (tok == 10) {
            return "EOL";
        }
        this.parseError("expecting a word, a number, a string, EOL or EOF, " + this.gotWhat(tok));
        return null;
    }

    protected String getWordOrStringOrEolOrEof() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -3) {
            return this.st.sval;
        }
        if (tok == this.QUOTE_CHAR) {
            return this.st.sval;
        }
        if (tok == 10) {
            return "EOL";
        }
        if (tok == -1) {
            return "EOF";
        }
        this.parseError("expecting a word, a string, EOL or EOF, " + this.gotWhat(tok));
        return null;
    }

    protected String getWordOrSymbolOrNumberOrStringOrEolOrEof() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -2) {
            if (this.st.nval - (double)((int)this.st.nval) != 0.0) {
                return Double.toString(this.st.nval);
            }
            return Integer.toString((int)this.st.nval);
        }
        if (tok == this.QUOTE_CHAR) {
            return this.st.sval;
        }
        if (tok == -3) {
            return this.st.sval;
        }
        if (tok == -1) {
            return "EOF";
        }
        if (tok == 10) {
            return "EOL";
        }
        return Character.toString((char)tok);
    }

    protected double getNumber() throws IOException {
        int tok = this.st.nextToken();
        if (tok != -2) {
            this.parseError("expecting a number, " + this.gotWhat(tok));
        }
        return this.st.nval;
    }

    protected double getNumberExp() throws IOException {
        int tok = this.st.nextToken();
        if (tok != -2) {
            this.parseError("expecting a number, " + this.gotWhat(tok));
        }
        double nb = this.st.nval;
        tok = this.st.nextToken();
        if (tok == -3 && (this.st.sval.startsWith("e-") || this.st.sval.startsWith("e+"))) {
            double exp = Double.parseDouble(this.st.sval.substring(2));
            return Math.pow(nb, exp);
        }
        this.st.pushBack();
        return nb;
    }

    protected String gotWhat(int token) {
        switch (token) {
            case -2: {
                return "got number `" + this.st.nval + "'";
            }
            case -3: {
                return "got word `" + this.st.sval + "'";
            }
            case -1: {
                return "got EOF";
            }
        }
        if (token == this.QUOTE_CHAR) {
            return "got string constant `" + this.st.sval + "'";
        }
        return "unknown symbol `" + token + "' (" + (char)token + ")";
    }

    protected void parseError(String message) throws IOException {
        throw new IOException("parse error: " + this.filename + ": " + this.st.lineno() + ": " + message);
    }

    protected boolean isTrue(String string) {
        if ((string = string.toLowerCase()).equals("1")) {
            return true;
        }
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("yes")) {
            return true;
        }
        return string.equals("on");
    }

    protected boolean isFalse(String string) {
        if ((string = string.toLowerCase()).equals("0")) {
            return true;
        }
        if (string.equals("false")) {
            return true;
        }
        if (string.equals("no")) {
            return true;
        }
        return string.equals("off");
    }

    protected boolean getBoolean(String value) throws NumberFormatException {
        if (this.isTrue(value)) {
            return true;
        }
        if (this.isFalse(value)) {
            return false;
        }
        throw new NumberFormatException("not a truth value `" + value + "'");
    }

    protected double getReal(String value) throws NumberFormatException {
        return Double.parseDouble(value);
    }

    protected long getInteger(String value) throws NumberFormatException {
        return Long.parseLong(value);
    }

    protected Point3 getPoint3(String value) throws NumberFormatException {
        int p0 = value.indexOf(44);
        int p1 = value.indexOf(44, p0 + 1);
        if (p0 > 0 && p1 > 0) {
            String n0 = value.substring(0, p0);
            String n1 = value.substring(p0 + 1, p1);
            String n2 = value.substring(p1 + 1);
            float v0 = Float.parseFloat(n0);
            float v1 = Float.parseFloat(n1);
            float v2 = Float.parseFloat(n2);
            return new Point3(v0, v1, v2);
        }
        throw new NumberFormatException("value '" + value + "' not in a valid point3 format");
    }

    protected static class CurrentFile {
        public String file;
        public StreamTokenizer tok;
        public Reader reader;

        public CurrentFile(String f, StreamTokenizer t, Reader reader) {
            this.file = f;
            this.tok = t;
            this.reader = reader;
        }
    }
}

