/*
  GRANITE DATA SERVICES
  Copyright (C) 2007-2008 ADEQUATE SYSTEMS SARL

  This file is part of Granite Data Services.

  Granite Data Services is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 3 of the License, or (at your
  option) any later version.

  Granite Data Services is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

package org.granite.tide.cdi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

import javax.enterprise.context.ApplicationScoped;


/**
 * TideAsync stores user events configuration
 *
 * @author William DRAI
 */
@ApplicationScoped
public class TideUserEvents implements Serializable
{

    private static final long serialVersionUID = -5395975397632138270L;

    private ConcurrentHashMap<String, UserEvents> userEventsMap = new ConcurrentHashMap<String, UserEvents>();


    public synchronized void registerEventType( String sessionId, Class<?> eventType )
    {
        UserEvents userEvents = userEventsMap.get( sessionId );
        if( userEvents == null )
        {
            userEvents = new UserEvents();
            userEventsMap.put( sessionId, userEvents );
        }
        userEvents.addEventType( eventType );
    }

    public void unregisterSession( String sessionId )
    {
        userEventsMap.remove( sessionId );
    }

    public UserEvents getUserEvents( String sessionId )
    {
        return userEventsMap.get( sessionId );
    }

    public boolean hasEventType( String sessionId, Class<?> eventType )
    {
        UserEvents userEvents = userEventsMap.get( sessionId );
        if( userEvents == null )
        {
            return false;
        }
        return userEvents.hasEventType( eventType );
    }
}
