package org.granite.tide.cdi;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

import org.granite.tide.invocation.ContextUpdate;


@TideComponent
@Interceptor
public class TideComponentInterceptor
{

    @Inject
    private CDIServiceContext tideContext;


    @AroundInvoke
    public Object doAround( InvocationContext invocation ) throws Exception
    {

        TideInvocation tideInvocation = TideInvocation.get();

        if( tideContext == null || tideInvocation == null || tideInvocation.isLocked() )
        {
            return invocation.proceed();
        }

        boolean evaluate = false;

        if( tideInvocation.isEnabled() && !tideInvocation.isUpdated() )
        {
            List<ContextUpdate> updates = new ArrayList<ContextUpdate>( tideInvocation.getUpdates() );
            tideInvocation.updated();
            tideContext.restoreContext( updates, invocation.getTarget() );
            evaluate = true;
        }

        Object result = invocation.proceed();

        if( evaluate )
        {
            tideInvocation.evaluated( tideContext.evaluateResults( invocation.getTarget(), false ) );
        }

        return result;
    }
}
