/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.excel.export;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Mixin;
import groovy.lang.Reference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import pl.touk.excel.export.abilities.CellManipulationAbility;
import pl.touk.excel.export.abilities.FileManipulationAbility;
import pl.touk.excel.export.abilities.RowManipulationAbility;
import pl.touk.excel.export.multisheet.AdditionalSheet;
import pl.touk.excel.export.multisheet.SheetManipulator;

@Mixin(value={RowManipulationAbility.class, CellManipulationAbility.class, FileManipulationAbility.class})
public class XlsxExporter
implements SheetManipulator,
GroovyObject {
    private static final String defaultSheetName = "Report";
    private static final String filenameSuffix = ".xlsx";
    static final String defaultDateFormat = "yyyy/mm/dd h:mm:ss";
    private Map<String, AdditionalSheet> sheets;
    private String worksheetName;
    private CellStyle dateCellStyle;
    private CreationHelper creationHelper;
    protected XSSFWorkbook workbook;
    protected String fileNameWithPath;
    protected OPCPackage zipPackage;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public XlsxExporter() {
        MetaClass metaClass;
        Map map;
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        this.sheets = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(XSSFWorkbook.class);
        this.workbook = (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)object, XSSFWorkbook.class);
        callSiteArray[1].callCurrent((GroovyObject)this, (Object)this.workbook);
    }

    /*
     * WARNING - void declaration
     */
    public XlsxExporter(String string) {
        void destinationFileNameWithPath;
        MetaClass metaClass;
        Map map;
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        this.sheets = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var5_5 = destinationFileNameWithPath;
        this.fileNameWithPath = ShortTypeHandling.castToString((Object)var5_5);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[2].callCurrent((GroovyObject)this, (Object)destinationFileNameWithPath);
            this.workbook = (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)object, XSSFWorkbook.class);
        } else {
            XSSFWorkbook xSSFWorkbook = this.createOrLoadWorkbook((String)destinationFileNameWithPath);
            this.workbook = (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)xSSFWorkbook, XSSFWorkbook.class);
        }
        callSiteArray[3].callCurrent((GroovyObject)this, (Object)this.workbook);
    }

    /*
     * WARNING - void declaration
     */
    public XlsxExporter(String string, String string2) {
        void templateFileNameWithPath;
        void destinationFileNameWithPath;
        MetaClass metaClass;
        Map map;
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        this.sheets = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var6_6 = destinationFileNameWithPath;
        this.fileNameWithPath = ShortTypeHandling.castToString((Object)var6_6);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[4].callCurrent((GroovyObject)this, (Object)templateFileNameWithPath, (Object)destinationFileNameWithPath);
            this.workbook = (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)object, XSSFWorkbook.class);
        } else {
            XSSFWorkbook xSSFWorkbook = this.copyAndLoad((String)templateFileNameWithPath, (String)destinationFileNameWithPath);
            this.workbook = (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)xSSFWorkbook, XSSFWorkbook.class);
        }
        callSiteArray[5].callCurrent((GroovyObject)this, (Object)this.workbook);
    }

    private XSSFWorkbook createOrLoadWorkbook(String fileNameWithPath) {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].callConstructor(File.class, (Object)fileNameWithPath)))) {
            Object object = callSiteArray[8].call(OPCPackage.class, (Object)fileNameWithPath);
            this.zipPackage = (OPCPackage)ScriptBytecodeAdapter.castToType((Object)object, OPCPackage.class);
            return (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callConstructor(XSSFWorkbook.class, (Object)this.zipPackage), XSSFWorkbook.class);
        }
        return (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callConstructor(XSSFWorkbook.class), XSSFWorkbook.class);
    }

    private XSSFWorkbook copyAndLoad(String templateNameWithPath, String destinationNameWithPath) {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(callSiteArray[12].callConstructor(File.class, (Object)templateNameWithPath)))) {
            throw (Throwable)callSiteArray[13].callConstructor(IOException.class, callSiteArray[14].call((Object)"No template file under path: ", (Object)templateNameWithPath));
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[15].callCurrent((GroovyObject)this, (Object)templateNameWithPath, (Object)destinationNameWithPath);
        } else {
            this.copy(templateNameWithPath, destinationNameWithPath);
        }
        Object object = callSiteArray[16].call(OPCPackage.class, (Object)destinationNameWithPath);
        this.zipPackage = (OPCPackage)ScriptBytecodeAdapter.castToType((Object)object, OPCPackage.class);
        return (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callConstructor(XSSFWorkbook.class, (Object)this.zipPackage), XSSFWorkbook.class);
    }

    private Object setUp(XSSFWorkbook workbook) {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        Object object = callSiteArray[18].call((Object)workbook);
        this.creationHelper = (CreationHelper)ScriptBytecodeAdapter.castToType((Object)object, CreationHelper.class);
        Object object2 = callSiteArray[19].callCurrent((GroovyObject)this, callSiteArray[20].callGetProperty(XlsxExporter.class));
        this.dateCellStyle = (CellStyle)ScriptBytecodeAdapter.castToType((Object)object2, CellStyle.class);
        return object2;
    }

    @Override
    public Sheet getSheet() {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call(this.sheets))) {
            AdditionalSheet additionalSheet = (AdditionalSheet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callCurrent((GroovyObject)this), AdditionalSheet.class);
            callSiteArray[23].call(this.sheets, (Object)this.worksheetName, (Object)additionalSheet);
        }
        return (Sheet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callGetProperty(callSiteArray[25].call(this.sheets, (Object)this.worksheetName)), Sheet.class);
    }

    public AdditionalSheet withDefaultSheet() {
        String string;
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        String string2 = this.worksheetName;
        this.worksheetName = string = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : defaultSheetName;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (AdditionalSheet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].callCurrent((GroovyObject)this, (Object)this.worksheetName), AdditionalSheet.class);
        }
        return this.sheet(this.worksheetName);
    }

    public AdditionalSheet sheet(String sheetName) {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call(this.sheets, (Object)sheetName))) {
            Object object = callSiteArray[28].call((Object)this.workbook, (Object)sheetName);
            Sheet workbookSheet = (Sheet)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[29].call((Object)this.workbook, (Object)sheetName)), Sheet.class);
            Object object2 = callSiteArray[30].callConstructor(AdditionalSheet.class, (Object)workbookSheet, callSiteArray[31].callGetProperty((Object)this.workbook), (Object)this.dateCellStyle);
            callSiteArray[32].call(this.sheets, (Object)sheetName, object2);
        }
        return (AdditionalSheet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call(this.sheets, (Object)sheetName), AdditionalSheet.class);
    }

    private void copy(String templateNameWithPath, String destinationNameWithPath) {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        Object object = callSiteArray[34].call(OPCPackage.class, (Object)templateNameWithPath);
        this.zipPackage = (OPCPackage)ScriptBytecodeAdapter.castToType((Object)object, OPCPackage.class);
        Reference originalWorkbook = new Reference((Object)((XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].callConstructor(XSSFWorkbook.class, (Object)this.zipPackage), XSSFWorkbook.class)));
        callSiteArray[36].call(callSiteArray[37].callConstructor(FileOutputStream.class, (Object)destinationNameWithPath), (Object)new GeneratedClosure(this, this, originalWorkbook){
            private /* synthetic */ Reference originalWorkbook;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _copy_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.originalWorkbook = reference = originalWorkbook;
            }

            public Object doCall(OutputStream it) {
                CallSite[] callSiteArray = _copy_closure1.$getCallSiteArray();
                return callSiteArray[0].call(this.originalWorkbook.get(), (Object)it);
            }

            public Object call(OutputStream it) {
                CallSite[] callSiteArray = _copy_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)it);
            }

            public XSSFWorkbook getOriginalWorkbook() {
                CallSite[] callSiteArray = _copy_closure1.$getCallSiteArray();
                return (XSSFWorkbook)ScriptBytecodeAdapter.castToType((Object)this.originalWorkbook.get(), XSSFWorkbook.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copy_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "write";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _copy_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copy_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copy_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
    }

    public XlsxExporter setDateCellFormat(String format) {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[38].callCurrent((GroovyObject)this, (Object)format);
            this.dateCellStyle = (CellStyle)ScriptBytecodeAdapter.castToType((Object)object, CellStyle.class);
        } else {
            CellStyle cellStyle = this.createDateCellStyle(format);
            this.dateCellStyle = (CellStyle)ScriptBytecodeAdapter.castToType((Object)cellStyle, CellStyle.class);
        }
        return this;
    }

    private CellStyle createDateCellStyle(String expectedDateFormat) {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        CellStyle dateCellStyle = (CellStyle)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call((Object)this.workbook), CellStyle.class);
        XSSFDataFormat dateFormat = (XSSFDataFormat)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call((Object)this.workbook), XSSFDataFormat.class);
        Object object = callSiteArray[41].call((Object)dateFormat, (Object)expectedDateFormat);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)dateCellStyle, (String)"dataFormat");
        return dateCellStyle;
    }

    public void setWorksheetName(String worksheetName) {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        String string = worksheetName;
        this.worksheetName = ShortTypeHandling.castToString((Object)string);
    }

    public XSSFWorkbook getWorkbook() {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        return this.workbook;
    }

    @Override
    public CellStyle getDateCellStyle() {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        return this.dateCellStyle;
    }

    @Override
    public CreationHelper getCreationHelper() {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        return this.creationHelper;
    }

    public void finalize() {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[42].callCurrent((GroovyObject)this);
        } else {
            this.closeZipPackageIfPossible();
        }
    }

    private void closeZipPackageIfPossible() {
        CallSite[] callSiteArray = XlsxExporter.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.zipPackage)) {
            try {
                callSiteArray[43].call((Object)this.zipPackage);
            }
            finally {
                Object var2_2 = null;
                this.zipPackage = (OPCPackage)ScriptBytecodeAdapter.castToType(var2_2, OPCPackage.class);
            }
        }
    }

    static {
        XlsxExporter.$getCallSiteArray()[44].call(XlsxExporter.$getCallSiteArray()[45].callGetProperty(XlsxExporter.class), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{RowManipulationAbility.class, CellManipulationAbility.class, FileManipulationAbility.class}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != XlsxExporter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static final String getDefaultSheetName() {
        return defaultSheetName;
    }

    public static final String getFilenameSuffix() {
        return filenameSuffix;
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "setUp";
        stringArray[2] = "createOrLoadWorkbook";
        stringArray[3] = "setUp";
        stringArray[4] = "copyAndLoad";
        stringArray[5] = "setUp";
        stringArray[6] = "exists";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "open";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "exists";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "plus";
        stringArray[15] = "copy";
        stringArray[16] = "open";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "getCreationHelper";
        stringArray[19] = "createDateCellStyle";
        stringArray[20] = "defaultDateFormat";
        stringArray[21] = "isEmpty";
        stringArray[22] = "withDefaultSheet";
        stringArray[23] = "put";
        stringArray[24] = "sheet";
        stringArray[25] = "getAt";
        stringArray[26] = "sheet";
        stringArray[27] = "getAt";
        stringArray[28] = "getSheet";
        stringArray[29] = "createSheet";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "creationHelper";
        stringArray[32] = "putAt";
        stringArray[33] = "getAt";
        stringArray[34] = "open";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "with";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "createDateCellStyle";
        stringArray[39] = "createCellStyle";
        stringArray[40] = "createDataFormat";
        stringArray[41] = "getFormat";
        stringArray[42] = "closeZipPackageIfPossible";
        stringArray[43] = "close";
        stringArray[44] = "mixin";
        stringArray[45] = "metaClass";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[46];
        XlsxExporter.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(XlsxExporter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = XlsxExporter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

