/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import grails.core.GrailsApplication;
import grails.core.support.proxy.EntityProxyHandler;
import grails.core.support.proxy.ProxyHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.core.util.IncludeExcludeSupport;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ManyToOne;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.web.converters.ConverterUtil;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.ByDatasourceDomainClassFetcher;
import org.grails.web.converters.marshaller.ByGrailsApplicationDomainClassFetcher;
import org.grails.web.converters.marshaller.DomainClassFetcher;
import org.grails.web.converters.marshaller.IncludeExcludePropertyMarshaller;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.StringUtils;

public class DomainClassMarshaller
extends IncludeExcludePropertyMarshaller<XML> {
    protected final boolean includeVersion;
    protected boolean includeClass = false;
    protected ProxyHandler proxyHandler;
    protected GrailsApplication application;
    private final List<DomainClassFetcher> domainClassFetchers;

    public DomainClassMarshaller(GrailsApplication application) {
        this(false, application);
    }

    public DomainClassMarshaller(boolean includeVersion, GrailsApplication application) {
        this.includeVersion = includeVersion;
        this.application = application;
        this.domainClassFetchers = Arrays.asList(new ByGrailsApplicationDomainClassFetcher(application), new ByDatasourceDomainClassFetcher());
    }

    public DomainClassMarshaller(boolean includeVersion, ProxyHandler proxyHandler, GrailsApplication application) {
        this(includeVersion, application);
        this.proxyHandler = proxyHandler;
    }

    public DomainClassMarshaller(boolean includeVersion, boolean includeClass, ProxyHandler proxyHandler, GrailsApplication application) {
        this(includeVersion, proxyHandler, application);
        this.includeClass = includeClass;
    }

    @Override
    public boolean supports(Object object) {
        String name = ConverterUtil.trimProxySuffix(object.getClass().getName());
        return this.application.isArtefactOfType("Domain", name);
    }

    @Override
    public void marshalObject(Object value, XML xml) throws ConverterException {
        String str;
        Object versionValue;
        Object idValue;
        Class<?> clazz = value.getClass();
        List<String> excludes = xml.getExcludes(clazz);
        List<String> includes = xml.getIncludes(clazz);
        IncludeExcludeSupport includeExcludeSupport = new IncludeExcludeSupport();
        PersistentEntity domainClass = this.findDomainClass(value);
        if (domainClass == null) {
            throw new GrailsConfigurationException("Could not retrieve the respective entity for domain " + value.getClass().getName() + " in the mapping context API");
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        PersistentProperty id = domainClass.getIdentity();
        if (this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, id.getName()) && (idValue = beanWrapper.getPropertyValue(id.getName())) != null) {
            xml.attribute("id", String.valueOf(idValue));
        }
        if (this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, "version") && this.includeVersion && (versionValue = beanWrapper.getPropertyValue(domainClass.getVersion().getName())) != null && StringUtils.hasText((String)(str = String.valueOf(versionValue)))) {
            xml.attribute("version", str);
        }
        if (this.includeClass && this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, "class")) {
            xml.attribute("class", domainClass.getJavaClass().getName());
        }
        List properties = domainClass.getPersistentProperties();
        for (PersistentProperty property : properties) {
            Object referenceObject;
            String propertyName = property.getName();
            if (property.equals(domainClass.getVersion()) || !this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, property.getName())) continue;
            xml.startNode(propertyName);
            if (!(property instanceof Association)) {
                Object val = beanWrapper.getPropertyValue(propertyName);
                xml.convertAnother(val);
            } else if (this.isRenderDomainClassRelations()) {
                referenceObject = beanWrapper.getPropertyValue(propertyName);
                if (referenceObject != null && this.shouldInitializeProxy(referenceObject)) {
                    if ((referenceObject = this.proxyHandler.unwrapIfProxy(referenceObject)) instanceof SortedMap) {
                        referenceObject = new TreeMap((SortedMap)referenceObject);
                    } else if (referenceObject instanceof SortedSet) {
                        referenceObject = new TreeSet((SortedSet)referenceObject);
                    } else if (referenceObject instanceof Set) {
                        referenceObject = new LinkedHashSet((Set)referenceObject);
                    } else if (referenceObject instanceof Map) {
                        referenceObject = new LinkedHashMap((Map)referenceObject);
                    } else if (referenceObject instanceof Collection) {
                        referenceObject = new ArrayList((Collection)referenceObject);
                    }
                    xml.convertAnother(referenceObject);
                }
            } else {
                referenceObject = beanWrapper.getPropertyValue(propertyName);
                if (referenceObject != null) {
                    PersistentEntity referencedDomainClass = ((Association)property).getAssociatedEntity();
                    if (referencedDomainClass == null || ((Association)property).isEmbedded() || property.getType().isEnum()) {
                        xml.convertAnother(referenceObject);
                    } else if (property instanceof OneToOne || property instanceof ManyToOne || ((Association)property).isEmbedded()) {
                        this.asShortObject(referenceObject, xml, referencedDomainClass.getIdentity(), referencedDomainClass);
                    } else {
                        PersistentProperty referencedIdProperty = referencedDomainClass.getIdentity();
                        String refPropertyName = ((Association)property).getReferencedPropertyName();
                        if (referenceObject instanceof Collection) {
                            Collection o = (Collection)referenceObject;
                            for (Object e : o) {
                                xml.startNode(xml.getElementName(e));
                                this.asShortObject(e, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        } else if (referenceObject instanceof Map) {
                            Map map = (Map)referenceObject;
                            for (Map.Entry entry : map.entrySet()) {
                                String key = String.valueOf(entry.getKey());
                                Object o = entry.getValue();
                                xml.startNode("entry").attribute("key", key);
                                this.asShortObject(o, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        }
                    }
                }
            }
            xml.end();
        }
    }

    private boolean shouldInclude(IncludeExcludeSupport<String> includeExcludeSupport, List<String> includes, List<String> excludes, Object object, String name) {
        return includeExcludeSupport.shouldInclude(includes, excludes, (Object)name) && this.shouldInclude(object, name);
    }

    private boolean shouldInitializeProxy(Object object) {
        return this.proxyHandler.isInitialized(object) || this.shouldInitializeProxies();
    }

    protected boolean shouldInitializeProxies() {
        return true;
    }

    protected void asShortObject(Object refObj, XML xml, PersistentProperty idProperty, PersistentEntity referencedDomainClass) throws ConverterException {
        Object idValue;
        if (this.proxyHandler instanceof EntityProxyHandler) {
            idValue = ((EntityProxyHandler)this.proxyHandler).getProxyIdentifier(refObj);
            if (idValue == null) {
                ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass(refObj.getClass());
                idValue = propertyFetcher.getPropertyValue(refObj, idProperty.getName());
            }
        } else {
            ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass(refObj.getClass());
            idValue = propertyFetcher.getPropertyValue(refObj, idProperty.getName());
        }
        xml.attribute("id", String.valueOf(idValue));
    }

    protected boolean isRenderDomainClassRelations() {
        return false;
    }

    private PersistentEntity findDomainClass(Object value) {
        for (DomainClassFetcher fetcher : this.domainClassFetchers) {
            PersistentEntity domain = fetcher.findDomainClass(value);
            if (domain == null) continue;
            return domain;
        }
        return null;
    }
}

