/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web.filter;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;

public class LazyParamAwareEvaluationContext
extends StandardEvaluationContext {
    protected final ParameterNameDiscoverer paramDiscoverer;
    protected final Method method;
    protected final Object[] args;
    protected final Class<?> targetClass;
    protected final Map<String, Method> methodCache;
    protected boolean paramLoaded = false;

    public LazyParamAwareEvaluationContext(Object rootObject, ParameterNameDiscoverer paramDiscoverer, Method method, Object[] args, Class<?> targetClass, Map<String, Method> methodCache) {
        super(rootObject);
        this.paramDiscoverer = paramDiscoverer;
        this.method = method;
        this.args = args;
        this.targetClass = targetClass;
        this.methodCache = methodCache;
    }

    public Object lookupVariable(String name) {
        Object variable = super.lookupVariable(name);
        if (variable != null) {
            return variable;
        }
        if (!this.paramLoaded) {
            this.loadArgsAsVariables();
            this.paramLoaded = true;
            variable = super.lookupVariable(name);
        }
        return variable;
    }

    protected void loadArgsAsVariables() {
        if (ObjectUtils.isEmpty((Object[])this.args)) {
            return;
        }
        String key = this.toString(this.method);
        Method targetMethod = this.methodCache.get(key);
        if (targetMethod == null) {
            targetMethod = AopUtils.getMostSpecificMethod((Method)this.method, this.targetClass);
            if (targetMethod == null) {
                targetMethod = this.method;
            }
            this.methodCache.put(key, targetMethod);
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.setVariable("p" + i, this.args[i]);
        }
        String[] parameterNames = this.paramDiscoverer.getParameterNames(targetMethod);
        if (parameterNames != null) {
            for (int i = 0; i < parameterNames.length; ++i) {
                this.setVariable(parameterNames[i], this.args[i]);
            }
        }
    }

    protected String toString(Method m) {
        return m.getDeclaringClass().getName() + '#' + m;
    }
}

