/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.GenericFilterBean;

public abstract class AbstractFilter
extends GenericFilterBean {
    public static final String NO_FILTER = "NO_FILTER";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected CacheManager cacheManager;
    protected Object nativeCacheManager;
    protected boolean suppressStackTraces;

    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            if (this.filterNotDisabled(request)) {
                this.doFilter(request, response, chain);
            } else {
                chain.doFilter(req, res);
            }
        }
        catch (Throwable throwable) {
            this.logThrowable(throwable, request);
        }
    }

    protected abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws Throwable;

    protected boolean filterNotDisabled(HttpServletRequest request) {
        return request.getAttribute(NO_FILTER) == null;
    }

    protected void logThrowable(Throwable throwable, HttpServletRequest httpRequest) throws ServletException, IOException {
        StringBuilder messageBuffer = new StringBuilder("Throwable thrown during doFilter on request with URI: ").append(httpRequest.getRequestURI()).append(" and Query: ").append(httpRequest.getQueryString()).append(" : ").append(throwable.getMessage());
        if (this.suppressStackTraces) {
            this.log.warn(messageBuffer.append("\nTop StackTraceElement: ").append(throwable.getStackTrace()[0]).toString());
        } else {
            this.log.warn(messageBuffer.toString(), throwable);
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new ServletException(throwable);
    }

    protected CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected Object getNativeCacheManager() {
        return this.nativeCacheManager;
    }

    protected boolean acceptsEncoding(HttpServletRequest request, String name) {
        return this.headerContains(request, "Accept-Encoding", name);
    }

    protected boolean headerContains(HttpServletRequest request, String header, String value) {
        this.logRequestHeaders(request);
        Enumeration accepted = request.getHeaders(header);
        while (accepted.hasMoreElements()) {
            String headerValue = (String)accepted.nextElement();
            if (headerValue.indexOf(value) == -1) continue;
            return true;
        }
        return false;
    }

    protected void logRequestHeaders(HttpServletRequest request) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        StringBuilder logLine = new StringBuilder("Request Headers");
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String headerValue = request.getHeader(name);
            headers.put(name, headerValue);
            logLine.append(": ").append(name).append(" -> ").append(headerValue);
        }
        this.log.debug(logLine.toString());
    }

    protected boolean acceptsGzipEncoding(HttpServletRequest request) {
        return this.acceptsEncoding(request, "gzip");
    }

    protected <T> T getBean(String name) {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (T)ctx.getBean(name);
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public void setNativeCacheManager(Object manager) {
        this.nativeCacheManager = manager;
    }

    public void setSuppressStackTraces(boolean suppress) {
        this.suppressStackTraces = suppress;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.cacheManager, (String)"cacheManager is required");
        if (this.suppressStackTraces && this.log.isDebugEnabled()) {
            this.log.debug("Suppression of stack traces enabled for {}", (Object)((Object)((Object)this)).getClass().getName());
        }
    }
}

