/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache;

import grails.plugin.cache.GrailsCacheManager;
import grails.plugin.cache.GrailsConcurrentLinkedMapCache;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;

public class GrailsConcurrentLinkedMapCacheManager
implements GrailsCacheManager {
    protected final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    public Cache getCache(String name) {
        return this.getCache(name, 10000);
    }

    public Cache getCache(String name, int capacity) {
        Cache existing;
        Cache cache = (Cache)this.cacheMap.get(name);
        if (cache == null && (existing = this.cacheMap.putIfAbsent(name, cache = this.createConcurrentLinkedMapCache(name, capacity))) != null) {
            cache = existing;
        }
        return cache;
    }

    @Override
    public boolean cacheExists(String name) {
        return this.getCacheNames().contains(name);
    }

    @Override
    public boolean destroyCache(String name) {
        return this.cacheMap.remove(name) != null;
    }

    protected GrailsConcurrentLinkedMapCache createConcurrentLinkedMapCache(String name, long capacity) {
        return new GrailsConcurrentLinkedMapCache(name, capacity);
    }
}

