/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache;

import grails.core.GrailsApplication;
import grails.plugin.cache.CacheOperation;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.SpringCacheAnnotationParser;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class GrailsAnnotationCacheOperationSource
implements CacheOperationSource,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BEAN_NAME = "org.springframework.cache.annotation.AnnotationCacheOperationSource#0";
    protected static final Collection<org.springframework.cache.interceptor.CacheOperation> NULL_CACHING_ATTRIBUTE = Collections.emptyList();
    protected GrailsApplication application;
    protected boolean publicMethodsOnly = true;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Set<CacheAnnotationParser> annotationParsers = new LinkedHashSet<CacheAnnotationParser>(1);
    protected final Map<Object, Collection<org.springframework.cache.interceptor.CacheOperation>> attributeCache = new ConcurrentHashMap<Object, Collection<org.springframework.cache.interceptor.CacheOperation>>();

    public GrailsAnnotationCacheOperationSource() {
        this.annotationParsers.add((CacheAnnotationParser)new SpringCacheAnnotationParser());
    }

    public Collection<org.springframework.cache.interceptor.CacheOperation> getCacheOperations(Method method, Class<?> targetClass, boolean includeControllers) {
        if (!includeControllers && this.isControllerClass(targetClass)) {
            return null;
        }
        return this.doGetCacheOperations(method, targetClass);
    }

    public Collection<org.springframework.cache.interceptor.CacheOperation> getCacheOperations(Method method, Class<?> targetClass) {
        if (method.getAnnotation(CacheOperation.class) == null && targetClass.getAnnotation(CacheOperation.class) == null) {
            return NULL_CACHING_ATTRIBUTE;
        }
        if (this.isControllerClass(targetClass)) {
            return null;
        }
        return this.doGetCacheOperations(method, targetClass);
    }

    protected Collection<org.springframework.cache.interceptor.CacheOperation> doGetCacheOperations(Method method, Class<?> targetClass) {
        Object cacheKey = this.getCacheKey(method, targetClass);
        Collection<org.springframework.cache.interceptor.CacheOperation> cached = this.attributeCache.get(cacheKey);
        if (cached == null) {
            Collection<org.springframework.cache.interceptor.CacheOperation> cacheOps = this.computeCacheOperations(method, targetClass);
            if (cacheOps == null) {
                this.attributeCache.put(cacheKey, NULL_CACHING_ATTRIBUTE);
            } else {
                this.logger.debug("Adding cacheable method '{}' with attribute: {}", (Object)method.getName(), cacheOps);
                this.attributeCache.put(cacheKey, cacheOps);
            }
            return cacheOps;
        }
        if (cached == NULL_CACHING_ATTRIBUTE) {
            return null;
        }
        return cached;
    }

    public void reset() {
        this.attributeCache.clear();
    }

    protected Object getCacheKey(Method method, Class<?> targetClass) {
        return new DefaultCacheKey(method, targetClass);
    }

    protected Collection<org.springframework.cache.interceptor.CacheOperation> computeCacheOperations(Method method, Class<?> targetClass) {
        if (this.publicMethodsOnly && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        Collection<org.springframework.cache.interceptor.CacheOperation> opDef = this.findCacheOperations(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod));
        if (opDef != null) {
            return opDef;
        }
        opDef = this.findCacheOperations(specificMethod.getDeclaringClass());
        if (opDef != null) {
            return opDef;
        }
        if (specificMethod != method) {
            opDef = this.findCacheOperations(method);
            if (opDef != null) {
                return opDef;
            }
            return this.findCacheOperations(method.getDeclaringClass());
        }
        return null;
    }

    protected Collection<org.springframework.cache.interceptor.CacheOperation> findCacheOperations(Class<?> clazz) {
        ArrayList ops = null;
        for (CacheAnnotationParser annotationParser : this.annotationParsers) {
            Collection annOps = annotationParser.parseCacheAnnotations(clazz);
            if (annOps == null) continue;
            if (ops == null) {
                ops = new ArrayList();
            }
            ops.addAll(annOps);
        }
        return ops;
    }

    protected Collection<org.springframework.cache.interceptor.CacheOperation> findCacheOperations(Method method) {
        ArrayList ops = null;
        for (CacheAnnotationParser annotationParser : this.annotationParsers) {
            Collection annOps = annotationParser.parseCacheAnnotations(method);
            if (annOps == null) continue;
            if (ops == null) {
                ops = new ArrayList();
            }
            ops.addAll(annOps);
        }
        return ops;
    }

    protected boolean isControllerClass(Class<?> targetClass) {
        return this.application.isArtefactOfType("Controller", targetClass);
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.application = grailsApplication;
    }

    public void setAllowPublicMethodsOnly(boolean allow) {
        this.publicMethodsOnly = allow;
    }

    protected static class DefaultCacheKey {
        protected final Method method;
        protected final Class<?> targetClass;

        public DefaultCacheKey(Method method, Class<?> targetClass) {
            this.method = method;
            this.targetClass = targetClass;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultCacheKey)) {
                return false;
            }
            DefaultCacheKey otherKey = (DefaultCacheKey)other;
            return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass);
        }

        public int hashCode() {
            return this.method.hashCode() * 29 + (this.targetClass == null ? 0 : this.targetClass.hashCode());
        }
    }
}

