/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.io.Writer;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncoderAware;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

public class CodecPrintWriter
extends GrailsPrintWriter
implements EncoderAware,
EncodedAppenderFactory {
    private final Encoder encoder;
    private final StreamCharBuffer buffer;
    private boolean ignoreEncodingState;

    public CodecPrintWriter(Writer out, Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        this(out, encoder, encodingStateRegistry, false);
    }

    public CodecPrintWriter(Writer out, Encoder encoder, EncodingStateRegistry encodingStateRegistry, boolean ignoreEncodingState) {
        super(null);
        this.encoder = encoder;
        this.buffer = new StreamCharBuffer();
        this.buffer.setNotifyParentBuffersEnabled(false);
        this.allowUnwrappingOut = false;
        this.buffer.connectTo(out, false);
        if (out instanceof EncodedAppenderFactory) {
            this.buffer.setWriteDirectlyToConnectedMinSize(0);
            this.buffer.setChunkMinSize(0);
        }
        this.setOut(this.buffer.getWriterForEncoder(encoder, encodingStateRegistry, ignoreEncodingState));
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public EncodedAppender getEncodedAppender() {
        EncodedAppender encodedAppender = ((EncodedAppenderFactory)this.buffer.getWriter()).getEncodedAppender();
        encodedAppender.setIgnoreEncodingState(this.ignoreEncodingState);
        return encodedAppender;
    }

    @Override
    public Writer getWriterForEncoder(Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        return this.buffer.getWriterForEncoder(encoder, encodingStateRegistry, this.ignoreEncodingState);
    }
}

