/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderWriterFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoder;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoderWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageOutputStackAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.CodecPrintWriter;
import org.codehaus.groovy.grails.web.util.GrailsLazyProxyPrintWriter;
import org.codehaus.groovy.grails.web.util.GrailsWrappedWriter;
import org.springframework.web.context.request.RequestContextHolder;

public final class GroovyPageOutputStack {
    public static final Log log = LogFactory.getLog(GroovyPageOutputStack.class);
    private static final String ATTRIBUTE_NAME_OUTPUT_STACK = "org.codehaus.groovy.grails.GSP_OUTPUT_STACK";
    private Stack<StackEntry> stack = new Stack();
    private GroovyPageProxyWriter taglibWriter;
    private GroovyPageProxyWriter outWriter;
    private GroovyPageProxyWriter staticWriter;
    private GroovyPageProxyWriter expressionWriter;
    private boolean autoSync;
    private EncodingStateRegistry encodingStateRegistry;
    private GroovyPageProxyWriterGroup writerGroup = new GroovyPageProxyWriterGroup();

    public static GroovyPageOutputStack currentStack() {
        return GroovyPageOutputStack.currentStack(true);
    }

    public static GroovyPageOutputStack currentStack(GrailsWebRequest request) {
        return GroovyPageOutputStack.currentStack(request, true);
    }

    public static GroovyPageOutputStack currentStack(boolean allowCreate) {
        return GroovyPageOutputStack.currentStack(GrailsWebRequest.lookup(), allowCreate);
    }

    public static GroovyPageOutputStack currentStack(GrailsWebRequest request, boolean allowCreate) {
        GroovyPageOutputStack outputStack = GroovyPageOutputStack.lookupStack(request);
        if (outputStack == null && allowCreate) {
            outputStack = GroovyPageOutputStack.currentStack(request, allowCreate, null, allowCreate, false);
        }
        return outputStack;
    }

    public static GroovyPageOutputStack currentStack(boolean allowCreate, Writer topWriter, boolean autoSync, boolean pushTop) {
        return GroovyPageOutputStack.currentStack(GrailsWebRequest.lookup(), allowCreate, topWriter, autoSync, pushTop);
    }

    public static GroovyPageOutputStack currentStack(GrailsWebRequest request, boolean allowCreate, Writer topWriter, boolean autoSync, boolean pushTop) {
        return GroovyPageOutputStack.currentStack(new GroovyPageOutputStackAttributes.Builder().webRequest(request).allowCreate(allowCreate).topWriter(topWriter).autoSync(autoSync).pushTop(pushTop).build());
    }

    public static GroovyPageOutputStack currentStack(GroovyPageOutputStackAttributes attributes) {
        GroovyPageOutputStack outputStack = GroovyPageOutputStack.lookupStack(attributes.getWebRequest());
        if (outputStack != null) {
            if (attributes.isPushTop()) {
                outputStack.push(attributes, false);
            }
            return outputStack;
        }
        if (attributes.isAllowCreate()) {
            return GroovyPageOutputStack.createNew(attributes);
        }
        return null;
    }

    private static final GroovyPageOutputStack createNew(GroovyPageOutputStackAttributes attributes) {
        if (attributes.getTopWriter() == null) {
            attributes = new GroovyPageOutputStackAttributes.Builder(attributes).topWriter(GroovyPageOutputStack.lookupRequestWriter(attributes.getWebRequest())).build();
        }
        GroovyPageOutputStack instance = new GroovyPageOutputStack(attributes);
        attributes.getWebRequest().setAttribute(ATTRIBUTE_NAME_OUTPUT_STACK, instance, 0);
        return instance;
    }

    private static GroovyPageOutputStack lookupStack(GrailsWebRequest webRequest) {
        GroovyPageOutputStack outputStack = (GroovyPageOutputStack)webRequest.getAttribute(ATTRIBUTE_NAME_OUTPUT_STACK, 0);
        return outputStack;
    }

    public static final void removeCurrentInstance() {
        RequestContextHolder.currentRequestAttributes().removeAttribute(ATTRIBUTE_NAME_OUTPUT_STACK, 0);
    }

    public static final Writer currentWriter() {
        GroovyPageOutputStack outputStack = GroovyPageOutputStack.currentStack(false);
        if (outputStack != null) {
            return outputStack.getOutWriter();
        }
        return GroovyPageOutputStack.lookupRequestWriter();
    }

    private static Writer lookupRequestWriter() {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        return GroovyPageOutputStack.lookupRequestWriter(webRequest);
    }

    private static Writer lookupRequestWriter(GrailsWebRequest webRequest) {
        if (webRequest != null) {
            return webRequest.getOut();
        }
        return null;
    }

    private GroovyPageOutputStack(GroovyPageOutputStackAttributes attributes) {
        this.outWriter = new GroovyPageProxyWriter(this.writerGroup, new GrailsLazyProxyPrintWriter.DestinationFactory(){

            @Override
            public Writer activateDestination() throws IOException {
                StackEntry stackEntry = (StackEntry)GroovyPageOutputStack.this.stack.peek();
                return GroovyPageOutputStack.this.createEncodingWriter(stackEntry.unwrappedTarget, stackEntry.outEncoder, GroovyPageOutputStack.this.encodingStateRegistry, "scriptlet");
            }
        });
        this.staticWriter = new GroovyPageProxyWriter(this.writerGroup, new GrailsLazyProxyPrintWriter.DestinationFactory(){

            @Override
            public Writer activateDestination() throws IOException {
                StackEntry stackEntry = (StackEntry)GroovyPageOutputStack.this.stack.peek();
                if (stackEntry.staticEncoder == null) {
                    return stackEntry.unwrappedTarget;
                }
                return GroovyPageOutputStack.this.createEncodingWriter(stackEntry.unwrappedTarget, stackEntry.staticEncoder, GroovyPageOutputStack.this.encodingStateRegistry, "staticparts");
            }
        });
        this.expressionWriter = new GroovyPageProxyWriter(this.writerGroup, new GrailsLazyProxyPrintWriter.DestinationFactory(){

            @Override
            public Writer activateDestination() throws IOException {
                StackEntry stackEntry = (StackEntry)GroovyPageOutputStack.this.stack.peek();
                return GroovyPageOutputStack.this.createEncodingWriter(stackEntry.unwrappedTarget, stackEntry.expressionEncoder, GroovyPageOutputStack.this.encodingStateRegistry, "expression");
            }
        });
        this.taglibWriter = new GroovyPageProxyWriter(this.writerGroup, new GrailsLazyProxyPrintWriter.DestinationFactory(){

            @Override
            public Writer activateDestination() throws IOException {
                StackEntry stackEntry = (StackEntry)GroovyPageOutputStack.this.stack.peek();
                return GroovyPageOutputStack.this.createEncodingWriter(stackEntry.unwrappedTarget, stackEntry.taglibEncoder != null ? stackEntry.taglibEncoder : stackEntry.defaultTaglibEncoder, GroovyPageOutputStack.this.encodingStateRegistry, "taglib");
            }
        });
        this.autoSync = attributes.isAutoSync();
        this.push(attributes, false);
        if (!this.autoSync) {
            this.applyWriterThreadLocals(this.outWriter);
        }
        this.encodingStateRegistry = attributes.getWebRequest().getEncodingStateRegistry();
    }

    private Writer unwrapTargetWriter(Writer targetWriter) {
        if (targetWriter instanceof GrailsWrappedWriter && ((GrailsWrappedWriter)((Object)targetWriter)).isAllowUnwrappingOut()) {
            return ((GrailsWrappedWriter)((Object)targetWriter)).unwrap();
        }
        return targetWriter;
    }

    public void push(Writer newWriter) {
        this.push(newWriter, false);
    }

    public void push(Writer newWriter, boolean checkExisting) {
        GroovyPageOutputStackAttributes.Builder attributesBuilder = new GroovyPageOutputStackAttributes.Builder();
        attributesBuilder.inheritPreviousEncoders(true);
        attributesBuilder.topWriter(newWriter);
        this.push(attributesBuilder.build(), checkExisting);
    }

    public void push(GroovyPageOutputStackAttributes attributes) {
        this.push(attributes, false);
    }

    public void push(GroovyPageOutputStackAttributes attributes, boolean checkExisting) {
        this.writerGroup.reset();
        if (checkExisting) {
            this.checkExistingStack(attributes.getTopWriter());
        }
        StackEntry previousStackEntry = null;
        if (this.stack.size() > 0) {
            previousStackEntry = this.stack.peek();
        }
        Writer topWriter = attributes.getTopWriter();
        Writer unwrappedWriter = null;
        if (topWriter != null) {
            if (topWriter instanceof GroovyPageProxyWriter) {
                topWriter = ((GroovyPageProxyWriter)topWriter).getOut();
            }
            unwrappedWriter = this.unwrapTargetWriter(topWriter);
        } else if (previousStackEntry != null) {
            topWriter = previousStackEntry.originalTarget;
            unwrappedWriter = previousStackEntry.unwrappedTarget;
        } else {
            throw new NullPointerException("attributes.getTopWriter() is null and there is no previous stack item");
        }
        StackEntry stackEntry = new StackEntry(topWriter, unwrappedWriter);
        stackEntry.outEncoder = this.applyEncoder(attributes.getOutEncoder(), previousStackEntry != null ? previousStackEntry.outEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        stackEntry.staticEncoder = this.applyEncoder(attributes.getStaticEncoder(), previousStackEntry != null ? previousStackEntry.staticEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        stackEntry.expressionEncoder = this.applyEncoder(attributes.getExpressionEncoder(), previousStackEntry != null ? previousStackEntry.expressionEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        stackEntry.taglibEncoder = this.applyEncoder(attributes.getTaglibEncoder(), previousStackEntry != null ? previousStackEntry.taglibEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        stackEntry.defaultTaglibEncoder = this.applyEncoder(attributes.getDefaultTaglibEncoder(), previousStackEntry != null ? previousStackEntry.defaultTaglibEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        this.stack.push(stackEntry);
        this.resetWriters();
        if (this.autoSync) {
            this.applyWriterThreadLocals(attributes.getTopWriter());
        }
    }

    private Encoder applyEncoder(Encoder newEncoder, Encoder previousEncoder, boolean allowInheriting, boolean replaceOnly) {
        if (newEncoder != null && (!replaceOnly || previousEncoder == null || replaceOnly && previousEncoder.isSafe())) {
            return newEncoder;
        }
        if (allowInheriting) {
            return previousEncoder;
        }
        return null;
    }

    private void checkExistingStack(Writer topWriter) {
        if (topWriter != null) {
            for (StackEntry item : this.stack) {
                if (item.originalTarget != topWriter) continue;
                log.warn((Object)("Pushed a writer to stack a second time. Writer type " + topWriter.getClass().getName()), (Throwable)new Exception());
            }
        }
    }

    private void resetWriters() {
        this.outWriter.setDestinationActivated(false);
        this.staticWriter.setDestinationActivated(false);
        this.expressionWriter.setDestinationActivated(false);
        this.taglibWriter.setDestinationActivated(false);
    }

    private Writer createEncodingWriter(Writer out, Encoder encoder, EncodingStateRegistry encodingStateRegistry, String codecWriterName) {
        Object encodingWriter = out instanceof EncodedAppenderWriterFactory ? ((EncodedAppenderWriterFactory)out).getWriterForEncoder(encoder, encodingStateRegistry) : (encoder instanceof StreamingEncoder ? new StreamingEncoderWriter(out, (StreamingEncoder)encoder, encodingStateRegistry) : new CodecPrintWriter(out, encoder, encodingStateRegistry));
        return encodingWriter;
    }

    public void pop() {
        this.pop(this.autoSync);
    }

    public void pop(boolean forceSync) {
        this.writerGroup.reset();
        this.stack.pop();
        this.resetWriters();
        if (this.stack.size() > 0) {
            StackEntry stackEntry = this.stack.peek();
            if (forceSync) {
                this.applyWriterThreadLocals(stackEntry.originalTarget);
            }
        }
    }

    public GroovyPageProxyWriter getOutWriter() {
        return this.outWriter;
    }

    public GroovyPageProxyWriter getStaticWriter() {
        return this.staticWriter;
    }

    public GroovyPageProxyWriter getExpressionWriter() {
        return this.expressionWriter;
    }

    public GroovyPageProxyWriter getTaglibWriter() {
        return this.taglibWriter;
    }

    public Encoder getOutEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().outEncoder : null;
    }

    public Encoder getStaticEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().staticEncoder : null;
    }

    public Encoder getExpressionEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().expressionEncoder : null;
    }

    public Encoder getTaglibEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().taglibEncoder : null;
    }

    public Encoder getDefaultTaglibEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().defaultTaglibEncoder : null;
    }

    public Writer getCurrentOriginalWriter() {
        return this.stack.peek().originalTarget;
    }

    public void restoreThreadLocalsToOriginals() {
        Writer originalTopWriter = ((StackEntry)this.stack.firstElement()).originalTarget;
        this.applyWriterThreadLocals(originalTopWriter);
    }

    private void applyWriterThreadLocals(Writer writer) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest != null) {
            webRequest.setOut(writer);
        }
    }

    public void flushActiveWriter() {
        this.writerGroup.flushActive();
    }

    public class GroovyPageProxyWriter
    extends GrailsLazyProxyPrintWriter {
        GroovyPageProxyWriterGroup writerGroup;

        GroovyPageProxyWriter(GroovyPageProxyWriterGroup writerGroup, GrailsLazyProxyPrintWriter.DestinationFactory factory) {
            super(factory);
            this.writerGroup = writerGroup;
        }

        public GroovyPageOutputStack getOutputStack() {
            return GroovyPageOutputStack.this;
        }

        @Override
        public Writer getOut() {
            this.writerGroup.activateWriter(this);
            return super.getOut();
        }
    }

    static class GroovyPageProxyWriterGroup {
        GroovyPageProxyWriter activeWriter;

        GroovyPageProxyWriterGroup() {
        }

        void reset() {
            this.activateWriter(null);
        }

        void activateWriter(GroovyPageProxyWriter newWriter) {
            if (newWriter != this.activeWriter) {
                this.flushActive();
                this.activeWriter = newWriter;
            }
        }

        void flushActive() {
            if (this.activeWriter != null) {
                this.activeWriter.flush();
            }
        }
    }

    private static class StackEntry
    implements Cloneable {
        Writer originalTarget;
        Writer unwrappedTarget;
        Encoder staticEncoder;
        Encoder taglibEncoder;
        Encoder defaultTaglibEncoder;
        Encoder outEncoder;
        Encoder expressionEncoder;

        StackEntry(Writer originalTarget, Writer unwrappedTarget) {
            this.originalTarget = originalTarget;
            this.unwrappedTarget = unwrappedTarget;
        }

        public StackEntry clone() {
            StackEntry newEntry = new StackEntry(this.originalTarget, this.unwrappedTarget);
            newEntry.staticEncoder = this.staticEncoder;
            newEntry.outEncoder = this.outEncoder;
            newEntry.taglibEncoder = this.taglibEncoder;
            newEntry.defaultTaglibEncoder = this.defaultTaglibEncoder;
            newEntry.expressionEncoder = this.expressionEncoder;
            return newEntry;
        }
    }
}

