/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderFactory;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderWriter;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderWriterFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;
import org.codehaus.groovy.grails.web.util.CodecPrintWriter;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriterAdapter;
import org.codehaus.groovy.grails.web.util.GrailsWrappedWriter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsPrintWriter
extends Writer
implements GrailsWrappedWriter,
EncodedAppenderWriterFactory,
GroovyObject {
    protected static final Log LOG = LogFactory.getLog(GrailsPrintWriter.class);
    protected static final char[] CRLF = new char[]{'\r', '\n'};
    protected boolean trouble = false;
    protected Writer out;
    protected boolean allowUnwrappingOut = true;
    protected boolean usageFlag = false;
    protected Writer streamCharBufferTarget = null;
    protected Writer previousOut = null;
    private transient MetaClass metaClass = InvokerHelper.getMetaClass(this.getClass());

    public GrailsPrintWriter(Writer out) {
        this.setOut(out);
    }

    @Override
    public boolean isAllowUnwrappingOut() {
        return this.allowUnwrappingOut;
    }

    @Override
    public Writer unwrap() {
        if (this.isAllowUnwrappingOut()) {
            return this.getOut();
        }
        return this;
    }

    public boolean isDestinationActivated() {
        return this.out != null;
    }

    public Writer getOut() {
        return this.out;
    }

    public void setOut(Writer newOut) {
        this.out = this.unwrapWriter(newOut);
        this.lock = this.out != null ? this.out : this;
        this.streamCharBufferTarget = null;
        this.previousOut = null;
    }

    protected Writer unwrapWriter(Writer writer) {
        if (writer instanceof GrailsWrappedWriter) {
            return ((GrailsWrappedWriter)((Object)writer)).unwrap();
        }
        return writer;
    }

    public GrailsPrintWriter leftShift(Object value) throws IOException {
        this.usageFlag = true;
        if (value != null) {
            InvokerHelper.write((Writer)this, (Object)value);
        }
        return this;
    }

    public GrailsPrintWriter plus(Object value) throws IOException {
        this.usageFlag = true;
        return this.leftShift(value);
    }

    public boolean checkError() {
        return this.trouble;
    }

    public void setError() {
        this.trouble = true;
    }

    @Override
    public synchronized void flush() {
        if (this.trouble) {
            return;
        }
        if (this.isDestinationActivated()) {
            try {
                this.getOut().flush();
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        }
    }

    boolean isTrouble() {
        return this.trouble;
    }

    void handleIOException(IOException e) {
        if (this.trouble) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("I/O exception in GrailsPrintWriter: " + e.getMessage()), (Throwable)e);
        }
        this.trouble = true;
        this.setError();
    }

    public void print(Object obj) {
        if (this.trouble || obj == null) {
            this.usageFlag = true;
            return;
        }
        Class<?> clazz = obj.getClass();
        if (clazz == String.class) {
            this.write((String)obj);
        } else if (clazz == StreamCharBuffer.class) {
            this.write((StreamCharBuffer)obj);
        } else if (clazz == GStringImpl.class) {
            this.write((Writable)obj);
        } else if (obj instanceof Writable) {
            this.write((Writable)obj);
        } else if (obj instanceof CharSequence) {
            try {
                this.usageFlag = true;
                this.getOut().append((CharSequence)obj);
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        } else {
            this.write(String.valueOf(obj));
        }
    }

    public void print(String s) {
        if (s == null) {
            this.usageFlag = true;
            return;
        }
        this.write(s);
    }

    @Override
    public void write(String s) {
        this.usageFlag = true;
        if (this.trouble || s == null) {
            return;
        }
        try {
            this.getOut().write(s);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(int c) {
        this.usageFlag = true;
        if (this.trouble) {
            return;
        }
        try {
            this.getOut().write(c);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.usageFlag = true;
        if (this.trouble || buf == null || len == 0) {
            return;
        }
        try {
            this.getOut().write(buf, off, len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        this.usageFlag = true;
        if (this.trouble || s == null || s.length() == 0) {
            return;
        }
        try {
            this.getOut().write(s, off, len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    public void print(boolean b) {
        if (b) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void println() {
        this.usageFlag = true;
        this.write(CRLF);
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(char[] c) {
        this.print(c);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(Object o) {
        this.print(o);
        this.println();
    }

    @Override
    public GrailsPrintWriter append(char c) {
        try {
            this.usageFlag = true;
            this.getOut().append(c);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    @Override
    public GrailsPrintWriter append(CharSequence csq, int start, int end) {
        try {
            this.usageFlag = true;
            this.getOut().append(csq, start, end);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    @Override
    public GrailsPrintWriter append(CharSequence csq) {
        try {
            this.usageFlag = true;
            this.getOut().append(csq);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    public GrailsPrintWriter append(Object obj) {
        this.print(obj);
        return this;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void write(StreamCharBuffer otherBuffer) {
        this.usageFlag = true;
        if (this.trouble) {
            return;
        }
        try {
            otherBuffer.writeTo(this.findStreamCharBufferTarget(true));
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected Writer findStreamCharBufferTarget(boolean markUsed) {
        GrailsWrappedWriter gpr;
        boolean allowCaching = markUsed;
        Writer currentOut = this.getOut();
        if (allowCaching && this.streamCharBufferTarget != null && this.previousOut == currentOut) {
            return this.streamCharBufferTarget;
        }
        Writer target = currentOut;
        while (target instanceof GrailsWrappedWriter && (gpr = (GrailsWrappedWriter)((Object)target)).isAllowUnwrappingOut()) {
            if (markUsed) {
                gpr.markUsed();
            }
            target = gpr.unwrap();
        }
        Writer result = target instanceof StreamCharBuffer.StreamCharBufferWriter ? target : currentOut;
        if (allowCaching) {
            this.streamCharBufferTarget = result;
            this.previousOut = currentOut;
        }
        return result;
    }

    public void print(StreamCharBuffer otherBuffer) {
        this.write(otherBuffer);
    }

    public void append(StreamCharBuffer otherBuffer) {
        this.write(otherBuffer);
    }

    public void println(StreamCharBuffer otherBuffer) {
        this.write(otherBuffer);
        this.println();
    }

    public GrailsPrintWriter leftShift(StreamCharBuffer otherBuffer) {
        if (otherBuffer != null) {
            this.write(otherBuffer);
        }
        return this;
    }

    public void write(Writable writable) {
        this.writeWritable(writable);
    }

    protected void writeWritable(Writable writable) {
        this.usageFlag = true;
        if (this.trouble) {
            return;
        }
        try {
            writable.writeTo(this.getOut());
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public void print(Writable writable) {
        this.writeWritable(writable);
    }

    public GrailsPrintWriter leftShift(Writable writable) {
        this.writeWritable(writable);
        return this;
    }

    public void print(GStringImpl gstring) {
        this.writeWritable((Writable)gstring);
    }

    public GrailsPrintWriter leftShift(GStringImpl gstring) {
        this.writeWritable((Writable)gstring);
        return this;
    }

    public GrailsPrintWriter leftShift(String string) {
        this.print(string);
        return this;
    }

    public boolean isUsed() {
        StreamCharBuffer buffer;
        if (this.usageFlag) {
            return true;
        }
        Writer target = this.findStreamCharBufferTarget(false);
        if (target instanceof StreamCharBuffer.StreamCharBufferWriter && !(buffer = ((StreamCharBuffer.StreamCharBufferWriter)target).getBuffer()).isEmpty()) {
            return true;
        }
        return this.usageFlag;
    }

    public void setUsed(boolean newUsed) {
        this.usageFlag = newUsed;
    }

    public boolean resetUsed() {
        boolean prevUsed = this.usageFlag;
        this.usageFlag = false;
        return prevUsed;
    }

    @Override
    public void close() {
        if (this.isDestinationActivated()) {
            try {
                this.getOut().close();
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        }
    }

    @Override
    public void markUsed() {
        this.setUsed(true);
    }

    public Object asType(Class<?> clazz) {
        if (clazz == PrintWriter.class) {
            return this.asPrintWriter();
        }
        if (clazz == Writer.class) {
            return this;
        }
        return DefaultTypeTransformation.castToType((Object)this, clazz);
    }

    public PrintWriter asPrintWriter() {
        return new GrailsPrintWriterAdapter(this);
    }

    public Writer getWriterForEncoder(Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        EncodedAppender encodedAppender;
        Writer target = null;
        target = this.getOut() instanceof EncodedAppenderWriterFactory && this.getOut() != this ? this.getOut() : this.findStreamCharBufferTarget(false);
        if (target instanceof EncodedAppenderWriterFactory && target != this) {
            return ((EncodedAppenderWriterFactory)target).getWriterForEncoder(encoder, encodingStateRegistry);
        }
        if (target instanceof EncodedAppenderFactory && (encodedAppender = ((EncodedAppenderFactory)target).getEncodedAppender()) != null) {
            return new EncodedAppenderWriter(encodedAppender, encoder, encodingStateRegistry);
        }
        if (target != null) {
            return new CodecPrintWriter(target, encoder, encodingStateRegistry);
        }
        return null;
    }

    public Object getProperty(String property) {
        return this.getMetaClass().getProperty((Object)this, property);
    }

    public void setProperty(String property, Object newValue) {
        this.getMetaClass().setProperty((Object)this, property, newValue);
    }

    public Object invokeMethod(String name, Object args) {
        return this.getMetaClass().invokeMethod((Object)this, name, args);
    }

    public MetaClass getMetaClass() {
        if (this.metaClass == null) {
            this.metaClass = InvokerHelper.getMetaClass(this.getClass());
        }
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

