/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.io.IOException;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.codehaus.groovy.grails.web.util.StringCharArrayAccessor;

public class BoundedCharsAsEncodedBytesCounter {
    private String encoding;
    private int capacity;
    private ByteBuffer bb;
    private CharsetEncoder ce;
    private boolean calculationActive = true;
    private BoundedCharsAsEncodedBytesCounterWriter writer;

    public BoundedCharsAsEncodedBytesCounter() {
    }

    public BoundedCharsAsEncodedBytesCounter(int capacity, String encoding) {
        this.capacity = capacity;
        this.encoding = encoding;
    }

    public void update(String str) {
        if (str.length() == 0) {
            return;
        }
        if (this.calculationActive) {
            this.update(str.toCharArray());
        }
    }

    public void update(char[] buf) {
        this.update(buf, 0, buf.length);
    }

    public void update(char[] buf, int off, int len) {
        if (this.calculationActive && len > 0) {
            try {
                CharBuffer cb = CharBuffer.wrap(buf, off, len);
                this.ce.reset();
                CoderResult cr = this.ce.encode(cb, this.bb, true);
                if (!cr.isUnderflow()) {
                    this.terminateCalculation();
                    return;
                }
                cr = this.ce.flush(this.bb);
                if (!cr.isUnderflow()) {
                    this.terminateCalculation();
                    return;
                }
            }
            catch (BufferOverflowException e) {
                this.terminateCalculation();
            }
            catch (Exception x) {
                this.terminateCalculation();
            }
        }
    }

    private void terminateCalculation() {
        this.calculationActive = false;
        if (this.bb != null) {
            this.bb.clear();
            this.bb = null;
        }
    }

    public int size() {
        if (this.calculationActive) {
            return this.bb.position();
        }
        return -1;
    }

    public boolean isWriterReferenced() {
        return this.writer != null;
    }

    public Writer getCountingWriter() {
        if (this.writer == null) {
            this.ce = Charset.forName(this.encoding).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.bb = ByteBuffer.allocate(this.capacity);
            this.writer = new BoundedCharsAsEncodedBytesCounterWriter();
        }
        return this.writer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    class BoundedCharsAsEncodedBytesCounterWriter
    extends Writer {
        char[] writeBuffer = new char[8192];

        BoundedCharsAsEncodedBytesCounterWriter() {
        }

        public void write(char[] b, int off, int len) throws IOException {
            BoundedCharsAsEncodedBytesCounter.this.update(b, off, len);
        }

        public void close() throws IOException {
        }

        public void write(int b) throws IOException {
            if (!BoundedCharsAsEncodedBytesCounter.this.calculationActive) {
                return;
            }
            this.writeBuffer[0] = (char)b;
            BoundedCharsAsEncodedBytesCounter.this.update(this.writeBuffer, 0, 1);
        }

        public Writer append(CharSequence csq, int start, int end) throws IOException {
            if (!BoundedCharsAsEncodedBytesCounter.this.calculationActive) {
                return this;
            }
            if (csq instanceof StringBuilder || csq instanceof StringBuffer) {
                int len = end - start;
                char[] cbuf = len <= this.writeBuffer.length ? this.writeBuffer : new char[len];
                if (csq instanceof StringBuilder) {
                    ((StringBuilder)csq).getChars(start, end, cbuf, 0);
                } else {
                    ((StringBuffer)csq).getChars(start, end, cbuf, 0);
                }
                this.write(cbuf, 0, len);
            } else {
                this.write(((Object)csq.subSequence(start, end)).toString());
            }
            return this;
        }

        public Writer append(CharSequence csq) throws IOException {
            if (!BoundedCharsAsEncodedBytesCounter.this.calculationActive) {
                return this;
            }
            if (csq == null) {
                this.write("null");
            } else {
                this.append(csq, 0, csq.length());
            }
            return this;
        }

        public void write(String str, int off, int len) throws IOException {
            if (!BoundedCharsAsEncodedBytesCounter.this.calculationActive) {
                return;
            }
            StringCharArrayAccessor.writeStringAsCharArray(this, str, off, len);
        }

        public void write(String str) throws IOException {
            if (!BoundedCharsAsEncodedBytesCounter.this.calculationActive) {
                return;
            }
            StringCharArrayAccessor.writeStringAsCharArray(this, str);
        }

        public void flush() throws IOException {
        }
    }
}

