/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.PageParserSelector;
import com.opensymphony.module.sitemesh.filter.HttpContentType;
import com.opensymphony.module.sitemesh.filter.RoutableServletOutputStream;
import com.opensymphony.module.sitemesh.filter.TextEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.GSPSitemeshPage;
import org.codehaus.groovy.grails.web.sitemesh.GrailsPageFilter;
import org.codehaus.groovy.grails.web.sitemesh.GrailsRoutablePrintWriter;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriterAdapter;
import org.codehaus.groovy.grails.web.util.StreamByteBuffer;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;
import org.codehaus.groovy.grails.web.util.WebUtils;

public class GrailsPageResponseWrapper
extends HttpServletResponseWrapper {
    private final GrailsRoutablePrintWriter routablePrintWriter;
    private final RoutableServletOutputStream routableServletOutputStream;
    private final PageParserSelector parserSelector;
    private final HttpServletRequest request;
    private GrailsBuffer buffer;
    private boolean aborted = false;
    private boolean parseablePage = false;
    private GSPSitemeshPage gspSitemeshPage;

    public GrailsPageResponseWrapper(HttpServletRequest request, final HttpServletResponse response, PageParserSelector parserSelector) {
        super(response);
        this.parserSelector = parserSelector;
        this.routablePrintWriter = new GrailsRoutablePrintWriter(new GrailsRoutablePrintWriter.DestinationFactory(){

            public PrintWriter activateDestination() throws IOException {
                return response.getWriter();
            }
        });
        this.routableServletOutputStream = new RoutableServletOutputStream(new RoutableServletOutputStream.DestinationFactory(){

            public ServletOutputStream create() throws IOException {
                return response.getOutputStream();
            }
        });
        this.request = request;
        this.gspSitemeshPage = (GSPSitemeshPage)((Object)request.getAttribute(GrailsPageFilter.GSP_SITEMESH_PAGE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(int sc) throws IOException {
        this.abortRequest();
        GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
        try {
            super.sendError(sc);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            WebUtils.storeGrailsWebRequest(webRequest);
            throw throwable;
        }
        WebUtils.storeGrailsWebRequest(webRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(int sc, String msg) throws IOException {
        this.abortRequest();
        GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
        try {
            super.sendError(sc, msg);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            WebUtils.storeGrailsWebRequest(webRequest);
            throw throwable;
        }
        WebUtils.storeGrailsWebRequest(webRequest);
    }

    private void abortRequest() {
        this.aborted = true;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (type == null) {
            return;
        }
        HttpContentType httpContentType = new HttpContentType(type);
        if (this.parserSelector.shouldParsePage(httpContentType.getType())) {
            this.activateSiteMesh(httpContentType.getType(), httpContentType.getEncoding());
        } else {
            this.deactivateSiteMesh();
        }
    }

    public void activateSiteMesh(String contentType, String encoding) {
        if (this.parseablePage) {
            return;
        }
        this.buffer = new GrailsBuffer(this.parserSelector.getPageParser(contentType), encoding, this.gspSitemeshPage);
        this.routablePrintWriter.updateDestination(new GrailsRoutablePrintWriter.DestinationFactory(){

            public PrintWriter activateDestination() {
                return GrailsPageResponseWrapper.this.buffer.getWriter();
            }
        });
        this.routablePrintWriter.blockFlushAndClose();
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStream.DestinationFactory(){

            public ServletOutputStream create() {
                return GrailsPageResponseWrapper.this.buffer.getOutputStream();
            }
        });
        this.parseablePage = true;
        this.aborted = false;
    }

    public void deactivateSiteMesh() {
        this.parseablePage = false;
        this.buffer = null;
        if (this.gspSitemeshPage != null) {
            this.gspSitemeshPage.reset();
        }
        this.routablePrintWriter.updateDestination(new GrailsRoutablePrintWriter.DestinationFactory(){

            public PrintWriter activateDestination() throws IOException {
                return GrailsPageResponseWrapper.this.getResponse().getWriter();
            }
        });
        this.routablePrintWriter.unBlockFlushAndClose();
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStream.DestinationFactory(){

            public ServletOutputStream create() throws IOException {
                return GrailsPageResponseWrapper.this.getResponse().getOutputStream();
            }
        });
    }

    public void setContentLength(int contentLength) {
        if (!this.parseablePage) {
            super.setContentLength(contentLength);
        }
    }

    public void flushBuffer() throws IOException {
        if (!this.parseablePage) {
            super.flushBuffer();
        }
    }

    public void setHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (!this.parseablePage || !name.toLowerCase().equals("content-length")) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (!this.parseablePage || !name.toLowerCase().equals("content-length")) {
            super.addHeader(name, value);
        }
    }

    public void setStatus(int sc) {
        if (sc == 304) {
            this.abortRequest();
            this.deactivateSiteMesh();
        } else if (sc >= 400) {
            this.abortRequest();
        }
        super.setStatus(sc);
    }

    public ServletOutputStream getOutputStream() {
        return this.routableServletOutputStream;
    }

    public PrintWriter getWriter() {
        return this.routablePrintWriter;
    }

    public Page getPage() throws IOException {
        if (this.isSitemeshNotActive()) {
            return null;
        }
        GSPSitemeshPage page = (GSPSitemeshPage)((Object)this.request.getAttribute(GrailsPageFilter.GSP_SITEMESH_PAGE));
        if (page != null && page.isUsed()) {
            return page;
        }
        return this.buffer.parse();
    }

    public void sendRedirect(String location) throws IOException {
        this.abortRequest();
        super.sendRedirect(location);
    }

    public boolean isUsingStream() {
        return this.buffer != null && this.buffer.isUsingStream();
    }

    public char[] getContents() throws IOException {
        if (this.isSitemeshNotActive()) {
            return null;
        }
        return this.buffer.getContents();
    }

    public boolean isSitemeshActive() {
        return !this.isSitemeshNotActive();
    }

    public boolean isGspSitemeshActive() {
        return this.gspSitemeshPage != null && this.gspSitemeshPage.isUsed();
    }

    private boolean isSitemeshNotActive() {
        return this.aborted || !this.parseablePage;
    }

    private static class GrailsBuffer {
        private final PageParser pageParser;
        private final String encoding;
        private static final TextEncoder TEXT_ENCODER = new TextEncoder();
        private StreamCharBuffer charBuffer;
        private GrailsPrintWriterAdapter exposedWriter;
        private StreamByteBuffer byteBuffer;
        private ServletOutputStream exposedStream;
        private GSPSitemeshPage gspSitemeshPage;

        public GrailsBuffer(PageParser pageParser, String encoding, GSPSitemeshPage gspSitemeshPage) {
            this.pageParser = pageParser;
            this.encoding = encoding;
            this.gspSitemeshPage = gspSitemeshPage;
        }

        private char[] getContents() throws IOException {
            if (this.charBuffer != null) {
                return this.charBuffer.toCharArray();
            }
            if (this.byteBuffer != null) {
                return TEXT_ENCODER.encode(this.byteBuffer.readAsByteArray(), this.encoding);
            }
            return new char[0];
        }

        public Page parse() throws IOException {
            return this.pageParser.parse(this.getContents());
        }

        public PrintWriter getWriter() {
            if (this.charBuffer == null) {
                if (this.byteBuffer != null) {
                    throw new IllegalStateException("response.getWriter() called after response.getOutputStream()");
                }
                this.charBuffer = new StreamCharBuffer();
                this.charBuffer.setNotifyParentBuffersEnabled(false);
                if (this.gspSitemeshPage != null) {
                    this.gspSitemeshPage.setPageBuffer(this.charBuffer);
                }
                this.exposedWriter = new GrailsPrintWriterAdapter(this.charBuffer.getWriter());
            }
            return this.exposedWriter;
        }

        public ServletOutputStream getOutputStream() {
            if (this.byteBuffer == null) {
                if (this.charBuffer != null) {
                    throw new IllegalStateException("response.getOutputStream() called after response.getWriter()");
                }
                this.byteBuffer = new StreamByteBuffer();
                final OutputStream out = this.byteBuffer.getOutputStream();
                this.exposedStream = new ServletOutputStream(){

                    public void write(byte[] b, int off, int len) throws IOException {
                        out.write(b, off, len);
                    }

                    public void write(byte[] b) throws IOException {
                        out.write(b);
                    }

                    public void write(int b) throws IOException {
                        out.write(b);
                    }
                };
            }
            return this.exposedStream;
        }

        public boolean isUsingStream() {
            return this.byteBuffer != null;
        }
    }
}

