/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import grails.util.GrailsNameUtils;
import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderWriterFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageBinding;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.pages.discovery.GrailsConventionGroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageScriptSource;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;
import org.codehaus.groovy.grails.web.util.CodecPrintWriter;
import org.codehaus.groovy.grails.web.util.WithCodecHelper;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPagesTemplateRenderer
implements InitializingBean {
    private GrailsConventionGroovyPageLocator groovyPageLocator;
    private GroovyPagesTemplateEngine groovyPagesTemplateEngine;
    private ConcurrentMap<String, TemplateRendererCacheEntry> templateCache = new ConcurrentHashMap<String, TemplateRendererCacheEntry>();
    private Object scaffoldingTemplateGenerator;
    private Map<String, Collection<String>> scaffoldedActionMap;
    private Map<String, GrailsDomainClass> controllerToScaffoldedDomainClassMap;
    private Method generateViewMethod;
    private boolean reloadEnabled;
    private boolean disableCache = Environment.isDevelopmentMode();

    public void afterPropertiesSet() throws Exception {
        if (this.scaffoldingTemplateGenerator != null) {
            this.generateViewMethod = ReflectionUtils.findMethod(this.scaffoldingTemplateGenerator.getClass(), (String)"generateView", (Class[])new Class[]{GrailsDomainClass.class, String.class, Writer.class});
        }
        this.reloadEnabled = this.groovyPagesTemplateEngine.isReloadEnabled();
    }

    public void clearCache() {
        this.templateCache.clear();
    }

    public void render(GrailsWebRequest webRequest, GroovyPageBinding pageScope, Map<String, Object> attrs, Object body, Writer out) throws IOException {
        String pluginName;
        Assert.state((this.groovyPagesTemplateEngine != null ? 1 : 0) != 0, (String)"Property [groovyPagesTemplateEngine] must be set!");
        String templateName = this.getStringValue(attrs, "template");
        if (StringUtils.isBlank((String)templateName)) {
            throw new GrailsTagException("Tag [render] is missing required attribute [template]");
        }
        String uri = webRequest.getAttributes().getTemplateUri(templateName, (ServletRequest)webRequest.getRequest());
        String contextPath = this.getStringValue(attrs, "contextPath");
        Template t = this.findAndCacheTemplate(webRequest, pageScope, templateName, contextPath, pluginName = this.getStringValue(attrs, "plugin"), uri);
        if (t == null) {
            throw new GrailsTagException("Template not found for name [" + templateName + "] and path [" + uri + "]");
        }
        this.makeTemplate(webRequest, t, attrs, body, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template findAndCacheTemplate(GrailsWebRequest webRequest, GroovyPageBinding pageScope, String templateName, String contextPath, String pluginName, String uri) throws IOException {
        String templatePath = StringUtils.isNotEmpty((String)contextPath) ? GrailsResourceUtils.appendPiecesForUri((String[])new String[]{contextPath, templateName}) : templateName;
        GroovyPageScriptSource scriptSource = pluginName == null ? this.groovyPageLocator.findTemplateInBinding(templatePath, pageScope) : this.groovyPageLocator.findTemplateInBinding(pluginName, templatePath, pageScope);
        String cacheKey = scriptSource == null ? contextPath + pluginName + uri : scriptSource.getURI();
        TemplateRendererCacheEntry cacheEntry = (TemplateRendererCacheEntry)this.templateCache.get(cacheKey);
        if (cacheEntry != null && cacheEntry.isValid()) {
            return cacheEntry.template;
        }
        Template t = null;
        try {
            if (cacheEntry != null) {
                cacheEntry.getLock().lock();
                if (cacheEntry.isValid()) {
                    t = cacheEntry.template;
                }
            }
            if (t == null) {
                boolean allowCaching;
                if (scriptSource != null) {
                    t = this.groovyPagesTemplateEngine.createTemplate(scriptSource);
                }
                boolean bl = allowCaching = !this.disableCache;
                if (t == null && this.scaffoldingTemplateGenerator != null) {
                    t = this.generateScaffoldedTemplate(webRequest, uri);
                    allowCaching = true;
                }
                if (t != null && allowCaching) {
                    if (cacheEntry == null) {
                        this.templateCache.put(cacheKey, new TemplateRendererCacheEntry(t, this.reloadEnabled));
                    } else {
                        cacheEntry.setTemplate(t);
                    }
                }
            }
        }
        finally {
            if (cacheEntry != null) {
                cacheEntry.getLock().unlock();
            }
        }
        return t;
    }

    private void makeTemplate(GrailsWebRequest webRequest, Template t, Map<String, Object> attrs, Object body, Writer out) throws IOException {
        Writer newOut = this.wrapWriterWithEncoder(webRequest, attrs, out);
        boolean writerWrapped = newOut != out;
        out = newOut;
        String var = this.getStringValue(attrs, "var");
        LinkedHashMap<String, Object> b = new LinkedHashMap<String, Object>();
        b.put("body", body);
        if (attrs.get("model") instanceof Map) {
            b.putAll((Map)attrs.get("model"));
        }
        if (attrs.containsKey("bean")) {
            if (StringUtils.isNotBlank((String)var)) {
                b.put(var, attrs.get("bean"));
            } else {
                b.put("it", attrs.get("bean"));
            }
        }
        if (attrs.containsKey("collection")) {
            String key = null;
            Iterator iterator = InvokerHelper.asIterator((Object)attrs.get("collection"));
            while (iterator.hasNext()) {
                Object it = iterator.next();
                if (key == null && StringUtils.isBlank((String)var) && it != null) {
                    key = GrailsNameUtils.getPropertyName(it.getClass());
                }
                LinkedHashMap<String, Object> itmap = new LinkedHashMap<String, Object>();
                itmap.putAll(b);
                if (StringUtils.isNotBlank((String)var)) {
                    itmap.put(var, it);
                } else {
                    itmap.put("it", it);
                    itmap.put(key, it);
                }
                t.make(itmap).writeTo(out);
            }
        } else {
            t.make(b).writeTo(out);
        }
        if (writerWrapped) {
            out.flush();
        }
    }

    private Writer wrapWriterWithEncoder(GrailsWebRequest webRequest, Map<String, Object> attrs, Writer out) {
        Map<String, Object> codecSettings;
        String codecForTaglibs;
        Object encodeAs = attrs.get("encodeAs");
        if (encodeAs != null && (codecForTaglibs = (String)(codecSettings = WithCodecHelper.makeSettingsCanonical(encodeAs)).get("taglib")) != null) {
            Encoder encoder = WithCodecHelper.lookupEncoder(webRequest.getAttributes().getGrailsApplication(), codecForTaglibs);
            out = out instanceof EncodedAppenderWriterFactory ? ((EncodedAppenderWriterFactory)out).getWriterForEncoder(encoder, webRequest.getEncodingStateRegistry()) : new CodecPrintWriter(out, encoder, webRequest.getEncodingStateRegistry());
        }
        return out;
    }

    private Template generateScaffoldedTemplate(GrailsWebRequest webRequest, String uri) throws IOException {
        GrailsDomainClass domainClass;
        Template t = null;
        Collection<String> controllerActions = this.scaffoldedActionMap.get(webRequest.getControllerName());
        if (controllerActions != null && controllerActions.contains(webRequest.getActionName()) && (domainClass = this.controllerToScaffoldedDomainClassMap.get(webRequest.getControllerName())) != null) {
            String scaffoldedtemplateName;
            int i = uri.lastIndexOf(47);
            String string = scaffoldedtemplateName = i > -1 ? uri.substring(i) : uri;
            if (scaffoldedtemplateName.toLowerCase().endsWith(".gsp")) {
                scaffoldedtemplateName = scaffoldedtemplateName.substring(0, scaffoldedtemplateName.length() - 4);
            }
            FastStringWriter sw = new FastStringWriter();
            ReflectionUtils.invokeMethod((Method)this.generateViewMethod, (Object)this.scaffoldingTemplateGenerator, (Object[])new Object[]{domainClass, scaffoldedtemplateName, sw});
            t = this.groovyPagesTemplateEngine.createTemplate(sw.toString(), uri);
        }
        return t;
    }

    private String getStringValue(Map<String, Object> attrs, String key) {
        Object val = attrs.get(key);
        if (val == null) {
            return "";
        }
        return String.valueOf(val);
    }

    public void setGroovyPageLocator(GrailsConventionGroovyPageLocator locator) {
        this.groovyPageLocator = locator;
    }

    public void setGroovyPagesTemplateEngine(GroovyPagesTemplateEngine engine) {
        this.groovyPagesTemplateEngine = engine;
    }

    public void setScaffoldingTemplateGenerator(Object generator) {
        this.scaffoldingTemplateGenerator = generator;
    }

    public void setScaffoldedActionMap(Map map) {
        this.scaffoldedActionMap = map;
    }

    public void setControllerToScaffoldedDomainClassMap(Map map) {
        this.controllerToScaffoldedDomainClassMap = map;
    }

    private static class TemplateRendererCacheEntry {
        private long timestamp = System.currentTimeMillis();
        private Template template;
        private boolean reloadEnabled;
        private final Lock lock = new ReentrantLock();

        public TemplateRendererCacheEntry(Template t, boolean reloadEnabled) {
            this.template = t;
            this.reloadEnabled = reloadEnabled;
        }

        public Lock getLock() {
            return this.lock;
        }

        public boolean isValid() {
            return !this.reloadEnabled || System.currentTimeMillis() - this.timestamp < GroovyPageMetaInfo.LASTMODIFIED_CHECK_INTERVAL;
        }

        public void setTemplate(Template template) {
            this.template = template;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

