/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class HiddenHttpMethodFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_METHOD_PARAM = "_method";
    private String methodParam = "_method";
    public static final String HEADER_X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";

    public void setMethodParam(String methodParam) {
        Assert.hasText((String)methodParam, (String)"'methodParam' must not be empty");
        this.methodParam = methodParam;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            String httpMethod = this.getHttpMethodOverride(request);
            if (StringUtils.hasLength((String)httpMethod)) {
                filterChain.doFilter((ServletRequest)new HttpMethodRequestWrapper(httpMethod, request), (ServletResponse)response);
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected String getHttpMethodOverride(HttpServletRequest request) {
        String httpMethod = request.getParameter(this.methodParam);
        if (httpMethod == null) {
            httpMethod = request.getHeader(HEADER_X_HTTP_METHOD_OVERRIDE);
        }
        return httpMethod != null ? httpMethod.toUpperCase() : null;
    }

    private static class HttpMethodRequestWrapper
    extends HttpServletRequestWrapper {
        private final String method;

        public HttpMethodRequestWrapper(String method, HttpServletRequest request) {
            super(request);
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

