/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.binding;

import grails.util.Environment;
import grails.validation.ValidationErrors;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.web.binding.GrailsDataBinder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBindingUtils {
    private static final String BLANK = "";
    private static final Map<Class, List> CLASS_TO_BINDING_INCLUDE_LIST = new ConcurrentHashMap<Class, List>();

    public static void assignBidirectionalAssociations(Object object, Map source, GrailsDomainClass domainClass) {
        if (source == null) {
            return;
        }
        for (Object key : source.keySet()) {
            GrailsDomainClassProperty prop;
            String propertyName = key.toString();
            if (propertyName.indexOf(46) > -1) {
                propertyName = propertyName.substring(0, propertyName.indexOf(46));
            }
            if (!domainClass.hasPersistentProperty(propertyName) || (prop = domainClass.getPropertyByName(propertyName)) == null || !prop.isOneToOne() || !prop.isBidirectional()) continue;
            Object val = source.get(key);
            GrailsDomainClassProperty otherSide = prop.getOtherSide();
            if (val == null || otherSide == null) continue;
            MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(val.getClass());
            try {
                mc.setProperty(val, otherSide.getName(), object);
            }
            catch (Exception e) {}
        }
    }

    public static BindingResult bindObjectToInstance(Object object, Object source) {
        return DataBindingUtils.bindObjectToInstance(object, source, DataBindingUtils.getBindingIncludeList(object), Collections.EMPTY_LIST, null);
    }

    private static List getBindingIncludeList(Object object) {
        List includeList = Collections.EMPTY_LIST;
        try {
            Class<?> objectClass = object.getClass();
            if (CLASS_TO_BINDING_INCLUDE_LIST.containsKey(objectClass)) {
                includeList = CLASS_TO_BINDING_INCLUDE_LIST.get(objectClass);
            } else {
                Object whiteListValue;
                Field whiteListField = objectClass.getDeclaredField("$defaultDatabindingWhiteList");
                if (whiteListField != null && (whiteListField.getModifiers() & 8) != 0 && (whiteListValue = whiteListField.get(objectClass)) instanceof List) {
                    includeList = (List)whiteListValue;
                }
                if (!Environment.getCurrent().isReloadEnabled()) {
                    CLASS_TO_BINDING_INCLUDE_LIST.put(objectClass, includeList);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return includeList;
    }

    public static BindingResult bindObjectToDomainInstance(GrailsDomainClass domain, Object object, Object source) {
        return DataBindingUtils.bindObjectToDomainInstance(domain, object, source, DataBindingUtils.getBindingIncludeList(object), Collections.EMPTY_LIST, null);
    }

    public static BindingResult bindObjectToInstance(Object object, Object source, List include, List exclude, String filter) {
        if (include == null && exclude == null) {
            include = DataBindingUtils.getBindingIncludeList(object);
        }
        GrailsApplication application = GrailsWebRequest.lookupApplication();
        GrailsDomainClass domain = null;
        if (application != null) {
            domain = (GrailsDomainClass)application.getArtefact("Domain", object.getClass().getName());
        }
        return DataBindingUtils.bindObjectToDomainInstance(domain, object, source, include, exclude, filter);
    }

    public static BindingResult bindObjectToDomainInstance(GrailsDomainClass domain, Object object, Object source, List include, List exclude, String filter) {
        MetaClass mc;
        GrailsDataBinder binder;
        BindingResult bindingResult = null;
        if (source instanceof GrailsParameterMap) {
            GrailsParameterMap parameterMap = (GrailsParameterMap)source;
            HttpServletRequest request = parameterMap.getRequest();
            GrailsDataBinder dataBinder = DataBindingUtils.createDataBinder(object, include, exclude, request);
            dataBinder.bind(parameterMap, filter);
            bindingResult = dataBinder.getBindingResult();
        } else if (source instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)source;
            GrailsDataBinder dataBinder = DataBindingUtils.createDataBinder(object, include, exclude, request);
            DataBindingUtils.performBindFromRequest(dataBinder, request, filter);
            bindingResult = dataBinder.getBindingResult();
        } else if (source instanceof Map) {
            Map propertyMap = (Map)source;
            propertyMap = DataBindingUtils.convertPotentialGStrings(propertyMap);
            binder = DataBindingUtils.createDataBinder(object, include, exclude, null);
            DataBindingUtils.performBindFromPropertyValues(binder, new MutablePropertyValues(propertyMap), filter);
            bindingResult = binder.getBindingResult();
        } else {
            GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
            if (webRequest != null) {
                binder = DataBindingUtils.createDataBinder(object, include, exclude, webRequest.getCurrentRequest());
                HttpServletRequest request = webRequest.getCurrentRequest();
                DataBindingUtils.performBindFromRequest(binder, request, filter);
            }
        }
        if (domain != null && bindingResult != null) {
            ValidationErrors newResult = new ValidationErrors(object);
            for (ObjectError error : bindingResult.getAllErrors()) {
                if (error instanceof FieldError) {
                    FieldError fieldError = (FieldError)error;
                    boolean isBlank = BLANK.equals(fieldError.getRejectedValue());
                    if (!isBlank) {
                        newResult.addError((ObjectError)fieldError);
                        continue;
                    }
                    if (domain.hasPersistentProperty(fieldError.getField())) {
                        boolean isOptional = domain.getPropertyByName(fieldError.getField()).isOptional();
                        if (isOptional) continue;
                        newResult.addError((ObjectError)fieldError);
                        continue;
                    }
                    newResult.addError((ObjectError)fieldError);
                    continue;
                }
                newResult.addError(error);
            }
            bindingResult = newResult;
        }
        if ((mc = GroovySystem.getMetaClassRegistry().getMetaClass(object.getClass())).hasProperty(object, "errors") != null && bindingResult != null) {
            ValidationErrors errors = new ValidationErrors(object);
            errors.addAllErrors((Errors)bindingResult);
            mc.setProperty(object, "errors", (Object)errors);
        }
        return bindingResult;
    }

    private static void performBindFromPropertyValues(GrailsDataBinder binder, MutablePropertyValues mutablePropertyValues, String filter) {
        if (filter != null) {
            binder.bind((PropertyValues)mutablePropertyValues, filter);
        } else {
            binder.bind((PropertyValues)mutablePropertyValues);
        }
    }

    private static void performBindFromRequest(GrailsDataBinder binder, HttpServletRequest request, String filter) {
        if (filter != null) {
            binder.bind((ServletRequest)request, filter);
        } else {
            binder.bind((ServletRequest)request);
        }
    }

    private static GrailsDataBinder createDataBinder(Object object, List include, List exclude, HttpServletRequest request) {
        GrailsDataBinder binder = request != null ? GrailsDataBinder.createBinder(object, object.getClass().getName(), request) : GrailsDataBinder.createBinder(object, object.getClass().getName());
        DataBindingUtils.includeExcludeFields(binder, include, exclude);
        return binder;
    }

    private static Map convertPotentialGStrings(Map<Object, Object> args) {
        HashMap<Object, Object> newArgs = new HashMap<Object, Object>(args.size());
        for (Map.Entry<Object, Object> entry : args.entrySet()) {
            newArgs.put(DataBindingUtils.unwrapGString(entry.getKey()), DataBindingUtils.unwrapGString(entry.getValue()));
        }
        return newArgs;
    }

    private static Object unwrapGString(Object value) {
        if (value instanceof CharSequence) {
            return value.toString();
        }
        return value;
    }

    private static void includeExcludeFields(GrailsDataBinder dataBinder, List allowed, List disallowed) {
        DataBindingUtils.updateAllowed(dataBinder, allowed);
        DataBindingUtils.updateDisallowed(dataBinder, disallowed);
    }

    private static void updateAllowed(GrailsDataBinder binder, List allowed) {
        if (allowed == null) {
            return;
        }
        Object[] currentAllowed = binder.getAllowedFields();
        ArrayList newAllowed = new ArrayList(allowed);
        CollectionUtils.addAll(newAllowed, (Object[])currentAllowed);
        String[] value = new String[newAllowed.size()];
        newAllowed.toArray(value);
        binder.setAllowedFields(value);
    }

    private static void updateDisallowed(GrailsDataBinder binder, List disallowed) {
        if (disallowed == null) {
            return;
        }
        Object[] currentDisallowed = binder.getDisallowedFields();
        ArrayList newDisallowed = new ArrayList(disallowed);
        CollectionUtils.addAll(newDisallowed, (Object[])currentDisallowed);
        String[] value = new String[newDisallowed.size()];
        newDisallowed.toArray(value);
        binder.setDisallowedFields(value);
    }
}

