/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import grails.util.GrailsUtil;
import groovy.lang.GroovyClassLoader;
import groovy.text.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.compiler.web.pages.GroovyPageClassLoader;
import org.codehaus.groovy.grails.exceptions.DefaultStackTracePrinter;
import org.codehaus.groovy.grails.support.ResourceAwareTemplateEngine;
import org.codehaus.groovy.grails.web.errors.GrailsExceptionResolver;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.pages.GroovyPageParser;
import org.codehaus.groovy.grails.web.pages.GroovyPageTemplate;
import org.codehaus.groovy.grails.web.pages.GroovyPagesMetaUtils;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.discovery.DefaultGroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageCompiledScriptSource;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageResourceScriptSource;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageScriptSource;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.ServletContextResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPagesTemplateEngine
extends ResourceAwareTemplateEngine
implements ApplicationContextAware,
ServletContextAware,
InitializingBean {
    public static final String CONFIG_PROPERTY_DISABLE_CACHING_RESOURCES = "grails.gsp.disable.caching.resources";
    public static final String CONFIG_PROPERTY_GSP_ENABLE_RELOAD = "grails.gsp.enable.reload";
    public static final String BEAN_ID = "groovyPagesTemplateEngine";
    private static final String GENERATED_GSP_NAME_PREFIX = "gsp_script_";
    private static final Log LOG;
    private static File dumpLineNumbersTo;
    private Map<String, GroovyPageMetaInfo> pageCache = new ConcurrentHashMap<String, GroovyPageMetaInfo>();
    private ClassLoader classLoader;
    private int scriptNameCount;
    private GroovyPageLocator groovyPageLocator = new DefaultGroovyPageLocator();
    private boolean reloadEnabled;
    private TagLibraryLookup tagLibraryLookup;
    private TagLibraryResolver jspTagLibraryResolver;
    private boolean cacheResources = true;
    private GrailsApplication grailsApplication;
    private Map<String, Class<?>> cachedDomainsWithoutPackage;
    private ServletContext servletContext;

    public GroovyPagesTemplateEngine() {
    }

    @Deprecated
    public GroovyPagesTemplateEngine(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setGroovyPageLocator(GroovyPageLocator groovyPageLocator) {
        this.groovyPageLocator = groovyPageLocator;
    }

    public GroovyPageLocator getGroovyPageLocator() {
        return this.groovyPageLocator;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.groovyPageLocator.addResourceLoader(resourceLoader);
    }

    public void afterPropertiesSet() {
        if (this.classLoader == null) {
            this.classLoader = this.initGroovyClassLoader(Thread.currentThread().getContextClassLoader());
        } else if (!this.classLoader.getClass().equals(GroovyPageClassLoader.class)) {
            this.classLoader = new GroovyPageClassLoader(this.classLoader);
        }
        if (!Environment.isDevelopmentMode()) {
            this.cachedDomainsWithoutPackage = this.createDomainClassMap();
        }
    }

    private GroovyClassLoader initGroovyClassLoader(ClassLoader parent) {
        CompilerConfiguration compConfig = new CompilerConfiguration();
        compConfig.setSourceEncoding("UTF-8");
        return new GroovyPageClassLoader(parent, compConfig);
    }

    public void setTagLibraryLookup(TagLibraryLookup tagLibraryLookup) {
        this.tagLibraryLookup = tagLibraryLookup;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int[] calculateLineNumbersForPage(ServletContext context, String url) {
        try {
            Template t = this.createTemplate(url);
            if (t instanceof GroovyPageTemplate) {
                return ((GroovyPageTemplate)t).getMetaInfo().getLineNumbers();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception retrieving line numbers from GSP: " + url + ", message: " + e.getMessage()));
            LOG.debug((Object)"Full stack trace of error", (Throwable)e);
        }
        return new int[0];
    }

    @Override
    public Template createTemplate(Resource resource) {
        return this.createTemplate(resource, this.cacheResources);
    }

    @Override
    public Template createTemplate(Resource resource, boolean cacheable) {
        if (resource == null) {
            GrailsWebRequest webRequest = this.getWebRequest();
            throw new GroovyPagesException("No Groovy page found for URI: " + this.getCurrentRequestUri(webRequest.getCurrentRequest()));
        }
        String name = cacheable ? this.establishPageName(resource, this.getPathForResource(resource)) : this.establishPageName(resource, null);
        if (!this.isReloadEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating template using resource " + resource), (Throwable)new Exception("Creating template using resource " + resource));
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Creating template using resource " + resource));
            }
        }
        if (cacheable && this.pageCache.containsKey(name)) {
            GroovyPageMetaInfo meta = this.pageCache.get(name);
            if (this.isGroovyPageReloadable(resource, meta)) {
                try {
                    return this.createTemplateWithResource(resource, cacheable);
                }
                catch (IOException e) {
                    throw new GroovyPagesException("I/O error reading stream for resource [" + resource + "]: " + e.getMessage(), e);
                }
            }
            return new GroovyPageTemplate(meta);
        }
        try {
            return this.createTemplateWithResource(resource, cacheable);
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O error reading stream for resource [" + resource + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public Template createTemplate(String uri) {
        return this.createTemplateForUri(uri);
    }

    private Template createTemplateFromPrecompiled(GroovyPageCompiledScriptSource compiledScriptSource) {
        GroovyPageResourceScriptSource changedResourceScriptSource;
        GroovyPageMetaInfo meta = this.initializeCompiledMetaInfo(compiledScriptSource.getGroovyPageMetaInfo());
        if (this.isReloadEnabled() && (changedResourceScriptSource = compiledScriptSource.getReloadableScriptSource()) != null) {
            this.groovyPageLocator.removePrecompiledPage(compiledScriptSource);
            return this.createTemplate(changedResourceScriptSource);
        }
        return new GroovyPageTemplate(meta);
    }

    private GroovyPageMetaInfo initializeCompiledMetaInfo(GroovyPageMetaInfo meta) {
        meta.initializeOnDemand(new GroovyPageMetaInfo.GroovyPageMetaInfoInitializer(){

            public void initialize(GroovyPageMetaInfo metaInfo) {
                metaInfo.setGrailsApplication(GroovyPagesTemplateEngine.this.grailsApplication);
                metaInfo.setJspTagLibraryResolver(GroovyPagesTemplateEngine.this.jspTagLibraryResolver);
                metaInfo.setTagLibraryLookup(GroovyPagesTemplateEngine.this.tagLibraryLookup);
                metaInfo.initialize();
                GroovyPagesMetaUtils.registerMethodMissingForGSP(metaInfo.getPageClass(), GroovyPagesTemplateEngine.this.tagLibraryLookup);
            }
        });
        return meta;
    }

    public Template createTemplateForUri(String uri) {
        return this.createTemplateForUri(new String[]{uri});
    }

    public Template createTemplateForUri(String[] uris) {
        GroovyPageScriptSource scriptSource = this.findScriptSource(uris);
        if (scriptSource != null) {
            return this.createTemplate(scriptSource);
        }
        return null;
    }

    public GroovyPageScriptSource findScriptSource(String uri) {
        return this.findScriptSource(new String[]{uri});
    }

    public GroovyPageScriptSource findScriptSource(String[] uris) {
        String uri;
        GroovyPageScriptSource scriptSource = null;
        String[] arr$ = uris;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (scriptSource = this.groovyPageLocator.findPage(uri = arr$[i$])) == null; ++i$) {
        }
        return scriptSource;
    }

    public Template createTemplate(ScriptSource scriptSource) {
        if (scriptSource instanceof GroovyPageCompiledScriptSource) {
            return this.createTemplateFromPrecompiled((GroovyPageCompiledScriptSource)scriptSource);
        }
        if (scriptSource instanceof ResourceScriptSource) {
            ResourceScriptSource resourceSource = (ResourceScriptSource)scriptSource;
            Resource resource = resourceSource.getResource();
            return this.createTemplate(resource, true);
        }
        try {
            return this.createTemplate(scriptSource.getScriptAsString(), scriptSource.suggestedClassName());
        }
        catch (IOException e) {
            throw new RuntimeException("IOException in createTemplate", e);
        }
    }

    public Template createTemplate(String txt, String pageName) throws IOException {
        Assert.hasLength((String)txt, (String)"Argument [txt] cannot be null or blank");
        Assert.hasLength((String)pageName, (String)"Argument [pageName] cannot be null or blank");
        return this.createTemplate((Resource)new ByteArrayResource(txt.getBytes("UTF-8"), pageName), pageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createTemplate(Resource resource, String pageName) throws IOException {
        Template template;
        InputStream in = resource.getInputStream();
        try {
            template = this.createTemplate(in, resource, pageName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return template;
    }

    public Template createTemplate() {
        GrailsWebRequest webRequest = this.getWebRequest();
        String uri = this.getCurrentRequestUri(webRequest.getCurrentRequest());
        return this.createTemplate(uri);
    }

    @Override
    public Template createTemplate(File file) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new FileSystemResource(file));
    }

    @Override
    public Template createTemplate(URL url) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new UrlResource(url));
    }

    @Override
    public Template createTemplate(InputStream inputStream) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, null, null);
        return new GroovyPageTemplate(metaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createTemplateWithResource(Resource resource, boolean cacheable) throws IOException {
        InputStream in;
        block3: {
            Template template;
            in = resource.getInputStream();
            try {
                if (!cacheable) break block3;
                template = this.createTemplate(in, resource, this.getPathForResource(resource));
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return template;
        }
        Template template = this.createTemplate(in, resource, null);
        Object var6_7 = null;
        in.close();
        return template;
    }

    protected Template createTemplate(InputStream inputStream, Resource resource, String pageName) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, resource, pageName);
        return new GroovyPageTemplate(metaInfo);
    }

    private boolean isGroovyPageReloadable(final Resource resource, GroovyPageMetaInfo meta) {
        return this.isReloadEnabled() && meta.shouldReload(new PrivilegedAction<Resource>(){

            @Override
            public Resource run() {
                return resource;
            }
        });
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean b) {
        this.reloadEnabled = b;
    }

    public Resource getResourceForUri(String uri) {
        GroovyPageScriptSource scriptSource = this.getResourceWithinContext(uri);
        if (scriptSource != null && scriptSource instanceof GroovyPageResourceScriptSource) {
            return ((GroovyPageResourceScriptSource)scriptSource).getResource();
        }
        return new ServletContextResource(this.servletContext, uri);
    }

    private GroovyPageScriptSource getResourceWithinContext(String uri) {
        Assert.state((this.groovyPageLocator != null ? 1 : 0) != 0, (String)"TemplateEngine not initialised correctly, no [groovyPageLocator] specified!");
        GroovyPageScriptSource scriptSource = this.groovyPageLocator.findPage(uri);
        if (scriptSource != null) {
            return scriptSource;
        }
        return null;
    }

    protected GroovyPageMetaInfo buildPageMetaInfo(InputStream inputStream, Resource res, String pageName) {
        GroovyPageParser parser;
        String name = this.establishPageName(res, pageName);
        String path = this.getPathForResource(res);
        try {
            Map config;
            Object gspEnc;
            String encoding = "UTF-8";
            if (this.grailsApplication != null && (gspEnc = (config = this.grailsApplication.getFlatConfig()).get("grails.views.gsp.encoding")) != null && gspEnc.toString().trim().length() > 0) {
                encoding = gspEnc.toString();
            }
            parser = new GroovyPageParser(name, path, path, inputStream, encoding);
            if (this.grailsApplication != null) {
                Object keepDirObj;
                config = this.grailsApplication.getFlatConfig();
                Object sitemeshPreprocessEnabled = config.get("grails.views.gsp.sitemesh.preprocess");
                if (sitemeshPreprocessEnabled != null) {
                    boolean enableSitemeshPreprocessing = BooleanUtils.toBoolean((String)String.valueOf(sitemeshPreprocessEnabled).trim());
                    parser.setEnableSitemeshPreprocessing(enableSitemeshPreprocessing);
                }
                if ((keepDirObj = config.get("grails.views.gsp.keepgenerateddir")) instanceof File) {
                    parser.setKeepGeneratedDirectory((File)keepDirObj);
                } else if (keepDirObj != null) {
                    parser.setKeepGeneratedDirectory(new File(String.valueOf(keepDirObj)));
                }
            }
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O parsing Groovy page [" + (res != null ? res.getDescription() : name) + "]: " + e.getMessage(), e);
        }
        InputStream in = parser.parse();
        GroovyPageMetaInfo metaInfo = this.createPageMetaInfo(parser, in);
        metaInfo.applyLastModifiedFromResource(res);
        try {
            metaInfo.setPageClass(this.compileGroovyPage(in, name, path, metaInfo));
            metaInfo.setHtmlParts(parser.getHtmlPartsArray());
        }
        catch (GroovyPagesException e) {
            metaInfo.setCompilationException(e);
        }
        if (!name.startsWith(GENERATED_GSP_NAME_PREFIX)) {
            this.pageCache.put(name, metaInfo);
        }
        return metaInfo;
    }

    private String getPathForResource(Resource res) {
        if (res == null) {
            return "";
        }
        String path = null;
        try {
            File file = res.getFile();
            if (file != null) {
                path = file.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (path != null) {
            return path;
        }
        if (res.getDescription() != null) {
            return res.getDescription();
        }
        return "";
    }

    private Class<?> compileGroovyPage(InputStream in, String name, String pageName, GroovyPageMetaInfo metaInfo) {
        Class scriptClass;
        GroovyClassLoader groovyClassLoader = this.findOrInitGroovyClassLoader();
        try {
            String groovySource = DefaultGroovyMethods.getText((InputStream)in, (String)"UTF-8");
            scriptClass = groovyClassLoader.parseClass(groovySource, name);
        }
        catch (CompilationFailedException e) {
            LOG.error((Object)("Compilation error compiling GSP [" + name + "]:" + e.getMessage()), (Throwable)e);
            int lineNumber = GrailsExceptionResolver.extractLineNumber(e);
            int[] lineMappings = metaInfo.getLineNumbers();
            if (lineNumber > 0 && lineNumber < lineMappings.length) {
                lineNumber = lineMappings[lineNumber - 1];
            }
            String relativePageName = DefaultStackTracePrinter.makeRelativeIfPossible((String)pageName);
            throw new GroovyPagesException("Could not parse script [" + relativePageName + "]: " + e.getMessage(), e, lineNumber, pageName);
        }
        catch (IOException e) {
            String relativePageName = DefaultStackTracePrinter.makeRelativeIfPossible((String)pageName);
            throw new GroovyPagesException("IO exception parsing script [" + relativePageName + "]: " + e.getMessage(), e);
        }
        GroovyPagesMetaUtils.registerMethodMissingForGSP(scriptClass, this.tagLibraryLookup);
        return scriptClass;
    }

    private synchronized GroovyClassLoader findOrInitGroovyClassLoader() {
        if (!(this.classLoader instanceof GroovyClassLoader)) {
            this.classLoader = this.initGroovyClassLoader(this.classLoader);
        }
        return (GroovyClassLoader)this.classLoader;
    }

    private GroovyPageMetaInfo createPageMetaInfo(GroovyPageParser parse, InputStream in) {
        GroovyPageMetaInfo pageMeta;
        block4: {
            pageMeta = new GroovyPageMetaInfo();
            pageMeta.setGrailsApplication(this.grailsApplication);
            pageMeta.setJspTagLibraryResolver(this.jspTagLibraryResolver);
            pageMeta.setTagLibraryLookup(this.tagLibraryLookup);
            pageMeta.setContentType(parse.getContentType());
            pageMeta.setLineNumbers(parse.getLineNumberMatrix());
            pageMeta.setJspTags(parse.getJspTags());
            pageMeta.setCodecName(parse.getDefaultCodecDirectiveValue());
            pageMeta.initialize();
            if (GrailsUtil.isDevelopmentEnv()) {
                pageMeta.setGroovySource(in);
            }
            if (dumpLineNumbersTo != null) {
                String fileName = parse.getClassName() + "_linenumbers.data";
                File file = new File(dumpLineNumbersTo, fileName);
                try {
                    parse.writeLineNumbers(file);
                }
                catch (IOException ignored) {
                    if (!file.exists()) break block4;
                    file.delete();
                }
            }
        }
        return pageMeta;
    }

    private GrailsWebRequest getWebRequest() {
        return (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
    }

    protected String establishPageName(Resource res, String pageName) {
        if (res == null) {
            return this.generateTemplateName();
        }
        try {
            String name;
            String string = name = pageName != null ? pageName : res.getURL().getPath();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            return name.replaceAll("[^\\w\\d]", "_");
        }
        catch (IllegalStateException e) {
            return this.generateTemplateName();
        }
        catch (IOException ioex) {
            return this.generateTemplateName();
        }
    }

    private synchronized String generateTemplateName() {
        return GENERATED_GSP_NAME_PREFIX + ++this.scriptNameCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext.containsBean("grailsApplication")) {
            this.grailsApplication = (GrailsApplication)applicationContext.getBean("grailsApplication", GrailsApplication.class);
        }
    }

    protected String getCurrentRequestUri(HttpServletRequest request) {
        Object includePath = request.getAttribute("javax.servlet.include.servlet_path");
        if (includePath != null) {
            return (String)includePath;
        }
        return request.getServletPath();
    }

    protected String getUriWithinGrailsViews(String relativeUri) {
        StringBuilder buf = new StringBuilder();
        if (relativeUri.startsWith("/")) {
            relativeUri = relativeUri.substring(1);
        }
        String[] tokens = relativeUri.indexOf(47) > -1 ? relativeUri.split("/") : new String[]{relativeUri};
        buf.append("/WEB-INF/grails-app/views");
        for (String token : tokens) {
            buf.append('/').append(token);
        }
        if (!relativeUri.endsWith(".gsp")) {
            buf.append(".gsp");
        }
        return buf.toString();
    }

    public void clearPageCache() {
        this.pageCache.clear();
    }

    public boolean isCacheResources() {
        return this.cacheResources;
    }

    public void setCacheResources(boolean cacheResources) {
        this.cacheResources = cacheResources;
    }

    public Map<String, Class<?>> getDomainClassMap() {
        if (this.cachedDomainsWithoutPackage != null) {
            return this.cachedDomainsWithoutPackage;
        }
        return this.createDomainClassMap();
    }

    private Map<String, Class<?>> createDomainClassMap() {
        HashMap domainsWithoutPackage = new HashMap();
        if (this.grailsApplication != null) {
            GrailsClass[] domainClasses;
            for (GrailsClass domainClass : domainClasses = this.grailsApplication.getArtefacts("Domain")) {
                Class theClass = domainClass.getClazz();
                domainsWithoutPackage.put(theClass.getName(), theClass);
            }
        }
        return domainsWithoutPackage;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    static {
        File dir;
        LOG = LogFactory.getLog(GroovyPagesTemplateEngine.class);
        String dirPath = System.getProperty("grails.dump.gsp.line.numbers.to.dir");
        if (dirPath != null && ((dir = new File(dirPath)).exists() || dir.mkdirs())) {
            dumpLineNumbersTo = dir;
        }
    }
}

