/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.web.servlet.GrailsUrlPathHelper;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.SimpleGrailsControllerHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.util.UrlPathHelper;

public class SimpleGrailsController
implements Controller,
ServletContextAware {
    private UrlPathHelper urlPathHelper = new GrailsUrlPathHelper();
    private GrailsApplication application = null;
    private ServletContext servletContext;
    private static final Log LOG = LogFactory.getLog(SimpleGrailsController.class);

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[SimpleGrailsController] Processing request for uri [" + uri + "]"));
        }
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        Assert.state((boolean)(ra instanceof GrailsWebRequest), (String)"Bound RequestContext is not an instance of GrailsWebRequest");
        GrailsWebRequest webRequest = (GrailsWebRequest)ra;
        ApplicationContext context = webRequest.getAttributes().getApplicationContext();
        SimpleGrailsControllerHelper helper = new SimpleGrailsControllerHelper(this.application, context, this.servletContext);
        ModelAndView mv = helper.handleURI(uri, webRequest);
        if (mv != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("[SimpleGrailsController] Forwarding model and view [" + mv + "] with class [" + (mv.getView() != null ? mv.getView().getClass().getName() : mv.getViewName()) + "]"));
        }
        return mv;
    }

    public void setGrailsApplication(GrailsApplication application) {
        this.application = application;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

