/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroovyPageMetaInfo {
    private static final Log LOG = LogFactory.getLog(GroovyPageMetaInfo.class);
    private TagLibraryLookup tagLibraryLookup;
    private TagLibraryResolver jspTagLibraryResolver;
    private boolean precompiledMode = false;
    private Class<?> pageClass;
    private long lastModified;
    private InputStream groovySource;
    private String contentType;
    private int[] lineNumbers;
    private String[] htmlParts;
    private Map jspTags = Collections.EMPTY_MAP;
    private GroovyPagesException compilationException;
    private String codecName;
    private Class<?> codecClass;
    public static final String HTML_DATA_POSTFIX = "_html.data";
    public static final String LINENUMBERS_DATA_POSTFIX = "_linenumbers.data";
    private long latestLastModifiedCheck = 0L;
    public static final long LASTMODIFIED_CHECK_INTERVAL = Long.getLong("grails.gsp.reload.interval", 5000L);
    private static final long LASTMODIFIED_CHECK_GRANULARITY = Long.getLong("grails.gsp.reload.granularity", 2000L);

    public GroovyPageMetaInfo() {
        this.latestLastModifiedCheck = System.currentTimeMillis();
    }

    public GroovyPageMetaInfo(Class<?> pageClass) {
        this.precompiledMode = true;
        this.pageClass = pageClass;
        this.contentType = (String)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"CONTENT_TYPE"), null);
        this.jspTags = (Map)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"JSP_TAGS"), null);
        this.lastModified = (Long)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"LAST_MODIFIED"), null);
        this.codecName = (String)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"DEFAULT_CODEC"), null);
        this.initCodec();
        try {
            this.readHtmlData();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading html data for page class " + pageClass, e);
        }
    }

    public void initCodec() {
        Object o;
        Map config;
        if (this.codecName == null && (config = ConfigurationHolder.getFlatConfig()) != null && (o = config.get("grails.views.default.codec")) != null) {
            this.codecName = o.toString();
        }
        GrailsClass codecGrailsClass = null;
        GrailsApplication app = ApplicationHolder.getApplication();
        if (this.codecName != null && app != null && (codecGrailsClass = app.getArtefactByLogicalPropertyName("Codec", this.codecName)) == null) {
            codecGrailsClass = app.getArtefactByLogicalPropertyName("Codec", this.codecName.toUpperCase());
        }
        if (codecGrailsClass == null && StringUtils.isNotBlank((String)this.codecName) && !"none".equalsIgnoreCase(this.codecName)) {
            LOG.warn((Object)("Couldn't initialize Codec by name '" + this.codecName + "' , pageClass=" + this.pageClass.getName()));
        }
        if (codecGrailsClass != null) {
            this.codecClass = codecGrailsClass.getClazz();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHtmlData() throws IOException {
        String dataResourceName = this.resolveDataResourceName(HTML_DATA_POSTFIX);
        DataInputStream input = null;
        try {
            input = new DataInputStream(this.pageClass.getResourceAsStream(dataResourceName));
            int arrayLen = input.readInt();
            this.htmlParts = new String[arrayLen];
            for (int i = 0; i < arrayLen; ++i) {
                this.htmlParts[i] = input.readUTF();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLineNumbers() throws IOException {
        String dataResourceName = this.resolveDataResourceName(LINENUMBERS_DATA_POSTFIX);
        DataInputStream input = null;
        try {
            input = new DataInputStream(this.pageClass.getResourceAsStream(dataResourceName));
            int arrayLen = input.readInt();
            this.lineNumbers = new int[arrayLen];
            for (int i = 0; i < arrayLen; ++i) {
                this.lineNumbers[i] = input.readInt();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    private String resolveDataResourceName(String postfix) {
        String dataResourceName = this.pageClass.getName();
        int pos = dataResourceName.lastIndexOf(46);
        if (pos > -1) {
            dataResourceName = dataResourceName.substring(pos + 1);
        }
        dataResourceName = dataResourceName + postfix;
        return dataResourceName;
    }

    public TagLibraryLookup getTagLibraryLookup() {
        return this.tagLibraryLookup;
    }

    public void setTagLibraryLookup(TagLibraryLookup tagLibraryLookup) {
        this.tagLibraryLookup = tagLibraryLookup;
    }

    public TagLibraryResolver getJspTagLibraryResolver() {
        return this.jspTagLibraryResolver;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public Class<?> getPageClass() {
        return this.pageClass;
    }

    public void setPageClass(Class<?> pageClass) {
        this.pageClass = pageClass;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public InputStream getGroovySource() {
        return this.groovySource;
    }

    public void setGroovySource(InputStream groovySource) {
        this.groovySource = groovySource;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int[] getLineNumbers() {
        if (this.precompiledMode) {
            return this.getPrecompiledLineNumbers();
        }
        return this.lineNumbers;
    }

    private synchronized int[] getPrecompiledLineNumbers() {
        if (this.lineNumbers == null) {
            try {
                this.readLineNumbers();
            }
            catch (IOException e) {
                LOG.warn((Object)"Problem reading precompiled linenumbers", (Throwable)e);
            }
        }
        return this.lineNumbers;
    }

    public void setLineNumbers(int[] lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public void setJspTags(Map jspTags) {
        this.jspTags = jspTags != null ? jspTags : Collections.EMPTY_MAP;
    }

    public Map getJspTags() {
        return this.jspTags;
    }

    public void setCompilationException(GroovyPagesException e) {
        this.compilationException = e;
    }

    public GroovyPagesException getCompilationException() {
        return this.compilationException;
    }

    public String[] getHtmlParts() {
        return this.htmlParts;
    }

    public void setHtmlParts(String[] htmlParts) {
        this.htmlParts = htmlParts;
    }

    public Class<?> getCodecClass() {
        return this.codecClass;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public void setCodecName(String codecName) {
        this.codecName = codecName;
    }

    public void applyLastModifiedFromResource(Resource resource) {
        this.lastModified = this.establishLastModified(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long establishLastModified(Resource resource) {
        long lastModified;
        if (resource == null) {
            return -1L;
        }
        if (resource instanceof FileSystemResource) {
            return ((FileSystemResource)resource).getFile().lastModified();
        }
        URLConnection urlc = null;
        try {
            File file;
            URL url = resource.getURL();
            if ("file".equals(url.getProtocol()) && (file = new File(url.getFile())).exists()) {
                long l = file.lastModified();
                return l;
            }
            urlc = url.openConnection();
            urlc.setDoInput(false);
            urlc.setDoOutput(false);
            lastModified = urlc.getLastModified();
        }
        catch (FileNotFoundException fnfe) {
            lastModified = -1L;
        }
        catch (IOException e) {
            lastModified = -1L;
        }
        finally {
            if (urlc != null) {
                try {
                    InputStream is = urlc.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return lastModified;
    }

    public synchronized boolean shouldReload(PrivilegedAction<Resource> resourceCallable) {
        long now = System.currentTimeMillis();
        if (Environment.isDevelopmentMode() || now - this.latestLastModifiedCheck > LASTMODIFIED_CHECK_INTERVAL) {
            long currentLastmodified;
            this.latestLastModifiedCheck = now;
            Resource resource = resourceCallable.run();
            if (resource != null && resource.exists() && (currentLastmodified = this.establishLastModified(resource)) > 0L && Math.abs(currentLastmodified - this.lastModified) > LASTMODIFIED_CHECK_GRANULARITY) {
                return true;
            }
        }
        return false;
    }

    public boolean isPrecompiledMode() {
        return this.precompiledMode;
    }
}

